/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.elem;

import java.util.function.Function;
import net.thevpc.nuts.elem.NElementTypeGroup;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NEnumUtils;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NOptional;

public enum NElementType implements NEnum
{
    NULL,
    BIG_COMPLEX,
    DOUBLE_COMPLEX,
    FLOAT_COMPLEX,
    BIG_DECIMAL,
    BIG_INT,
    DOUBLE,
    FLOAT,
    LONG,
    INT,
    SHORT,
    BYTE,
    DOUBLE_QUOTED_STRING,
    SINGLE_QUOTED_STRING,
    ANTI_QUOTED_STRING,
    TRIPLE_DOUBLE_QUOTED_STRING,
    TRIPLE_SINGLE_QUOTED_STRING,
    TRIPLE_ANTI_QUOTED_STRING,
    LINE_STRING,
    REGEX,
    NAME,
    CHAR,
    INSTANT,
    BOOLEAN,
    ARRAY,
    OBJECT,
    CUSTOM,
    PAIR,
    LOCAL_DATETIME,
    LOCAL_DATE,
    LOCAL_TIME,
    BINARY_STREAM,
    CHAR_STREAM,
    UPLET,
    MATRIX,
    ALIAS,
    OP_PLUS,
    OP_PLUS2,
    OP_PLUS3,
    OP_MINUS,
    OP_MINUS2,
    OP_MINUS3,
    OP_MUL,
    OP_MUL2,
    OP_MUL3,
    OP_DIV,
    OP_HAT,
    OP_HAT2,
    OP_HAT3,
    OP_REM,
    OP_REM2,
    OP_REM3,
    OP_EQ,
    OP_EQ2,
    OP_EQ3,
    OP_TILDE,
    OP_TILDE2,
    OP_TILDE3,
    OP_LT,
    OP_LT2,
    OP_LT3,
    OP_GT,
    OP_GT2,
    OP_GT3,
    OP_LTE,
    OP_GTE,
    OP_COLON_EQ,
    OP_COLON_EQ2,
    OP_MINUS_GT,
    OP_MINUS2_GT,
    OP_EQ_GT,
    OP_EQ2_GT,
    OP_LT_MINUS2,
    OP_LT_EQ2,
    OP_PIPE,
    OP_PIPE2,
    OP_PIPE3,
    OP_AND,
    OP_AND2,
    OP_AND3,
    OP_HASH,
    OP_HASH2,
    OP_HASH3,
    OP_HASH4,
    OP_HASH5,
    OP_HASH6,
    OP_HASH7,
    OP_HASH8,
    OP_HASH9,
    OP_HASH10,
    OP_AT2,
    NAMED_ARRAY,
    NAMED_PARAMETRIZED_ARRAY,
    NAMED_OBJECT,
    NAMED_PARAMETRIZED_OBJECT,
    NAMED_UPLET,
    NAMED_MATRIX,
    NAMED_PARAMETRIZED_MATRIX,
    PARAMETRIZED_MATRIX,
    PARAMETRIZED_ARRAY,
    PARAMETRIZED_OBJECT;

    private final String id = NNameFormat.ID_NAME.format(this.name());

    public static NOptional<NElementType> parse(String value) {
        return NEnumUtils.parseEnum(value, NElementType.class, new Function<NEnumUtils.EnumValue, NOptional<NElementType>>(){

            @Override
            public NOptional<NElementType> apply(NEnumUtils.EnumValue enumValue) {
                switch (enumValue.getValue().trim()) {
                    case "+": {
                        return NOptional.of(OP_PLUS);
                    }
                    case "++": {
                        return NOptional.of(OP_PLUS2);
                    }
                    case "+++": {
                        return NOptional.of(OP_PLUS3);
                    }
                    case "-": {
                        return NOptional.of(OP_MINUS);
                    }
                    case "--": {
                        return NOptional.of(OP_MINUS2);
                    }
                    case "---": {
                        return NOptional.of(OP_MINUS3);
                    }
                    case "*": {
                        return NOptional.of(OP_MUL);
                    }
                    case "**": {
                        return NOptional.of(OP_MUL2);
                    }
                    case "***": {
                        return NOptional.of(OP_MUL3);
                    }
                    case "/": {
                        return NOptional.of(OP_DIV);
                    }
                    case "^": {
                        return NOptional.of(OP_HAT);
                    }
                    case "^^": {
                        return NOptional.of(OP_HAT2);
                    }
                    case "^^^": {
                        return NOptional.of(OP_HAT3);
                    }
                    case "%": {
                        return NOptional.of(OP_REM);
                    }
                    case "%%": {
                        return NOptional.of(OP_REM2);
                    }
                    case "%%%": {
                        return NOptional.of(OP_REM3);
                    }
                    case "=": {
                        return NOptional.of(OP_EQ);
                    }
                    case "==": {
                        return NOptional.of(OP_EQ2);
                    }
                    case "===": {
                        return NOptional.of(OP_EQ3);
                    }
                    case "~": {
                        return NOptional.of(OP_TILDE);
                    }
                    case "~~": {
                        return NOptional.of(OP_TILDE2);
                    }
                    case "~~~": {
                        return NOptional.of(OP_TILDE3);
                    }
                    case "<": {
                        return NOptional.of(OP_LT);
                    }
                    case "<<": {
                        return NOptional.of(OP_LT2);
                    }
                    case "<<<": {
                        return NOptional.of(OP_LT3);
                    }
                    case ">": {
                        return NOptional.of(OP_GT);
                    }
                    case ">>": {
                        return NOptional.of(OP_GT2);
                    }
                    case ">>>": {
                        return NOptional.of(OP_GT3);
                    }
                    case "<=": {
                        return NOptional.of(OP_LTE);
                    }
                    case ">=": {
                        return NOptional.of(OP_GTE);
                    }
                    case ":=": {
                        return NOptional.of(OP_COLON_EQ);
                    }
                    case ":==": {
                        return NOptional.of(OP_COLON_EQ2);
                    }
                    case "->": {
                        return NOptional.of(OP_MINUS_GT);
                    }
                    case "-->": {
                        return NOptional.of(OP_MINUS2_GT);
                    }
                    case "=>": {
                        return NOptional.of(OP_EQ_GT);
                    }
                    case "==>": {
                        return NOptional.of(OP_EQ2_GT);
                    }
                    case "<--": {
                        return NOptional.of(OP_LT_MINUS2);
                    }
                    case "<==": {
                        return NOptional.of(OP_LT_EQ2);
                    }
                    case "|": {
                        return NOptional.of(OP_PIPE);
                    }
                    case "||": {
                        return NOptional.of(OP_PIPE2);
                    }
                    case "|||": {
                        return NOptional.of(OP_PIPE3);
                    }
                    case "&": {
                        return NOptional.of(OP_AND);
                    }
                    case "&&": {
                        return NOptional.of(OP_AND2);
                    }
                    case "&&&": {
                        return NOptional.of(OP_AND3);
                    }
                    case "#": {
                        return NOptional.of(OP_HASH);
                    }
                    case "##": {
                        return NOptional.of(OP_HASH2);
                    }
                    case "###": {
                        return NOptional.of(OP_HASH3);
                    }
                    case "#####": {
                        return NOptional.of(OP_HASH4);
                    }
                    case "######": {
                        return NOptional.of(OP_HASH5);
                    }
                    case "#######": {
                        return NOptional.of(OP_HASH6);
                    }
                    case "########": {
                        return NOptional.of(OP_HASH7);
                    }
                    case "#########": {
                        return NOptional.of(OP_HASH8);
                    }
                    case "##########": {
                        return NOptional.of(OP_HASH9);
                    }
                    case "###########": {
                        return NOptional.of(OP_HASH10);
                    }
                    case "@@": {
                        return NOptional.of(OP_AT2);
                    }
                }
                switch (enumValue.getNormalizedValue()) {
                    case "PLUS": {
                        return NOptional.of(OP_PLUS);
                    }
                    case "PLUS2": {
                        return NOptional.of(OP_PLUS2);
                    }
                    case "PLUS3": {
                        return NOptional.of(OP_PLUS3);
                    }
                    case "MINUS": {
                        return NOptional.of(OP_MINUS);
                    }
                    case "MINUS2": {
                        return NOptional.of(OP_MINUS2);
                    }
                    case "MINUS3": {
                        return NOptional.of(OP_MINUS3);
                    }
                    case "MUL": {
                        return NOptional.of(OP_MUL);
                    }
                    case "MUL2": {
                        return NOptional.of(OP_MUL2);
                    }
                    case "MUL3": {
                        return NOptional.of(OP_MUL3);
                    }
                    case "DIV": {
                        return NOptional.of(OP_DIV);
                    }
                    case "HAT": {
                        return NOptional.of(OP_HAT);
                    }
                    case "HAT2": {
                        return NOptional.of(OP_HAT2);
                    }
                    case "HAT3": {
                        return NOptional.of(OP_HAT3);
                    }
                    case "REM": {
                        return NOptional.of(OP_REM);
                    }
                    case "REM2": {
                        return NOptional.of(OP_REM2);
                    }
                    case "REM3": {
                        return NOptional.of(OP_REM3);
                    }
                    case "EQ": {
                        return NOptional.of(OP_EQ);
                    }
                    case "EQ2": {
                        return NOptional.of(OP_EQ2);
                    }
                    case "EQ3": {
                        return NOptional.of(OP_EQ3);
                    }
                    case "TILDE": {
                        return NOptional.of(OP_TILDE);
                    }
                    case "TILDE2": {
                        return NOptional.of(OP_TILDE2);
                    }
                    case "TILDE3": {
                        return NOptional.of(OP_TILDE3);
                    }
                    case "LT": {
                        return NOptional.of(OP_LT);
                    }
                    case "LT2": {
                        return NOptional.of(OP_LT2);
                    }
                    case "LT3": {
                        return NOptional.of(OP_LT3);
                    }
                    case "GT": {
                        return NOptional.of(OP_GT);
                    }
                    case "GT2": {
                        return NOptional.of(OP_GT2);
                    }
                    case "GT3": {
                        return NOptional.of(OP_GT3);
                    }
                    case "LTE": {
                        return NOptional.of(OP_LTE);
                    }
                    case "GTE": {
                        return NOptional.of(OP_GTE);
                    }
                    case "ASSIGN": {
                        return NOptional.of(OP_COLON_EQ);
                    }
                    case "ASSIGN_EQ": {
                        return NOptional.of(OP_COLON_EQ2);
                    }
                    case "MINUS_GT": {
                        return NOptional.of(OP_MINUS_GT);
                    }
                    case "MINUS2_GT": {
                        return NOptional.of(OP_MINUS2_GT);
                    }
                    case "EQ_GT": {
                        return NOptional.of(OP_EQ_GT);
                    }
                    case "EQ2_GT": {
                        return NOptional.of(OP_EQ2_GT);
                    }
                    case "LT_MINUS2": {
                        return NOptional.of(OP_LT_MINUS2);
                    }
                    case "LT_EQ2": {
                        return NOptional.of(OP_LT_EQ2);
                    }
                    case "PIPE": {
                        return NOptional.of(OP_PIPE);
                    }
                    case "PIPE2": {
                        return NOptional.of(OP_PIPE2);
                    }
                    case "PIPE3": {
                        return NOptional.of(OP_PIPE3);
                    }
                    case "AND": {
                        return NOptional.of(OP_AND);
                    }
                    case "AND2": {
                        return NOptional.of(OP_AND2);
                    }
                    case "AND3": {
                        return NOptional.of(OP_AND3);
                    }
                    case "HASH": {
                        return NOptional.of(OP_HASH);
                    }
                    case "HASH2": {
                        return NOptional.of(OP_HASH2);
                    }
                    case "HASH3": {
                        return NOptional.of(OP_HASH3);
                    }
                    case "HASH4": {
                        return NOptional.of(OP_HASH4);
                    }
                    case "HASH5": {
                        return NOptional.of(OP_HASH5);
                    }
                    case "HASH6": {
                        return NOptional.of(OP_HASH6);
                    }
                    case "HASH7": {
                        return NOptional.of(OP_HASH7);
                    }
                    case "HASH8": {
                        return NOptional.of(OP_HASH8);
                    }
                    case "HASH9": {
                        return NOptional.of(OP_HASH9);
                    }
                    case "HASH10": {
                        return NOptional.of(OP_HASH10);
                    }
                    case "AT2": {
                        return NOptional.of(OP_AT2);
                    }
                }
                return null;
            }
        });
    }

    public boolean isAnyFloatingNumber() {
        switch (this.ordinal()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyOrdinalNumber() {
        switch (this.ordinal()) {
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyNumber() {
        switch (this.ordinal()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String id() {
        return this.id;
    }

    public boolean isAnyOp() {
        switch (this.ordinal()) {
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyPrimitive() {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 35: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyStream() {
        switch (this.ordinal()) {
            case 31: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyString() {
        switch (this.ordinal()) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyStringOrName() {
        switch (this.ordinal()) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyDate() {
        switch (this.ordinal()) {
            case 22: 
            case 28: 
            case 29: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyDecimalNumber() {
        switch (this.ordinal()) {
            case 4: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyBigNumber() {
        switch (this.ordinal()) {
            case 1: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyNamed() {
        switch (this.ordinal()) {
            case 27: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyParametrized() {
        switch (this.ordinal()) {
            case 92: 
            case 94: 
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyLocalTemporal() {
        switch (this.ordinal()) {
            case 28: 
            case 29: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyTemporal() {
        switch (this.ordinal()) {
            case 22: 
            case 28: 
            case 29: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyComplexNumber() {
        switch (this.ordinal()) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyNamedObject() {
        switch (this.ordinal()) {
            case 93: 
            case 94: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyNamedArray() {
        switch (this.ordinal()) {
            case 93: 
            case 94: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyNamedMatrix() {
        switch (this.ordinal()) {
            case 96: 
            case 97: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyParametrizedObject() {
        switch (this.ordinal()) {
            case 94: 
            case 100: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyParametrizedArray() {
        switch (this.ordinal()) {
            case 94: 
            case 100: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyParametrizedMatrix() {
        switch (this.ordinal()) {
            case 97: 
            case 98: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyArray() {
        switch (this.ordinal()) {
            case 24: 
            case 91: 
            case 97: 
            case 99: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyObject() {
        switch (this.ordinal()) {
            case 25: 
            case 93: 
            case 94: 
            case 100: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyMatrix() {
        switch (this.ordinal()) {
            case 34: 
            case 96: 
            case 97: 
            case 98: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyUplet() {
        switch (this.ordinal()) {
            case 33: 
            case 95: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnyListContainer() {
        switch (this.ordinal()) {
            case 24: 
            case 25: 
            case 33: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 99: 
            case 100: {
                return true;
            }
        }
        return false;
    }

    public NElementTypeGroup typeGroup() {
        switch (this.ordinal()) {
            case 0: {
                return NElementTypeGroup.NULL;
            }
            case 23: {
                return NElementTypeGroup.BOOLEAN;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return NElementTypeGroup.NUMBER;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                return NElementTypeGroup.STRING;
            }
            case 19: {
                return NElementTypeGroup.REGEX;
            }
            case 20: {
                return NElementTypeGroup.NAME;
            }
            case 22: 
            case 28: 
            case 29: 
            case 30: {
                return NElementTypeGroup.TEMPORAL;
            }
            case 24: 
            case 25: 
            case 27: 
            case 33: 
            case 34: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                return NElementTypeGroup.CONTAINER;
            }
            case 31: 
            case 32: {
                return NElementTypeGroup.STREAM;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return NElementTypeGroup.OPERATOR;
            }
            case 26: {
                return NElementTypeGroup.CUSTOM;
            }
            case 35: {
                return NElementTypeGroup.OTHER;
            }
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String opSymbol() {
        NAssert.requireTrue(this.isAnyOp(), "type as op");
        switch (this.ordinal()) {
            case 36: {
                return "+";
            }
            case 37: {
                return "++";
            }
            case 38: {
                return "+++";
            }
            case 39: {
                return "-";
            }
            case 40: {
                return "--";
            }
            case 41: {
                return "---";
            }
            case 42: {
                return "*";
            }
            case 43: {
                return "**";
            }
            case 44: {
                return "***";
            }
            case 45: {
                return "/";
            }
            case 46: {
                return "^";
            }
            case 47: {
                return "^^";
            }
            case 48: {
                return "^^^";
            }
            case 49: {
                return "%";
            }
            case 50: {
                return "%%";
            }
            case 51: {
                return "%%%";
            }
            case 52: {
                return "=";
            }
            case 53: {
                return "==";
            }
            case 54: {
                return "===";
            }
            case 55: {
                return "~";
            }
            case 56: {
                return "~~";
            }
            case 57: {
                return "~~~";
            }
            case 58: {
                return "<";
            }
            case 59: {
                return "<<";
            }
            case 60: {
                return "<<<";
            }
            case 61: {
                return ">";
            }
            case 62: {
                return ">>";
            }
            case 63: {
                return ">>>";
            }
            case 64: {
                return "<=";
            }
            case 65: {
                return ">=";
            }
            case 66: {
                return ":=";
            }
            case 67: {
                return ":==";
            }
            case 68: {
                return "->";
            }
            case 69: {
                return "-->";
            }
            case 70: {
                return "=>";
            }
            case 71: {
                return "==>";
            }
            case 72: {
                return "<--";
            }
            case 73: {
                return "<==";
            }
            case 74: {
                return "|";
            }
            case 75: {
                return "||";
            }
            case 76: {
                return "|||";
            }
            case 77: {
                return "&";
            }
            case 78: {
                return "&&";
            }
            case 79: {
                return "&&&";
            }
            case 80: {
                return "#";
            }
            case 81: {
                return "##";
            }
            case 82: {
                return "###";
            }
            case 83: {
                return "#####";
            }
            case 84: {
                return "######";
            }
            case 85: {
                return "#######";
            }
            case 86: {
                return "########";
            }
            case 87: {
                return "#########";
            }
            case 88: {
                return "#########";
            }
            case 89: {
                return "##########";
            }
            case 90: {
                return "@@";
            }
        }
        NAssert.requireTrue(false, "type as op");
        return "";
    }
}

