/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.elem;

import java.lang.reflect.Array;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribable;
import net.thevpc.nuts.elem.NElements;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.elem.NObjectElementBuilder;
import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NExceptions;

public interface NElementDescribables {
    public static Supplier<NElement> ofLateString(Supplier<String> name) {
        return name == null ? null : () -> NElement.ofString((String)name.get());
    }

    public static Supplier<NElement> ofLateToString(Object any) {
        return () -> NElement.ofString(String.valueOf(any));
    }

    public static Supplier<NElement> ofDesc(Object any) {
        return () -> {
            if (any == null) {
                return null;
            }
            NElement v = NElementDescribables.describeResolveOrNull(any);
            if (v != null) {
                return v;
            }
            return NElement.ofString(String.valueOf(any));
        };
    }

    public static Supplier<NElement> ofDesc(String name) {
        return name == null ? null : () -> NElement.ofString(name);
    }

    public static Supplier<NElement> ofDesc(NElement element) {
        return element == null ? null : () -> element;
    }

    public static NElement safeDescribeOfBase(Supplier<NElement> description, Object base) {
        return NElementDescribables.safeDescribe(description, base == null ? null : NElementDescribables.ofDesc(base), base == null ? null : NElementDescribables.ofLateToString(base));
    }

    public static NElement safeDescribe(Supplier<NElement> ... descriptions) {
        if (descriptions != null) {
            for (Supplier<NElement> description : descriptions) {
                NElement u;
                if (description == null || (u = description.get()) == null) continue;
                return u;
            }
        }
        return NElementDescribables.ofDesc("invalid").get();
    }

    public static NElement describeResolveOrToString(Object o) {
        return NElementDescribables.describeResolveOr(o, () -> NElement.ofString(o.toString()));
    }

    public static NElement describeResolveOr(Object o, Supplier<NElement> d) {
        NElement e = NElementDescribables.describeResolveOrNull(o);
        if (e != null) {
            return e;
        }
        return d == null ? null : d.get();
    }

    public static NObjectElement describeResolveOrDestructAsObject(Object o) {
        NElement e = NElementDescribables.describeResolveOrDestruct(o);
        if (e instanceof NObjectElement) {
            return (NObjectElement)e;
        }
        return NElement.ofObjectBuilder().set("value", e).build();
    }

    public static NElement describeResolveOrDestruct(Object o) {
        if (o == null) {
            return NElement.ofNull();
        }
        NElement e = NElementDescribables.describeResolveOrNull(o);
        if (e != null) {
            return e;
        }
        return NElements.of().toElement(o);
    }

    public static boolean isSupported(Object o) {
        if (o == null) {
            return true;
        }
        return o instanceof NElementDescribable;
    }

    public static NElement describeResolveOrNull(Object o) {
        if (o == null) {
            return NElement.ofNull();
        }
        if (o instanceof NElement) {
            return (NElement)o;
        }
        if (o instanceof NElementDescribable) {
            return ((NElementDescribable)o).describe();
        }
        if (o instanceof Collection) {
            return NElement.ofArray((NElement[])((Collection)o).stream().map(x -> NElementDescribables.describeResolveOrNull(x)).toArray(NElement[]::new));
        }
        if (o instanceof String) {
            return NElement.ofString((String)o);
        }
        if (o instanceof Number) {
            return NElement.ofNumber((Number)o);
        }
        if (o instanceof Boolean) {
            return NElement.ofBoolean((Boolean)o);
        }
        if (o instanceof LocalTime) {
            return NElement.ofLocalTime((LocalTime)o);
        }
        if (o instanceof LocalDate) {
            return NElement.ofLocalDate((LocalDate)o);
        }
        if (o instanceof LocalDateTime) {
            return NElement.ofLocalDateTime((LocalDateTime)o);
        }
        if (o instanceof Instant) {
            return NElement.ofInstant((Instant)o);
        }
        if (o instanceof NEnum) {
            return NElement.ofName(((NEnum)o).id());
        }
        if (o instanceof Enum) {
            return NElement.ofName(((Enum)o).name());
        }
        if (o instanceof Throwable) {
            return NElement.ofString(NExceptions.getErrorMessage((Throwable)o));
        }
        if (o.getClass().isArray()) {
            int length = Array.getLength(o);
            NElement[] result = new NElement[length];
            for (int i = 0; i < length; ++i) {
                result[i] = NElementDescribables.describeResolveOrNull(Array.get(o, i));
            }
            return NElement.ofArray(result);
        }
        if (o instanceof Map) {
            NObjectElementBuilder b = NElement.ofObjectBuilder();
            for (Map.Entry e : ((Map)o).entrySet()) {
                b.add(NElementDescribables.describeResolveOrNull(e.getKey()), NElementDescribables.describeResolveOrNull(e.getValue()));
            }
            return b.build();
        }
        return null;
    }
}

