/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.core;

import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NSpeedQualifier;
import net.thevpc.nuts.core.NStoreStrategy;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.util.NIterator;

public interface NRepositoryModel {
    public static final int MIRRORING = 1;
    public static final int LIB_READ = 2;
    public static final int LIB_WRITE = 4;
    public static final int LIB_OVERRIDE = 8;
    public static final int CACHE_READ = 16;
    public static final int CACHE_WRITE = 32;
    public static final int LIB = 14;
    public static final int CACHE = 48;

    public String getName();

    default public NStoreStrategy getStoreStrategy() {
        return null;
    }

    default public String getUuid() {
        return null;
    }

    default public int getMode() {
        return 63;
    }

    default public NSpeedQualifier getSpeed() {
        return NSpeedQualifier.NORMAL;
    }

    default public String getRepositoryType() {
        return "custom";
    }

    default public NId searchLatestVersion(NId id, NDefinitionFilter filter, NFetchMode fetchMode, NRepository repository) {
        NIterator<NId> allVersions = this.searchVersions(id, filter, fetchMode, repository);
        NId a = null;
        while (allVersions != null && allVersions.hasNext()) {
            NId next = (NId)allVersions.next();
            if (a != null && next.getVersion().compareTo(a.getVersion()) <= 0) continue;
            a = next;
        }
        return a;
    }

    default public NIterator<NId> searchVersions(NId id, NDefinitionFilter idFilter, NFetchMode fetchMode, NRepository repository) {
        return null;
    }

    default public NDescriptor fetchDescriptor(NId id, NFetchMode fetchMode, NRepository repository) {
        return null;
    }

    default public NPath fetchContent(NId id, NDescriptor descriptor, NFetchMode fetchMode, NRepository repository) {
        return null;
    }

    default public NIterator<NId> search(NDefinitionFilter filter, NPath[] basePaths, NFetchMode fetchMode, NRepository repository) {
        return null;
    }

    default public void updateStatistics(NRepository repository) {
    }

    default public boolean isAcceptFetch(NId id, NFetchMode mode, NRepository repository) {
        return true;
    }

    default public boolean isAcceptDeploy(NId id, NFetchMode mode, NRepository repository) {
        return true;
    }

    default public boolean isAcceptFetchMode(NFetchMode mode) {
        return true;
    }

    default public boolean isRemote() {
        return true;
    }
}

