/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.core;

import java.util.Objects;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStringUtils;

public class NLocationKey {
    private String name;
    private NId id;
    private String repoUuid;
    private NStoreType storeType;

    public static NLocationKey of(NStoreType storeType, NId id, String name) {
        return new NLocationKey(storeType, id, null, name);
    }

    public static NLocationKey of(NStoreType storeType, NId id, String repoUuid, String name) {
        return new NLocationKey(storeType, id, repoUuid, name);
    }

    public static NLocationKey ofCache(NId id, String repoUuid, String name) {
        return new NLocationKey(NStoreType.CACHE, id, repoUuid, name);
    }

    public static NLocationKey ofCacheFaced(NId id, String repoUuid, String faceName) {
        return NLocationKey.ofFaced(NStoreType.CACHE, id, repoUuid, faceName);
    }

    public static NLocationKey ofFaced(NStoreType storeType, NId id, String repoUuid, String faceName) {
        return new NLocationKey(storeType, id, repoUuid, NWorkspace.of().getDefaultIdFilename(id.builder().setFace(faceName).build()));
    }

    public static NLocationKey ofConf(NId id, String repoUuid, String name) {
        return new NLocationKey(NStoreType.CONF, id, repoUuid, name);
    }

    public static NLocationKey ofConfFaced(NId id, String repoUuid, String faceName) {
        return NLocationKey.ofFaced(NStoreType.CONF, id, repoUuid, faceName);
    }

    public NLocationKey(NStoreType storeType, NId id, String repoUuid, String name) {
        if (NBlankable.isBlank(name)) {
            this.name = null;
        } else {
            NAssert.requireTrue(name.matches("[a-zA-Z0-9._-]+"), "name matches [a-zA-Z0-9._-]+");
            this.name = name;
        }
        this.id = NAssert.requireNonBlank(id, "id");
        this.storeType = NAssert.requireNonNull(storeType, "storeType");
        this.repoUuid = NStringUtils.trimToNull(repoUuid);
    }

    public String getName() {
        return this.name;
    }

    public NId getId() {
        return this.id;
    }

    public String getRepoUuid() {
        return this.repoUuid;
    }

    public NStoreType getStoreType() {
        return this.storeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NLocationKey that = (NLocationKey)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.id, that.id) && Objects.equals(this.repoUuid, that.repoUuid) && this.storeType == that.storeType;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id, this.repoUuid, this.storeType);
    }

    public String toString() {
        return "NLocationKey{name=" + NStringUtils.formatStringLiteral(this.name) + ", id=" + this.id + ", repoUuid=" + NStringUtils.formatStringLiteral(this.repoUuid) + ", storeType=" + this.storeType + '}';
    }
}

