/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.concurrent;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.util.NCopiable;

public class NWorkBalancerHostLoadMetrics
implements NCopiable,
Cloneable {
    private float hostLoadFactor;
    private float hostCpuLoad = Float.NaN;
    private float hostMemoryLoad = Float.NaN;
    private long hostLatency = -1L;
    private Map<String, NElement> customMetrics;

    public float getHostLoadFactor() {
        return this.hostLoadFactor;
    }

    public NWorkBalancerHostLoadMetrics setHostLoadFactor(float hostLoadFactor) {
        this.hostLoadFactor = hostLoadFactor;
        return this;
    }

    public float getHostCpuLoad() {
        return this.hostCpuLoad;
    }

    public NWorkBalancerHostLoadMetrics setHostCpuLoad(float hostCpuLoad) {
        this.hostCpuLoad = hostCpuLoad;
        return this;
    }

    public float getHostMemoryLoad() {
        return this.hostMemoryLoad;
    }

    public NWorkBalancerHostLoadMetrics setHostMemoryLoad(float hostMemoryLoad) {
        this.hostMemoryLoad = hostMemoryLoad;
        return this;
    }

    public long getHostLatency() {
        return this.hostLatency;
    }

    public NWorkBalancerHostLoadMetrics setHostLatency(long hostLatency) {
        this.hostLatency = hostLatency;
        return this;
    }

    public Map<String, NElement> getCustomMetrics() {
        return this.customMetrics;
    }

    public NWorkBalancerHostLoadMetrics setCustomMetrics(Map<String, NElement> customMetrics) {
        this.customMetrics = customMetrics;
        return this;
    }

    @Override
    public NWorkBalancerHostLoadMetrics copy() {
        return this.clone();
    }

    protected NWorkBalancerHostLoadMetrics clone() {
        try {
            NWorkBalancerHostLoadMetrics copy = (NWorkBalancerHostLoadMetrics)super.clone();
            copy.customMetrics = this.customMetrics == null ? null : new HashMap<String, NElement>(this.customMetrics);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NWorkBalancerHostLoadMetrics that = (NWorkBalancerHostLoadMetrics)o;
        return Float.compare(this.hostLoadFactor, that.hostLoadFactor) == 0 && Float.compare(this.hostCpuLoad, that.hostCpuLoad) == 0 && Float.compare(this.hostMemoryLoad, that.hostMemoryLoad) == 0 && this.hostLatency == that.hostLatency && Objects.equals(this.customMetrics, that.customMetrics);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.hostLoadFactor), Float.valueOf(this.hostCpuLoad), Float.valueOf(this.hostMemoryLoad), this.hostLatency, this.customMetrics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("hostLoadFactor:").append(this.hostLoadFactor);
        if (!Float.isNaN(this.hostCpuLoad)) {
            sb.append(",hostCpuLoad:").append(this.hostCpuLoad);
        }
        if (!Float.isNaN(this.hostMemoryLoad)) {
            sb.append(",hostMemoryLoad:").append(this.hostMemoryLoad);
        }
        if (this.hostLatency >= 0L) {
            sb.append(",hostLatency:").append(this.hostLatency);
        }
        if (this.customMetrics != null && !this.customMetrics.isEmpty()) {
            sb.append(",customMetrics:{");
            boolean first = true;
            for (Map.Entry<String, NElement> e : this.customMetrics.entrySet()) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(e.getKey()).append(":").append(e.getValue());
                first = false;
            }
            sb.append("}");
        }
        sb.append("}");
        return sb.toString();
    }
}

