/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.concurrent;

import net.thevpc.nuts.util.NExceptions;

public class NTaskResult<T> {
    private final String taskId;
    private final T result;
    private final Throwable exception;

    private NTaskResult(String taskId, T result, Throwable exception) {
        this.taskId = taskId;
        this.result = result;
        this.exception = exception;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public static <T> NTaskResult<T> ofSuccess(String taskId, T result) {
        return new NTaskResult<T>(taskId, result, null);
    }

    public static <T> NTaskResult<T> ofError(String taskId, Throwable exception) {
        return new NTaskResult<Object>(taskId, null, exception);
    }

    public boolean isSuccess() {
        return this.exception == null;
    }

    public boolean isError() {
        return this.exception != null;
    }

    public T getResult() {
        if (this.isError()) {
            throw NExceptions.ofUncheckedException(this.exception);
        }
        return this.result;
    }

    public Throwable getError() {
        return this.exception;
    }
}

