/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.concurrent;

import java.util.function.Supplier;
import net.thevpc.nuts.concurrent.NCallable;
import net.thevpc.nuts.util.NAssert;

public class NScopedValue<T> {
    private InheritableThreadLocal<T> holder = new InheritableThreadLocal();
    private Supplier<T> defaultSupplier;

    public static <T> NScopedValue<T> ofSupplier(Supplier<T> defaultSupplier) {
        NAssert.requireNonNull(defaultSupplier, "supplier supplier");
        return new NScopedValue<T>(defaultSupplier);
    }

    public static <T> NScopedValue<T> of(T value) {
        return new NScopedValue<Object>(value == null ? null : () -> value);
    }

    public NScopedValue(Supplier<T> defaultSupplier) {
        this.defaultSupplier = defaultSupplier;
    }

    public static <T> NScopedValue<T> of() {
        return new NScopedValue<T>();
    }

    public NScopedValue() {
        this(null);
    }

    public T computeIfAbsent(Supplier<T> supplier) {
        Object h = this.holder.get();
        if (h != null) {
            return h;
        }
        if (this.defaultSupplier != null) {
            h = this.defaultSupplier.get();
        }
        if (h == null) {
            h = supplier.get();
            this.holder.set(h);
        }
        return h;
    }

    public T get() {
        Object h = this.holder.get();
        if (h != null) {
            return h;
        }
        if (this.defaultSupplier != null) {
            h = this.defaultSupplier.get();
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWith(T value, Runnable r) {
        Object old = this.holder.get();
        if (value == old) {
            if (r != null) {
                r.run();
            }
            return;
        }
        this.holder.set(value);
        try {
            if (r != null) {
                r.run();
            }
        }
        finally {
            if (old == null) {
                this.holder.remove();
            } else {
                this.holder.set(old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V callWith(T value, NCallable<V> r) {
        Object old = this.holder.get();
        if (value == old) {
            if (r != null) {
                return r.call();
            }
            return null;
        }
        this.holder.set(value);
        try {
            if (r != null) {
                V v = r.call();
                return v;
            }
        }
        finally {
            if (old == null) {
                this.holder.remove();
            } else {
                this.holder.set(old);
            }
        }
        return null;
    }
}

