/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.concurrent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.concurrent.NCompensationStrategy;
import net.thevpc.nuts.concurrent.NSagaCondition;
import net.thevpc.nuts.concurrent.NSagaNodeStatus;
import net.thevpc.nuts.concurrent.NSagaNodeType;
import net.thevpc.nuts.concurrent.NSagaStep;
import net.thevpc.nuts.util.NCopiable;

public class NSagaNodeModel
implements Serializable,
Cloneable,
NCopiable {
    private String id;
    private String name;
    private NSagaNodeType type;
    private NSagaStep stepCall;
    private NSagaCondition stepCondition;
    private List<NSagaNodeModel> children = new ArrayList<NSagaNodeModel>();
    private List<NSagaNodeModel> elseIfBranches = new ArrayList<NSagaNodeModel>();
    private List<NSagaNodeModel> otherwiseBranch = new ArrayList<NSagaNodeModel>();
    private NSagaNodeStatus status = NSagaNodeStatus.PENDING;
    private NCompensationStrategy compensationStrategy = NCompensationStrategy.ABORT;

    public String getId() {
        return this.id;
    }

    public NSagaNodeModel setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public NSagaNodeModel setName(String name) {
        this.name = name;
        return this;
    }

    public NSagaNodeType getType() {
        return this.type;
    }

    public NSagaNodeModel setType(NSagaNodeType type) {
        this.type = type;
        return this;
    }

    public NSagaStep getStepCall() {
        return this.stepCall;
    }

    public NSagaNodeModel setStepCall(NSagaStep stepCall) {
        this.stepCall = stepCall;
        return this;
    }

    public NSagaCondition getStepCondition() {
        return this.stepCondition;
    }

    public NSagaNodeModel setStepCondition(NSagaCondition stepCondition) {
        this.stepCondition = stepCondition;
        return this;
    }

    public List<NSagaNodeModel> getChildren() {
        return this.children;
    }

    public NSagaNodeModel setChildren(List<NSagaNodeModel> children) {
        this.children = children;
        return this;
    }

    public NSagaNodeModel addChild(NSagaNodeModel child) {
        this.children.add(child);
        return this;
    }

    public List<NSagaNodeModel> getElseIfBranches() {
        return this.elseIfBranches;
    }

    public NSagaNodeModel setElseIfBranches(List<NSagaNodeModel> elseIfBranches) {
        this.elseIfBranches = elseIfBranches;
        return this;
    }

    public List<NSagaNodeModel> getOtherwiseBranch() {
        return this.otherwiseBranch;
    }

    public NSagaNodeModel setOtherwiseBranch(List<NSagaNodeModel> otherwiseBranch) {
        this.otherwiseBranch = otherwiseBranch;
        return this;
    }

    public NSagaNodeStatus getStatus() {
        return this.status;
    }

    public NSagaNodeModel setStatus(NSagaNodeStatus status) {
        this.status = status;
        return this;
    }

    public NCompensationStrategy getCompensationStrategy() {
        return this.compensationStrategy;
    }

    public NSagaNodeModel setCompensationStrategy(NCompensationStrategy compensationStrategy) {
        this.compensationStrategy = compensationStrategy;
        return this;
    }

    @Override
    public NSagaNodeModel copy() {
        return this.clone();
    }

    public NSagaNodeModel clone() {
        NSagaNodeModel copy = new NSagaNodeModel();
        copy.id = this.id;
        copy.name = this.name;
        copy.type = this.type;
        copy.stepCall = this.stepCall;
        copy.stepCondition = this.stepCondition;
        copy.status = this.status;
        copy.compensationStrategy = this.compensationStrategy;
        for (NSagaNodeModel c : this.children) {
            copy.children.add(c.clone());
        }
        for (NSagaNodeModel c : this.elseIfBranches) {
            copy.elseIfBranches.add(c.clone());
        }
        for (NSagaNodeModel c : this.otherwiseBranch) {
            copy.otherwiseBranch.add(c.clone());
        }
        return copy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NSagaNodeModel{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", type=" + this.type + ", status=" + this.status + ", compensationStrategy=" + this.compensationStrategy);
        if (this.stepCall != null) {
            sb.append(", stepCall=" + this.stepCall);
        }
        if (this.stepCondition != null) {
            sb.append(", stepCondition=" + this.stepCondition);
        }
        if (this.children != null && !this.children.isEmpty()) {
            sb.append(", children=" + this.children);
        }
        if (this.elseIfBranches != null && !this.elseIfBranches.isEmpty()) {
            sb.append(", elseIfBranches=" + this.elseIfBranches);
        }
        if (this.otherwiseBranch != null && !this.otherwiseBranch.isEmpty()) {
            sb.append(", otherwiseBranch=" + this.otherwiseBranch);
        }
        sb.append('}');
        return sb.toString();
    }
}

