/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.concurrent;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribable;
import net.thevpc.nuts.elem.NUpletElementBuilder;

public class NRateLimitRuleModel
implements Serializable,
NElementDescribable {
    private String id;
    private String strategy;
    private int capacity;
    private long duration;
    private double available;
    private long lastRefill;
    private byte[] config;

    public NRateLimitRuleModel(String id, String strategy, int capacity, long duration, double available, long lastRefill, byte[] config) {
        this.id = id;
        this.strategy = strategy;
        this.capacity = capacity;
        this.duration = duration;
        this.available = available;
        this.lastRefill = lastRefill;
        this.config = config;
    }

    public byte[] getConfig() {
        return this.config == null ? new byte[]{} : Arrays.copyOf(this.config, this.config.length);
    }

    public String getId() {
        return this.id;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public long getDuration() {
        return this.duration;
    }

    public double getAvailable() {
        return this.available;
    }

    public long getLastRefill() {
        return this.lastRefill;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NRateLimitRuleModel that = (NRateLimitRuleModel)o;
        return this.capacity == that.capacity && this.available == that.available && Objects.equals(this.id, that.id) && Objects.equals(this.duration, that.duration) && Objects.equals(this.strategy, that.strategy) && Objects.equals(this.lastRefill, that.lastRefill);
    }

    public int hashCode() {
        return Objects.hash(this.capacity, this.duration, this.available, this.lastRefill);
    }

    public String toString() {
        return "NRateLimitRuleModel{id=" + this.id + ", capacity=" + this.capacity + ", strategy=" + this.strategy + ", duration=" + this.duration + ", available=" + this.available + ", lastRefill=" + this.lastRefill + '}';
    }

    @Override
    public NElement describe() {
        NUpletElementBuilder b = NElement.ofUpletBuilder("Rule").add("id", this.getId()).add("capacity", this.getCapacity()).add("available", this.getAvailable()).add("duration", this.duration).add("strategy", this.strategy);
        if (this.lastRefill > 0L) {
            b.add("lastRefill", this.lastRefill);
        }
        if (this.config != null && this.config.length > 0) {
            b.add("config", (NElement)NElement.ofByteArray(this.config));
        }
        return b.build();
    }
}

