/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.concurrent.NLockBuilder;
import net.thevpc.nuts.core.NIsolationLevel;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElementDescribable;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;

public interface NLock
extends Lock,
NElementDescribable {
    public static NLock of(Object source) {
        return NLockBuilder.of().setSource(source).build();
    }

    public static NLock ofPath(NPath source) {
        return NLockBuilder.of().setSource(source).build();
    }

    public static NLock ofPathCompanion(NPath source) {
        return NLockBuilder.of().setSource(source).setResource(source.resolveSibling(source.getName() + ".lock")).build();
    }

    public static NLock ofResource(Object resource) {
        return NLockBuilder.of().setResource(resource).build();
    }

    public static NLock ofId(NId id) {
        if (NWorkspace.of().getBootOptions().getIsolationLevel().orNull() == NIsolationLevel.MEMORY) {
            return NLock.of(id.getLongId());
        }
        return NLock.ofIdPath(id);
    }

    public static NLock ofIdPath(NId id) {
        return NLockBuilder.of().setSource(id.getLongId()).setResource(NPath.ofIdStore(id, NStoreType.RUN).resolve("nuts-" + NStringUtils.firstNonBlank(id.getFace(), "content")).toPath().get()).build();
    }

    public static NLock ofIdPath(NId id, String path) {
        return NLockBuilder.of().setSource(id.getLongId()).setResource(NPath.ofIdStore(id, NStoreType.RUN).resolve(path).toPath().get()).build();
    }

    public boolean isLocked();

    public boolean isHeldByCurrentThread();

    public void runWith(Runnable var1);

    public <T> T callWith(Callable<T> var1);

    public boolean runWithImmediately(Runnable var1);

    public boolean runWith(Runnable var1, long var2, TimeUnit var4);

    public <T> NOptional<T> callWithImmediately(Callable<T> var1);

    public <T> NOptional<T> callWith(Callable<T> var1, long var2, TimeUnit var4);
}

