/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.concurrent;

import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementRedescribable;
import net.thevpc.nuts.internal.util.NCallableWithDescription;
import net.thevpc.nuts.util.NExceptions;

public interface NCallable<T>
extends NElementRedescribable<NCallable<T>>,
Callable<T> {
    public static <T> NCallable<T> of(Callable<T> other) {
        if (other instanceof NCallable) {
            return (NCallable)other;
        }
        return () -> {
            try {
                if (other != null) {
                    return other.call();
                }
                return null;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw NExceptions.ofUncheckedException(e);
            }
        };
    }

    @Override
    public T call();

    @Override
    default public NCallable<T> redescribe(Supplier<NElement> description) {
        if (description == null) {
            return this;
        }
        return new NCallableWithDescription(this, description);
    }
}

