/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.concurrent;

import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribable;

public class NBulkheadMetrics
implements NElementDescribable {
    private final String bulkheadId;
    private final int maxConcurrent;
    private final int activeCalls;
    private final int availableSlots;
    private final long totalAcquired;
    private final long totalReleased;
    private final long totalRejected;
    private final long maxWaitTimeMillis;
    private final long maxHoldTimeMillis;

    public NBulkheadMetrics(String bulkheadId, int maxConcurrent, int activeCalls, int availableSlots, long totalAcquired, long totalReleased, long totalRejected, long maxWaitTimeMillis, long maxHoldTimeMillis) {
        this.bulkheadId = bulkheadId;
        this.maxConcurrent = maxConcurrent;
        this.activeCalls = activeCalls;
        this.availableSlots = availableSlots;
        this.totalAcquired = totalAcquired;
        this.totalReleased = totalReleased;
        this.totalRejected = totalRejected;
        this.maxWaitTimeMillis = maxWaitTimeMillis;
        this.maxHoldTimeMillis = maxHoldTimeMillis;
    }

    public String getBulkheadId() {
        return this.bulkheadId;
    }

    public int getMaxConcurrent() {
        return this.maxConcurrent;
    }

    public int getActiveCalls() {
        return this.activeCalls;
    }

    public int getAvailableSlots() {
        return this.availableSlots;
    }

    public long getTotalAcquired() {
        return this.totalAcquired;
    }

    public long getTotalReleased() {
        return this.totalReleased;
    }

    public long getTotalRejected() {
        return this.totalRejected;
    }

    public long getMaxWaitTimeMillis() {
        return this.maxWaitTimeMillis;
    }

    public long getMaxHoldTimeMillis() {
        return this.maxHoldTimeMillis;
    }

    public double getRejectionRate() {
        long total = this.totalAcquired + this.totalRejected;
        return total == 0L ? 0.0 : (double)this.totalRejected / (double)total;
    }

    public boolean isFull() {
        return this.availableSlots == 0;
    }

    @Override
    public NElement describe() {
        return NElement.ofObjectBuilder().set("bulkheadId", this.bulkheadId).set("maxConcurrent", this.maxConcurrent).set("activeCalls", this.activeCalls).set("availableSlots", this.availableSlots).set("totalAcquired", (double)this.totalAcquired).set("totalReleased", (double)this.totalReleased).set("totalRejected", (double)this.totalRejected).set("rejectionRate", this.getRejectionRate()).set("maxWaitTimeMillis", (double)this.maxWaitTimeMillis).set("maxHoldTimeMillis", (double)this.maxHoldTimeMillis).build();
    }
}

