/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.concurrent;

import java.util.function.Supplier;
import net.thevpc.nuts.concurrent.NScoredCallable;
import net.thevpc.nuts.internal.NApiUtilsRPI;
import net.thevpc.nuts.text.NI18n;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NExceptions;
import net.thevpc.nuts.util.NScorableContext;

public class DefaultNScoredCallable<T>
implements NScoredCallable<T> {
    private final Supplier<T> value;
    private final int score;
    private final Supplier<NMsg> emptyMessage;

    public DefaultNScoredCallable(Supplier<T> value, int score, Supplier<NMsg> emptyMessage) {
        this.value = value;
        if (this.value == null && score > 0) {
            throw new IllegalArgumentException(NI18n.of("null callable requires invalid support"));
        }
        if (this.value != null && score <= 0) {
            throw new IllegalArgumentException(NI18n.of("non null callable requires valid support"));
        }
        this.score = score;
        this.emptyMessage = emptyMessage == null ? () -> NMsg.ofInvalidValue() : emptyMessage;
    }

    @Override
    public T call() {
        if (this.score > 0) {
            return this.value.get();
        }
        NMsg nMsg = NApiUtilsRPI.resolveValidErrorMessage(() -> this.emptyMessage.get());
        throw NExceptions.ofSafeNoSuchElementException(nMsg);
    }

    @Override
    public int getScore(NScorableContext scorableContext) {
        return this.score;
    }
}

