/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.command;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NEnumUtils;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NOptional;

public enum NFetchStrategy implements Iterable<NFetchMode>,
NEnum
{
    OFFLINE(true, NFetchMode.LOCAL),
    ONLINE(true, NFetchMode.LOCAL, NFetchMode.REMOTE),
    ANYWHERE(false, NFetchMode.LOCAL, NFetchMode.REMOTE),
    REMOTE(true, NFetchMode.REMOTE);

    private final boolean stopFast;
    private final String id = NNameFormat.ID_NAME.format(this.name());
    private final NFetchMode[] all;

    private NFetchStrategy(boolean stopFast, NFetchMode ... all) {
        this.stopFast = stopFast;
        this.all = Arrays.copyOf(all, all.length);
    }

    public static NOptional<NFetchStrategy> parse(String value) {
        return NEnumUtils.parseEnum(value, NFetchStrategy.class);
    }

    @Override
    public String id() {
        return this.id;
    }

    public boolean isStopFast() {
        return this.stopFast;
    }

    public Set<NFetchMode> modes() {
        return new HashSet<NFetchMode>(Arrays.asList(this.all));
    }

    @Override
    public Iterator<NFetchMode> iterator() {
        return Arrays.asList(this.all).iterator();
    }
}

