/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.cmdline;

import java.util.Arrays;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NExceptions;

public interface NCmdLineConfigurable {
    default public Object configure(boolean skipUnsupported, String ... args) {
        this.configure(skipUnsupported, NCmdLine.of(args));
        return this;
    }

    default public boolean configure(boolean skipUnsupported, NCmdLine cmdLine) {
        boolean conf = false;
        int maxLoops = 1000;
        boolean robustMode = false;
        while (cmdLine.hasNext()) {
            if (robustMode) {
                Object[] before = cmdLine.toStringArray();
                if (!this.configureFirst(cmdLine)) {
                    if (skipUnsupported) {
                        cmdLine.skip();
                    } else {
                        cmdLine.throwUnexpectedArgument();
                    }
                } else {
                    conf = true;
                }
                Object[] after = cmdLine.toStringArray();
                if (Arrays.equals(before, after)) {
                    throw NExceptions.ofSafeIllegalArgumentException(NMsg.ofC("bad implementation of configureFirst in class %s. cmdLine is not consumed; perhaps missing skip() class. args = %s", this.getClass().getName(), Arrays.toString(after)));
                }
            } else if (!this.configureFirst(cmdLine)) {
                if (skipUnsupported) {
                    cmdLine.skip();
                } else {
                    cmdLine.throwUnexpectedArgument();
                }
            } else {
                conf = true;
            }
            if (--maxLoops >= 0) continue;
            robustMode = true;
        }
        return conf;
    }

    public boolean configureFirst(NCmdLine var1);

    default public void configureLast(NCmdLine cmdLine) {
        if (!this.configureFirst(cmdLine)) {
            cmdLine.throwUnexpectedArgument();
        }
    }

    public static <T> T configure(NCmdLineConfigurable c, boolean skipUnsupported, String[] args, String commandName) {
        c.configure(skipUnsupported, NCmdLine.of(args).setCommandName(commandName));
        return (T)c;
    }
}

