/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.cmdline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.thevpc.nuts.cmdline.DefaultNArg;
import net.thevpc.nuts.cmdline.DefaultNArgCandidate;
import net.thevpc.nuts.cmdline.DefaultNArgName;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NArgCandidate;
import net.thevpc.nuts.cmdline.NArgName;
import net.thevpc.nuts.cmdline.NArgType;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.cmdline.NCmdLineArgProcessor;
import net.thevpc.nuts.cmdline.NCmdLineAutoComplete;
import net.thevpc.nuts.cmdline.NCmdLineConfigurable;
import net.thevpc.nuts.cmdline.NCmdLineProcessor;
import net.thevpc.nuts.cmdline.NCmdLineRunner;
import net.thevpc.nuts.cmdline.NCmdLines;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.internal.util.NReservedSimpleCharQueue;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NExceptions;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringBuilder;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NSupportMode;

public class DefaultNCmdLine
implements NCmdLine {
    protected LinkedList<String> args = new LinkedList();
    protected List<NArg> lookahead = new ArrayList<NArg>();
    protected boolean expandSimpleOptions = true;
    protected boolean expandArgumentsFile = true;
    protected Set<String> specialSimpleOptions = new HashSet<String>();
    protected String commandName;
    private int wordIndex = 0;
    private NCmdLineAutoComplete autoComplete;
    private char eq = (char)61;
    private NShellFamily shellFamily = NShellFamily.BASH;
    private Object source;
    private boolean unsafe;
    private NCmdLineConfigurable configurable;

    public DefaultNCmdLine() {
    }

    public DefaultNCmdLine(String[] args, NShellFamily shellFamily) {
        this.shellFamily = shellFamily == null ? NShellFamily.getCurrent() : NShellFamily.BASH;
        this.setArguments(args);
    }

    public DefaultNCmdLine(List<String> args) {
        this.setArguments(args);
    }

    @Override
    public NShellFamily getShellFamily() {
        return this.shellFamily;
    }

    @Override
    public NCmdLine setShellFamily(NShellFamily shellFamily) {
        this.shellFamily = shellFamily;
        return this;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public NCmdLine setSource(Object source) {
        this.source = source;
        return this;
    }

    @Override
    public boolean isUnsafe() {
        return this.unsafe;
    }

    @Override
    public NCmdLine setUnsafe(boolean safe) {
        this.unsafe = safe;
        return this;
    }

    @Override
    public NCmdLineConfigurable getConfigurable() {
        return this.configurable;
    }

    @Override
    public NCmdLine setConfigurable(NCmdLineConfigurable configurable) {
        this.configurable = configurable;
        return this;
    }

    @Override
    public boolean isExpandArgumentsFile() {
        return this.expandArgumentsFile;
    }

    @Override
    public NCmdLine setExpandArgumentsFile(boolean expandArgumentsFile) {
        this.expandArgumentsFile = expandArgumentsFile;
        return this;
    }

    @Override
    public NCmdLineAutoComplete getAutoComplete() {
        return this.autoComplete;
    }

    @Override
    public NCmdLine setAutoComplete(NCmdLineAutoComplete autoComplete) {
        this.autoComplete = autoComplete;
        return this;
    }

    @Override
    public NCmdLine unregisterSpecialSimpleOption(String option) {
        this.specialSimpleOptions.remove(option);
        return this;
    }

    @Override
    public String[] getSpecialSimpleOptions() {
        return this.specialSimpleOptions.toArray(new String[0]);
    }

    @Override
    public NCmdLine registerSpecialSimpleOption(String option) {
        if (option.length() > 2) {
            char c0 = option.charAt(0);
            char c1 = option.charAt(1);
            char c2 = option.charAt(2);
            if ((c0 == '-' || c0 == '+') && DefaultNArg.isSimpleKey(c1) && DefaultNArg.isSimpleKey(c2)) {
                this.specialSimpleOptions.add(option);
                return this;
            }
        }
        this.throwError(NMsg.ofC("invalid special option %s", option));
        return this;
    }

    @Override
    public boolean isSpecialSimpleOption(String option) {
        if (option == null) {
            return false;
        }
        DefaultNArg a = new DefaultNArg(option, this);
        String p = a.getOptionPrefix().asString().orNull();
        if (p == null || p.length() != 1) {
            return false;
        }
        String o = a.getKey().asString().orNull();
        if (o == null) {
            return false;
        }
        for (String registered : this.specialSimpleOptions) {
            if (!registered.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getWordIndex() {
        return this.wordIndex;
    }

    @Override
    public boolean isExecMode() {
        return this.autoComplete == null;
    }

    @Override
    public boolean isAutoCompleteMode() {
        return this.autoComplete != null;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public NCmdLine setCommandName(String commandName) {
        this.commandName = commandName;
        return this;
    }

    @Override
    public boolean isExpandSimpleOptions() {
        return this.expandSimpleOptions;
    }

    @Override
    public NCmdLine setExpandSimpleOptions(boolean expand) {
        this.expandSimpleOptions = expand;
        return this;
    }

    @Override
    public NCmdLine throwUnexpectedArgument(NText errorMessage) {
        return this.throwUnexpectedArgument(NMsg.ofC("%s", errorMessage));
    }

    @Override
    public NCmdLine throwUnexpectedArgument(NMsg errorMessage) {
        if (!this.isEmpty()) {
            if (this.autoComplete != null) {
                this.skipAll();
                return this;
            }
            StringBuilder sb = new StringBuilder();
            ArrayList<NMsg> ep = new ArrayList<NMsg>();
            sb.append("unexpected argument %s");
            ep.add(this.highlightText(String.valueOf(this.peek().orNull())));
            if (errorMessage != null) {
                sb.append(", %s");
                ep.add(errorMessage);
            }
            this.throwError(NMsg.ofC(sb.toString(), ep.toArray()));
        }
        return this;
    }

    @Override
    public NCmdLine throwMissingArgument() {
        if (this.isEmpty()) {
            if (this.autoComplete != null) {
                this.skipAll();
                return this;
            }
            this.throwError(NMsg.ofPlain("missing argument"));
        }
        return this;
    }

    @Override
    public NCmdLine throwMissingArgument(String argumentName) {
        if (!NBlankable.isBlank(argumentName)) {
            if (this.isEmpty()) {
                if (this.autoComplete != null) {
                    this.skipAll();
                    return this;
                }
                this.throwError(NMsg.ofC("missing argument %s", NMsg.ofStyledKeyword(argumentName)));
            }
            return this;
        }
        this.throwMissingArgument();
        return this;
    }

    @Override
    public NCmdLine throwMissingArgument(NMsg errorMessage) {
        if (this.isEmpty()) {
            if (this.autoComplete != null) {
                this.skipAll();
                return this;
            }
            StringBuilder sb = new StringBuilder();
            ArrayList<NMsg> ep = new ArrayList<NMsg>();
            sb.append("missing argument");
            if (errorMessage != null) {
                sb.append(", %s");
                ep.add(errorMessage);
            }
            this.throwError(NMsg.ofC(sb.toString(), ep.toArray()));
        }
        return this;
    }

    @Override
    public NCmdLine throwUnexpectedArgument() {
        return this.throwUnexpectedArgument((NMsg)null);
    }

    @Override
    public NCmdLine pushBack(NArg arg) {
        NAssert.requireNonNull(arg, "argument");
        this.lookahead.add(0, arg);
        return this;
    }

    @Override
    public NOptional<NArg> next() {
        return this.next(this.expandSimpleOptions, this.expandArgumentsFile);
    }

    @Override
    public NOptional<String> nextString() {
        return this.next().map(Object::toString);
    }

    @Override
    public NOptional<NArg> next(NArgName name) {
        return this.next(name, false);
    }

    @Override
    public NOptional<NArg> nextOption(String option) {
        if (!new DefaultNArg(option, this).isOption()) {
            return this.errorOptionalCformat("%s is not an option", option);
        }
        return this.next(new DefaultNArgName(option), true);
    }

    @Override
    public boolean isNextOption() {
        return this.peek().map(NArg::isOption).orElse(false);
    }

    @Override
    public boolean isNextNonOption() {
        return this.peek().map(NArg::isNonOption).orElse(false);
    }

    @Override
    public NOptional<NArg> peek() {
        return this.get(0);
    }

    @Override
    public NOptional<NArg> peekNonOption() {
        return this.get(0).filter(x -> x.isNonOption());
    }

    @Override
    public NOptional<NArg> peekOption() {
        return this.get(0).filter(x -> x.isOption());
    }

    @Override
    public boolean hasNext() {
        return !this.lookahead.isEmpty() || !this.args.isEmpty();
    }

    @Override
    public boolean hasNextOption() {
        return this.hasNext() && this.peek().get().isOption();
    }

    @Override
    public boolean hasNextNonOption() {
        return this.hasNext() && this.peek().get().isNonOption();
    }

    @Override
    public NOptional<NArg> nextFlag(String ... names) {
        return this.next(NArgType.FLAG, names);
    }

    @Override
    public NOptional<NArg> nextEntry(String ... names) {
        return this.next(NArgType.ENTRY, names);
    }

    @Override
    public NOptional<NArg> nextEntry() {
        return this.nextEntry(new String[0]);
    }

    @Override
    public NOptional<NArg> nextFlag() {
        return this.nextFlag(new String[0]);
    }

    @Override
    public NCmdLine.Matcher matcher() {
        return new MatcherImpl(this);
    }

    @Override
    public NOptional<NArg> next(String ... names) {
        return this.next(NArgType.DEFAULT, names);
    }

    @Override
    public NOptional<NArg> next(NArgType expectedValue, String ... names) {
        if (expectedValue == null) {
            expectedValue = NArgType.DEFAULT;
        }
        if (names.length == 0) {
            if (this.hasNext()) {
                NArg peeked = this.peek().orNull();
                NOptional<String> string = peeked.getKey().asString();
                if (string.isError()) {
                    return NOptional.ofError(string.getMessage());
                }
                names = string.isPresent() ? new String[]{string.get()} : new String[]{};
            }
        } else if (this.isAutoCompleteMode()) {
            NArgCandidate[] candidates;
            NArgCandidate[] nArgCandidateArray = candidates = this.resolveRecommendations(expectedValue, names, this.autoComplete.getCurrentWordIndex());
            int n = nArgCandidateArray.length;
            for (int i = 0; i < n; ++i) {
                NArgCandidate c = nArgCandidateArray[i];
                this.autoComplete.addCandidate(c);
            }
        }
        block6: for (String nameSeq : names) {
            NOptional<String> pks;
            String[] nameSeqArray = NStringUtils.split(nameSeq, " ").toArray(new String[0]);
            if (nameSeqArray.length == 0 || !this.isPrefixed(nameSeqArray)) continue;
            String name = nameSeqArray[nameSeqArray.length - 1];
            NArg p = this.get(nameSeqArray.length - 1).orNull();
            if (p == null || !(pks = p.getKey().asString()).isPresent() || !pks.get().equals(name)) continue;
            switch (expectedValue) {
                case DEFAULT: {
                    this.skip(nameSeqArray.length);
                    return NOptional.of(p);
                }
                case ENTRY: {
                    this.skip(nameSeqArray.length);
                    if (p.isKeyValue()) {
                        return NOptional.of(p);
                    }
                    NArg r2 = this.peek().orNull();
                    if (r2 != null && !r2.isOption()) {
                        this.skip();
                        return NOptional.of(this.createArgument(p.asString().orElse("") + this.eq + r2.asString().orElse("")));
                    }
                    return NOptional.of(p);
                }
                case FLAG: {
                    this.skip(nameSeqArray.length);
                    if (p.isNegated()) {
                        if (p.isKeyValue()) {
                            boolean x = p.getBooleanValue().orElse(false);
                            if (!pks.isPresent()) continue block6;
                            return NOptional.of(this.createArgument(pks.get() + this.eq + !x));
                        }
                        if (!pks.isPresent()) continue block6;
                        return NOptional.of(this.createArgument(pks.get() + this.eq + false));
                    }
                    if (p.isKeyValue()) {
                        return NOptional.of(p);
                    }
                    if (!pks.isPresent()) continue block6;
                    return NOptional.of(this.createArgument(pks.get() + this.eq + true));
                }
                default: {
                    return this.errorOptionalCformat("unsupported %s", this.highlightText(String.valueOf(expectedValue)));
                }
            }
        }
        return this.emptyOptionalCformat("missing argument", new Object[0]);
    }

    private <T> NOptional<T> emptyOptionalCformat(String str, Object ... args) {
        ArrayList<Object> a = new ArrayList<Object>();
        if (!NBlankable.isBlank(this.getCommandName())) {
            a.add(this.getCommandName());
            a.addAll(Arrays.asList(args));
            return NOptional.ofEmpty(() -> NMsg.ofC("%s : " + str, a.toArray()));
        }
        a.addAll(Arrays.asList(args));
        return NOptional.ofEmpty(() -> NMsg.ofC(str, a.toArray()));
    }

    private <T> NOptional<T> errorOptionalCformat(String str, Object ... args) {
        return NOptional.ofError(() -> {
            if (!NBlankable.isBlank(this.getCommandName())) {
                return NMsg.ofC("%s : %s ", this.getCommandName(), NMsg.ofC(str, args));
            }
            return NMsg.ofC(str, args);
        });
    }

    @Override
    public NOptional<NArg> nextNonOption(NArgName name) {
        return this.next(name, true);
    }

    @Override
    public NOptional<NArg> nextNonOption(String name) {
        return this.nextNonOption(new DefaultNArgName(name));
    }

    @Override
    public NOptional<NArg> nextNonOption() {
        if (this.hasNext() && !this.isNextOption()) {
            return this.next();
        }
        return this.emptyOptionalCformat("missing non-option", new Object[0]);
    }

    @Override
    public int skipAll() {
        int count = 0;
        while (this.hasNext()) {
            count += this.skip(1);
        }
        return count;
    }

    @Override
    public int skip() {
        return this.skip(1);
    }

    @Override
    public int skip(int count) {
        if (count < 0) {
            count = 0;
        }
        for (int initialCount = count; initialCount > 0 && this.hasNext() && this.next() != null; --initialCount) {
            ++this.wordIndex;
        }
        return count;
    }

    @Override
    public boolean accept(String ... values) {
        return this.accept(0, values);
    }

    @Override
    public boolean accept(int index, String ... values) {
        for (int i = 0; i < values.length; ++i) {
            NArg argument = this.get(index + i).orNull();
            if (argument == null) {
                return false;
            }
            if (argument.getKey().asString().orElse("").equals(values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public NOptional<NArg> find(String name) {
        int index = this.indexOf(name);
        if (index >= 0) {
            return this.get(index);
        }
        return this.emptyOptionalCformat("missing argument", new Object[0]);
    }

    @Override
    public NOptional<NArg> get(int index) {
        if (index < 0) {
            return this.emptyOptionalCformat("missing argument", new Object[0]);
        }
        if (index < this.lookahead.size()) {
            return NOptional.of(this.lookahead.get(index));
        }
        while (!this.args.isEmpty() && index >= this.lookahead.size() && this.ensureNext(this.isExpandSimpleOptions(), true, this.expandArgumentsFile)) {
        }
        if (index < this.lookahead.size()) {
            return NOptional.of(this.lookahead.get(index));
        }
        return this.emptyOptionalCformat("missing argument", new Object[0]);
    }

    @Override
    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    @Override
    public int indexOf(String name) {
        for (int i = 0; i < this.length(); ++i) {
            NOptional<NArg> g = this.get(i);
            if (!g.isPresent() || !g.get().getKey().asString().orElse("").equals(name)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int length() {
        return this.lookahead.size() + this.args.size();
    }

    @Override
    public boolean isEmpty() {
        return !this.hasNext();
    }

    @Override
    public String[] toStringArray() {
        return this.toStringList().toArray(new String[0]);
    }

    @Override
    public String[] nextAllAsStringArray() {
        String[] a = this.toStringArray();
        this.skipAll();
        return a;
    }

    @Override
    public List<String> nextAllAsStringList() {
        List<String> a = this.toStringList();
        this.skipAll();
        return a;
    }

    @Override
    public NArg[] nextAllAsArgumentArray() {
        NArg[] a = this.toArgumentArray();
        this.skipAll();
        return a;
    }

    @Override
    public List<String> toStringList() {
        ArrayList<String> all = new ArrayList<String>(this.length());
        for (NArg nutsArgument : this.lookahead) {
            all.add(nutsArgument.asString().orElse(""));
        }
        all.addAll(this.args);
        return all;
    }

    @Override
    public NArg[] toArgumentArray() {
        ArrayList<NArg> aa = new ArrayList<NArg>();
        while (this.hasNext()) {
            aa.add(this.next().get());
        }
        this.lookahead.addAll(aa);
        return aa.toArray(new NArg[0]);
    }

    @Override
    public boolean isOption(int index) {
        return this.get(index).map(NArg::isOption).orElse(false);
    }

    @Override
    public boolean isNonOption(int index) {
        return this.get(index).map(NArg::isNonOption).orElse(false);
    }

    @Override
    public NCmdLine setArguments(List<String> arguments) {
        if (arguments == null) {
            return this.setArguments(new String[0]);
        }
        return this.setArguments(arguments.toArray(new String[0]));
    }

    @Override
    public NCmdLine setArguments(String[] arguments) {
        this.lookahead.clear();
        this.args.clear();
        if (arguments != null) {
            for (String a : arguments) {
                if (a == null) continue;
                this.args.add(a);
            }
        }
        return this;
    }

    @Override
    public void throwError(NMsg message) {
        throw NExceptions.ofSafeCmdLineException(NMsg.ofC("%s : %s", NStringUtils.firstNonBlank(this.commandName, "command"), message));
    }

    @Override
    public void throwError(NText message) {
        NTextBuilder m = NTextBuilder.of();
        if (!NBlankable.isBlank(this.commandName)) {
            m.append(this.commandName).append(" : ");
        }
        m.append(message);
        throw NExceptions.ofSafeCmdLineException(NMsg.ofNtf(m.build().toString()));
    }

    private NArgCandidate[] resolveRecommendations(NArgType expectValue, String[] names, int autoCompleteCurrentWordIndex) {
        ArrayList<DefaultNArgCandidate> candidates = new ArrayList<DefaultNArgCandidate>();
        for (String nameSeq : names) {
            String[] nameSeqArray = NStringUtils.split(nameSeq, " ").toArray(new String[0]);
            if (nameSeqArray.length <= 0) continue;
            int i = autoCompleteCurrentWordIndex < nameSeqArray.length ? autoCompleteCurrentWordIndex : nameSeqArray.length - 1;
            boolean skipToNext = false;
            for (int j = 0; j < i; ++j) {
                String xs;
                String a = nameSeqArray[j];
                NArg x = this.get(j).orNull();
                if (x == null || (xs = x.asString().orElse("")).length() <= 0 || xs.equals(a)) continue;
                skipToNext = true;
                break;
            }
            if (skipToNext) continue;
            skipToNext = false;
            if (i < nameSeqArray.length - 1) {
                String a = nameSeqArray[i];
                NArg x = this.get(i).orNull();
                if (x != null) {
                    String xs = x.asString().orElse("");
                    if (xs.length() > 0 && xs.equals(a)) {
                        skipToNext = true;
                    } else if (xs.length() > 0 && a.startsWith(xs) && !xs.equals(a)) {
                        candidates.add(new DefaultNArgCandidate(a));
                        skipToNext = true;
                    } else {
                        skipToNext = true;
                    }
                }
            }
            if (skipToNext || this.getWordIndex() + nameSeqArray.length - 1 != autoCompleteCurrentWordIndex) continue;
            String name = nameSeqArray[nameSeqArray.length - 1];
            NArg p = this.get(nameSeqArray.length - 1).orNull();
            if (p != null) {
                if (!name.startsWith(p.getKey().asString().orElse(""))) continue;
                candidates.add(new DefaultNArgCandidate(name));
                continue;
            }
            candidates.add(new DefaultNArgCandidate(name));
        }
        return candidates.toArray(new NArgCandidate[0]);
    }

    private boolean isPrefixed(String[] nameSeqArray) {
        for (int i = 0; i < nameSeqArray.length - 1; ++i) {
            NArg x = this.get(i).orNull();
            if (x != null && x.asString().orElse("").equals(nameSeqArray[i])) continue;
            return false;
        }
        return true;
    }

    public NOptional<NArg> next(NArgName name, boolean forceNonOption) {
        if (!(!this.hasNext() || forceNonOption && this.isNextOption())) {
            if (this.isAutoComplete()) {
                List<NArgCandidate> values;
                List<NArgCandidate> list = values = name == null ? null : name.getCandidates(this.getAutoComplete());
                if (values == null || values.isEmpty()) {
                    this.autoComplete.addCandidate(new DefaultNArgCandidate(name == null ? "<value>" : name.getName()));
                } else {
                    for (NArgCandidate value : values) {
                        this.autoComplete.addCandidate(value);
                    }
                }
            }
            NArg r = this.peek().orNull();
            this.skip();
            if (r == null) {
                return this.emptyOptionalCformat("expected argument", new Object[0]);
            }
            return NOptional.of(r);
        }
        if (this.autoComplete != null) {
            if (this.isAutoComplete()) {
                List<NArgCandidate> values;
                List<NArgCandidate> list = values = name == null ? null : name.getCandidates(this.getAutoComplete());
                if (values == null || values.isEmpty()) {
                    this.autoComplete.addCandidate(new DefaultNArgCandidate(name == null ? "<value>" : name.getName()));
                } else {
                    for (NArgCandidate value : values) {
                        this.autoComplete.addCandidate(value);
                    }
                }
            }
            return NOptional.of(this.createArgument(""));
        }
        if (!(!this.hasNext() || forceNonOption && this.isNextOption())) {
            return this.emptyOptionalCformat("unexpected option %s", this.highlightText(String.valueOf(this.peek().get().image())));
        }
        return this.emptyOptionalCformat("missing argument %s", this.highlightText(String.valueOf(name == null ? "value" : name.getName())));
    }

    public NOptional<NArg> next(boolean expandSimpleOptions, boolean expandArgumentsFile) {
        if (this.ensureNext(expandSimpleOptions, false, expandArgumentsFile)) {
            if (!this.lookahead.isEmpty()) {
                return NOptional.of(this.lookahead.remove(0));
            }
            String v = this.args.removeFirst();
            return NOptional.of(this.createArgument(v));
        }
        return this.emptyOptionalCformat("missing argument", new Object[0]);
    }

    public String toString() {
        return this.toStringList().stream().map(x -> NStringUtils.formatStringLiteral(x, NElementType.DOUBLE_QUOTED_STRING, NSupportMode.PREFERRED)).collect(Collectors.joining(" "));
    }

    private String createExpandedSimpleOption(char start, boolean negate, char val) {
        char[] cArray;
        if (negate) {
            char[] cArray2 = new char[3];
            cArray2[0] = start;
            cArray2[1] = 33;
            cArray = cArray2;
            cArray2[2] = val;
        } else {
            char[] cArray3 = new char[2];
            cArray3[0] = start;
            cArray = cArray3;
            cArray3[1] = val;
        }
        return new String(cArray);
    }

    private String createExpandedSimpleOption(char start, boolean negate, String val) {
        StringBuilder sb = new StringBuilder();
        sb.append(start);
        if (negate) {
            sb.append('!');
        }
        sb.append(val);
        return sb.toString();
    }

    private List<String> loadArgs(NPath path, NPath currentDir, Set<String> visited) {
        if ((path = path.toAbsolute(currentDir).normalize()).isRegularFile()) {
            if (visited.contains(path.toString())) {
                return Collections.emptyList();
            }
            visited.add(path.toString());
            ArrayList<String> all = new ArrayList<String>();
            NShellFamily s = this.shellFamily;
            if (s == null) {
                s = NShellFamily.getCurrent();
            }
            String fileContent = path.readString();
            ArrayList<String> parsed = new ArrayList<String>();
            for (String line : new NStringBuilder(fileContent).lines().toList()) {
                if (NBlankable.isBlank(line) || line.trim().startsWith("#")) continue;
                NCmdLine subCmd = NCmdLines.of().setShellFamily(s).parseCmdLine(line).get();
                subCmd.setExpandArgumentsFile(false);
                subCmd.setExpandArgumentsFile(false);
                parsed.addAll(subCmd.toStringList());
            }
            for (String arg : parsed) {
                if (arg.length() > 3 && arg.startsWith("--@")) {
                    NPath nPath = NPath.of(arg.substring(3));
                    NPath parent = path.getParent();
                    all.addAll(this.loadArgs(nPath, parent == null ? currentDir : parent, visited));
                    continue;
                }
                all.add(arg);
            }
            return all;
        }
        if (path.exists()) {
            throw new NIllegalArgumentException(NMsg.ofC("argument file does not exist %s", path));
        }
        throw new NIllegalArgumentException(NMsg.ofC("argument file is not a valid regular file %s", path));
    }

    private boolean ensureNext(boolean expandSimpleOptions, boolean ignoreExistingExpanded, boolean expandArgumentsFile) {
        if (!ignoreExistingExpanded && !this.lookahead.isEmpty()) {
            return true;
        }
        if (!this.args.isEmpty()) {
            String arg = this.args.removeFirst();
            if (arg.length() > 3 && expandArgumentsFile && arg.startsWith("--@")) {
                NPath nPath = NPath.of(arg.substring(3));
                this.args.addAll(0, this.loadArgs(nPath, NPath.ofUserDirectory(), new HashSet<String>()));
                if (this.args.isEmpty()) {
                    return false;
                }
                arg = this.args.removeFirst();
            }
            if (expandSimpleOptions && arg.length() > 2 && !this.isSpecialSimpleOption(arg) && (arg.charAt(0) == '-' && arg.charAt(1) != '-' || arg.charAt(0) == '+' && arg.charAt(1) != '+') && (arg.charAt(1) != '/' || arg.charAt(2) == '/')) {
                NReservedSimpleCharQueue vv = new NReservedSimpleCharQueue(arg.toCharArray());
                char start = vv.read();
                char negChar = '\u0000';
                boolean negate = false;
                if (vv.peek() == '!' || vv.peek() == '~') {
                    negChar = vv.read();
                    negate = true;
                }
                while (vv.hasNext()) {
                    char c = vv.read();
                    StringBuilder cc = new StringBuilder();
                    cc.append(start);
                    if (negate) {
                        cc.append(negChar);
                    }
                    cc.append(c);
                    if (DefaultNArg.isSimpleKey(c)) {
                        while (vv.hasNext() && vv.peek() != this.eq && !DefaultNArg.isSimpleKey(vv.peek())) {
                            cc.append(vv.read());
                        }
                        if (vv.hasNext() && vv.peek() == this.eq) {
                            while (vv.hasNext()) {
                                cc.append(vv.read());
                            }
                            this.lookahead.add(this.createArgument(cc.toString()));
                            continue;
                        }
                        this.lookahead.add(this.createArgument(cc.toString()));
                        continue;
                    }
                    while (vv.hasNext()) {
                        cc.append(vv.read());
                    }
                    this.lookahead.add(this.createArgument(cc.toString()));
                }
            } else {
                this.lookahead.add(this.createArgument(arg));
            }
            return true;
        }
        return false;
    }

    private NArg createArgument(String v) {
        return new DefaultNArg(v, this.eq, this);
    }

    private boolean isAutoComplete() {
        return this.autoComplete != null && this.getWordIndex() == this.autoComplete.getCurrentWordIndex();
    }

    @Override
    public NCmdLine copy() {
        DefaultNCmdLine c = new DefaultNCmdLine();
        c.setArguments(this.toStringArray());
        c.autoComplete = this.autoComplete;
        c.setShellFamily(this.shellFamily);
        c.setExpandArgumentsFile(this.expandArgumentsFile);
        c.setExpandSimpleOptions(this.expandSimpleOptions);
        c.eq = this.eq;
        c.specialSimpleOptions = new HashSet<String>(this.specialSimpleOptions);
        c.commandName = this.commandName;
        c.configurable = this.configurable;
        c.source = this.source;
        c.unsafe = this.unsafe;
        return c;
    }

    private NMsg highlightText(String text) {
        return NMsg.ofStyledPrimary3(String.valueOf(text));
    }

    private boolean isPunctuation(char c) {
        switch (Character.getType(c)) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<NArg> iterator() {
        return Arrays.asList(this.toArgumentArray()).iterator();
    }

    public static NOptional<String[]> parseDefaultList(String commandLineString) {
        return DefaultNCmdLine.parseDefaultList(commandLineString, null, new HashSet<String>());
    }

    private static NOptional<String[]> parseDefaultList(String commandLineString, String currentFolder, Set<String> loaded) {
        if (commandLineString == null) {
            return NOptional.of(new String[0]);
        }
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean START = false;
        boolean IN_WORD = true;
        int IN_QUOTED_WORD = 2;
        int IN_DBQUOTED_WORD = 3;
        int status = 0;
        char[] charArray = commandLineString.toCharArray();
        block30: for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            switch (status) {
                case 0: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            continue block30;
                        }
                        case '\n': 
                        case '\r': {
                            continue block30;
                        }
                        case '\'': {
                            status = 2;
                            continue block30;
                        }
                        case '\"': {
                            status = 3;
                            continue block30;
                        }
                        case '\\': {
                            status = 1;
                            sb.append(charArray[++i]);
                            continue block30;
                        }
                    }
                    sb.append(c);
                    status = 1;
                    continue block30;
                }
                case 1: {
                    switch (c) {
                        case ' ': {
                            args.add(sb.toString());
                            sb.delete(0, sb.length());
                            status = 0;
                            continue block30;
                        }
                        case '\"': 
                        case '\'': {
                            return NOptional.ofError(() -> NMsg.ofC("illegal char %s", Character.valueOf(c)));
                        }
                        case '\\': {
                            sb.append(charArray[++i]);
                            continue block30;
                        }
                    }
                    sb.append(c);
                    continue block30;
                }
                case 2: {
                    switch (c) {
                        case '\'': {
                            args.add(sb.toString());
                            sb.delete(0, sb.length());
                            status = 0;
                            continue block30;
                        }
                    }
                    sb.append(c);
                    continue block30;
                }
                case 3: {
                    switch (c) {
                        case '\"': {
                            args.add(sb.toString());
                            sb.delete(0, sb.length());
                            status = 0;
                            continue block30;
                        }
                        case '\\': {
                            i = DefaultNCmdLine.readEscapedArg(charArray, i + 1, sb);
                            continue block30;
                        }
                    }
                    sb.append(c);
                }
            }
        }
        switch (status) {
            case 0: {
                break;
            }
            case 1: {
                args.add(sb.toString());
                sb.delete(0, sb.length());
                break;
            }
            case 2: {
                return NOptional.ofError(() -> NMsg.ofPlain("expected quote"));
            }
        }
        return NOptional.of(args.toArray(new String[0]));
    }

    private static int readEscapedArg(char[] charArray, int i, StringBuilder sb) {
        char c = charArray[i];
        switch (c) {
            case ' ': 
            case '\"': 
            case '$': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case ';': 
            case '<': 
            case '>': 
            case '\\': 
            case '|': 
            case '~': {
                sb.append(c);
                break;
            }
            default: {
                sb.append('\\').append(c);
            }
        }
        return i;
    }

    @Override
    public NCmdLine add(String argument) {
        if (argument != null) {
            this.args.add(argument);
        }
        return this;
    }

    @Override
    public NCmdLine addAll(List<String> arguments) {
        if (arguments != null) {
            for (String argument : arguments) {
                this.add(argument);
            }
        }
        return this;
    }

    @Override
    public boolean isBlank() {
        return this.isEmpty();
    }

    @Override
    public void run(NCmdLineRunner processor) {
        NCmdLineConfigurable configurable = this.getConfigurable();
        DefaultNCmdLine cmd = this;
        processor.init(cmd);
        if (this.isUnsafe()) {
            NArg a;
            while ((a = this.peek().orNull()) != null) {
                if (processor.next(a, cmd) || configurable != null && configurable.configureFirst(this)) continue;
                this.throwUnexpectedArgument();
            }
        } else {
            while (cmd.hasNext()) {
                NArg next;
                NArg a = cmd.peek().get();
                if (processor.next(a, cmd)) {
                    next = cmd.peek().orNull();
                    if (next != a) continue;
                    this.throwError(NMsg.ofC("next must consume the argument: %s", a));
                    continue;
                }
                if (configurable != null && configurable.configureFirst(cmd)) {
                    next = cmd.peek().orNull();
                    if (next != a) continue;
                    this.throwError(NMsg.ofC("%s must consume the option: %s", "configurable.configureFirst(...)", a));
                    continue;
                }
                cmd.throwUnexpectedArgument();
            }
        }
        processor.validate(cmd);
        if (this.isExecMode()) {
            processor.run(cmd);
        } else if (this.getAutoComplete() != null) {
            processor.autoComplete(this);
        }
    }

    @Override
    public NCmdLine pushBack(NArg ... args) {
        if (args != null) {
            this.lookahead.addAll(0, Arrays.stream(args).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return this;
    }

    @Override
    public NCmdLine pushBack(String ... args) {
        if (args != null) {
            this.lookahead.addAll(0, Arrays.stream(args).map(x -> new DefaultNArg(x == null ? "" : x, this)).collect(Collectors.toList()));
        }
        return this;
    }

    @Override
    public NCmdLine append(String ... args) {
        if (args != null) {
            this.args.addAll(Arrays.stream(args).map(x -> x == null ? "" : x).collect(Collectors.toList()));
        }
        return this;
    }

    @Override
    public NCmdLine forEachPeek(NCmdLineProcessor ... actions) {
        NAssert.requireNonNull(actions, () -> NMsg.ofC("missing processors"));
        NAssert.requireTrue(actions.length > 0, () -> NMsg.ofC("missing processors"));
        while (this.hasNext()) {
            NArg b;
            boolean some = false;
            NArg a = this.peek().orNull();
            for (NCmdLineProcessor action : actions) {
                NArg b2;
                if (action == null) continue;
                if (action.process(this)) {
                    some = true;
                    break;
                }
                if (!this.isUnsafe() || (b2 = this.peek().orNull()) == a) continue;
                this.throwError(NMsg.ofC("process(...) must not consume the argument if not relevant"));
            }
            if (!some) {
                if (this.configurable != null && this.configurable.configureFirst(this)) {
                    if (!this.isUnsafe() || (b = this.peek().orNull()) != a) continue;
                    this.throwError(NMsg.ofC("process(...) must consume the argument if relevant"));
                    continue;
                }
                this.throwUnexpectedArgument();
                continue;
            }
            if (!this.isUnsafe() || (b = this.peek().orNull()) != a) continue;
            this.throwError(NMsg.ofC("process(...) must consume the argument if relevant"));
        }
        return this;
    }

    @Override
    public NCmdLine forEachPeek(NCmdLineProcessor processor) {
        NAssert.requireNonNull(processor, () -> NMsg.ofC("processor"));
        return this.forEachPeek(new NCmdLineProcessor[]{processor});
    }

    public static class MatcherImpl
    implements NCmdLine.Matcher {
        private NCmdLine cmdLine;
        List<NCmdLineProcessor> processors = new ArrayList<NCmdLineProcessor>();

        public MatcherImpl(NCmdLine cmdLine) {
            this.cmdLine = cmdLine;
        }

        @Override
        public NCmdLine.Matcher matchAll(NCmdLineProcessor processor) {
            if (processor != null) {
                this.processors.add(processor);
            }
            return this;
        }

        @Override
        public boolean noMatch() {
            return !this.anyMatch();
        }

        @Override
        public boolean anyMatch() {
            NArg a = this.cmdLine.peek().orNull();
            if (a == null) {
                return false;
            }
            for (NCmdLineProcessor consumer : this.processors) {
                if (!consumer.process(this.cmdLine)) continue;
                return true;
            }
            return false;
        }

        @Override
        public NCmdLine.MatcherCondition withAny() {
            return new MyMatcherConditionImpl(this, c -> true, new String[0]);
        }

        @Override
        public NCmdLine.Matcher matchTrueFlag(Consumer<NArg> consumer) {
            return this.withAny().matchTrueFlag(consumer);
        }

        @Override
        public NCmdLine.Matcher matchFlag(Consumer<NArg> consumer) {
            return this.withAny().matchFlag(consumer);
        }

        @Override
        public NCmdLine.Matcher matchEntry(Consumer<NArg> consumer) {
            return this.withAny().matchEntry(consumer);
        }

        @Override
        public NCmdLine.Matcher matchAny(Consumer<NArg> consumer) {
            return this.withAny().matchAny(consumer);
        }

        @Override
        public NCmdLine.MatcherCondition with(String ... names) {
            return new MyMatcherConditionImpl(this, cml -> {
                boolean acceptable0 = false;
                for (String name : names) {
                    String[] nameSeqArray = NStringUtils.split(name, " ").toArray(new String[0]);
                    boolean acceptable = true;
                    for (int i = 0; i < nameSeqArray.length; ++i) {
                        NOptional<NArg> c = cml.get(i);
                        if (c.isPresent() && c.get().key().equals(nameSeqArray[i])) continue;
                        acceptable = false;
                    }
                    if (!acceptable) continue;
                    acceptable0 = true;
                    break;
                }
                return acceptable0;
            }, names);
        }

        @Override
        public NCmdLine.MatcherCondition withCondition(Predicate<NCmdLine> condition) {
            return new MyMatcherConditionImpl(this, condition, new String[0]);
        }

        @Override
        public NCmdLine.MatcherCondition withNonOption() {
            return this.withCondition(c -> c.isNextNonOption());
        }

        @Override
        public NCmdLine.MatcherCondition withOption() {
            return this.withCondition(c -> c.isNextOption());
        }

        @Override
        public NCmdLine.Matcher withDefaults() {
            this.matchAll(new NCmdLineProcessor(){

                @Override
                public boolean process(NCmdLine cmdLine) {
                    NSession.of().configureLast(cmdLine);
                    return true;
                }
            });
            return this;
        }

        @Override
        public NCmdLine.Matcher withDefaultFirst() {
            this.matchAll(new NCmdLineProcessor(){

                @Override
                public boolean process(NCmdLine cmdLine) {
                    return NSession.of().configureFirst(cmdLine);
                }
            });
            return this;
        }

        @Override
        public void requireDefaults() {
            this.withDefaults();
            this.require();
        }

        @Override
        public void require() {
            if (this.noMatch()) {
                if (this.cmdLine.isEmpty()) {
                    this.cmdLine.throwMissingArgument();
                }
                this.cmdLine.throwUnexpectedArgument();
            }
        }
    }

    private static class MyMatcherConditionImpl
    implements NCmdLine.MatcherCondition {
        private final Predicate<NCmdLine> baseCondition;
        private final String[] names;
        private MatcherImpl selector;
        private List<Predicate<NCmdLine>> otherConditions = new ArrayList<Predicate<NCmdLine>>();

        public MyMatcherConditionImpl(MatcherImpl selector, Predicate<NCmdLine> baseCondition, String ... names) {
            this.baseCondition = baseCondition;
            this.names = names;
            this.selector = selector;
        }

        @Override
        public NCmdLine.MatcherCondition and(Predicate<NCmdLine> condition) {
            if (condition != null) {
                this.otherConditions.add(condition);
            }
            return this;
        }

        private boolean checkCondition(NCmdLine cmdLine) {
            if (!this.baseCondition.test(cmdLine)) {
                return false;
            }
            for (Predicate<NCmdLine> otherCondition : this.otherConditions) {
                if (otherCondition.test(cmdLine)) continue;
                return false;
            }
            return true;
        }

        @Override
        public NCmdLine.Matcher matchFlag(final Consumer<NArg> consumer) {
            this.selector.matchAll(new NCmdLineProcessor(){

                @Override
                public boolean process(NCmdLine cmdLine) {
                    if (!this.checkCondition(cmdLine)) {
                        return false;
                    }
                    NOptional<NArg> v = selector.cmdLine.next(NArgType.FLAG, names);
                    if (v.isPresent()) {
                        NArg a = v.get();
                        if (a.isUncommented()) {
                            consumer.accept(a);
                            return true;
                        }
                        return true;
                    }
                    return false;
                }
            });
            return this.selector;
        }

        @Override
        public NCmdLine.Matcher matchEntry(final Consumer<NArg> consumer) {
            this.selector.matchAll(new NCmdLineProcessor(){

                @Override
                public boolean process(NCmdLine cmdLine) {
                    if (!this.checkCondition(cmdLine)) {
                        return false;
                    }
                    NOptional<NArg> v = selector.cmdLine.next(NArgType.ENTRY, names);
                    if (v.isPresent()) {
                        NArg a = v.get();
                        if (a.isUncommented()) {
                            consumer.accept(a);
                            return true;
                        }
                        return true;
                    }
                    return false;
                }
            });
            return this.selector;
        }

        @Override
        public NCmdLine.Matcher matchAnyMultiple(final Consumer<NCmdLine> consumer) {
            this.selector.matchAll(new NCmdLineProcessor(){

                @Override
                public boolean process(NCmdLine cmdLine) {
                    if (!this.checkCondition(cmdLine)) {
                        return false;
                    }
                    NOptional<NArg> v = selector.cmdLine.peek();
                    if (v.isPresent()) {
                        consumer.accept(selector.cmdLine);
                        return true;
                    }
                    return false;
                }
            });
            return this.selector;
        }

        @Override
        public NCmdLine.Matcher matchAny(final Consumer<NArg> consumer) {
            this.selector.matchAll(new NCmdLineProcessor(){

                @Override
                public boolean process(NCmdLine cmdLine) {
                    if (!this.checkCondition(cmdLine)) {
                        return false;
                    }
                    NOptional<NArg> v = selector.cmdLine.next();
                    if (v.isPresent()) {
                        NArg a = v.get();
                        consumer.accept(a);
                        return true;
                    }
                    return false;
                }
            });
            return this.selector;
        }

        @Override
        public NCmdLine.Matcher skip() {
            this.selector.matchAll(new NCmdLineProcessor(){

                @Override
                public boolean process(NCmdLine cmdLine) {
                    if (!this.checkCondition(cmdLine)) {
                        return false;
                    }
                    NOptional<NArg> v = selector.cmdLine.next();
                    return v.isPresent();
                }
            });
            return this.selector;
        }

        @Override
        public NCmdLine.Matcher matchTrueFlag(Consumer<NArg> consumer) {
            return this.matchFlag(value -> {
                if (value.booleanValue()) {
                    consumer.accept((NArg)value);
                }
            });
        }
    }

    private class MyNCmdLineArgProcessor
    implements NCmdLineArgProcessor {
        private final boolean finalAcceptable;
        private final String[] names;

        public MyNCmdLineArgProcessor(boolean finalAcceptable, String ... names) {
            this.finalAcceptable = finalAcceptable;
            this.names = names;
        }

        @Override
        public boolean isAcceptable() {
            return this.finalAcceptable;
        }

        @Override
        public boolean nextFlag(Consumer<NArg> consumer) {
            if (!this.finalAcceptable) {
                return false;
            }
            NOptional<NArg> v = DefaultNCmdLine.this.next(NArgType.FLAG, this.names);
            if (v.isPresent()) {
                NArg a = v.get();
                if (a.isUncommented()) {
                    consumer.accept(a);
                    return true;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean nextEntry(Consumer<NArg> consumer) {
            if (!this.finalAcceptable) {
                return false;
            }
            NOptional<NArg> v = DefaultNCmdLine.this.next(NArgType.ENTRY, this.names);
            if (v.isPresent()) {
                NArg a = v.get();
                if (a.isUncommented()) {
                    consumer.accept(a);
                    return true;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean nextTrueFlag(Consumer<NArg> consumer) {
            if (!this.finalAcceptable) {
                return false;
            }
            return this.nextFlag(value -> {
                if (value.isBoolean() && value.booleanValue()) {
                    consumer.accept((NArg)value);
                }
            });
        }
    }
}

