/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootPath {
    private String path;
    private NRef<Path> file;
    private NRef<URL> url;
    private NRef<Boolean> remote;

    public NBootPath(String path) {
        if (NBootUtils.isBlank(path)) {
            this.path = null;
            this.url = NRef.of(null);
            this.file = NRef.of(null);
        } else {
            this.path = path;
        }
    }

    public NBootPath(URL path) {
        if (path == null) {
            this.path = null;
            this.url = NRef.of(null);
            this.file = NRef.of(null);
        } else {
            this.path = path.toString();
            this.url = NRef.of(path);
            this.file = NRef.of(NBootUtils.toFile(path).toPath());
        }
    }

    public NBootPath(Path path) {
        if (path == null) {
            this.path = null;
            this.url = NRef.of(null);
            this.file = NRef.of(null);
        } else {
            this.path = path.toString();
            this.file = NRef.of(path);
            try {
                this.url = NRef.of(path.toUri().toURL());
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public byte[] readAllBytes() {
        if (this.path == null) {
            return null;
        }
        Path f = this.getFile();
        try {
            if (f != null) {
                if (Files.isRegularFile(f, new LinkOption[0])) {
                    return Files.readAllBytes(f);
                }
                return null;
            }
            return NBootUtils.loadStream(this.getInputSteam());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public InputStream getInputSteam() {
        if (this.path == null) {
            return null;
        }
        return NBootUtils.openStream(this.getUrl());
    }

    public Path getFile() {
        if (this.file == null) {
            this.file = new NRef();
            if (this.path != null) {
                try {
                    this.file.set(NBootUtils.toFile(this.path).toPath());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.file.get();
    }

    public URL getUrl() {
        if (this.url == null) {
            this.url = NRef.ofNull();
            if (this.path != null) {
                try {
                    this.url.set(NBootUtils.urlOf(this.path));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.url.get();
    }

    public boolean isRemote() {
        if (this.remote == null) {
            this.remote = NRef.ofNull();
            if (NBootUtils.isBlank(this.path)) {
                this.remote.set(false);
                return false;
            }
            int i = this.path.indexOf(58);
            if (i >= 0) {
                String protocol = this.path.substring(0, i);
                if (protocol.length() == 1) {
                    this.remote.set(false);
                    return false;
                }
                String sPath = this.path.substring(i + 1);
                if (protocol.equalsIgnoreCase("http") || protocol.equalsIgnoreCase("https")) {
                    if (sPath.startsWith("//")) {
                        String k;
                        sPath = sPath.substring(2);
                        Pattern p = Pattern.compile("^(?<n>[^!:/\\\\?#]*).*");
                        Matcher m = p.matcher(sPath);
                        if (m.find() && (k = m.group("n")) != null) {
                            if (k.startsWith("127.")) {
                                this.remote.set(false);
                                return false;
                            }
                            if (k.equalsIgnoreCase("localhost")) {
                                this.remote.set(false);
                                return false;
                            }
                        }
                    }
                    this.remote.set(true);
                    return true;
                }
                this.remote.set(true);
                return true;
            }
            this.remote.set(false);
            return false;
        }
        return this.remote.get();
    }

    public String getName() {
        int o;
        Path f = this.getFile();
        if (f != null) {
            return f.normalize().getFileName().toString();
        }
        URL u = this.getUrl();
        String z = this.path;
        if (u != null) {
            z = u.getFile();
        }
        if ((o = z.lastIndexOf(47)) >= 0) {
            return z.substring(o + 1);
        }
        return z;
    }

    public NBootPath resolve(String s) {
        Path f = this.getFile();
        if (f != null) {
            return new NBootPath(f.resolve(s));
        }
        int o = s.indexOf(63);
        if (o >= 0) {
            return new NBootPath(this.path.substring(0, o) + "/" + s + this.path.substring(o));
        }
        return new NBootPath(this.path + "/" + s);
    }

    public String toString() {
        return String.valueOf(this.path);
    }

    public NBootPath toAbsolute() {
        Path file = this.getFile();
        if (file != null) {
            return new NBootPath(file.normalize().toAbsolutePath());
        }
        return this;
    }

    public String getPath() {
        return this.path;
    }

    private static class NRef<T> {
        private T value;
        private boolean set;

        public static <T> NRef<T> of(T t) {
            return new NRef<T>(t);
        }

        public static <T> NRef<T> of(T t, Class<T> type) {
            return new NRef<T>(t);
        }

        public static <T> NRef<T> ofNull(Class<T> t) {
            return new NRef<Object>(null);
        }

        public static <T> NRef<T> ofNull() {
            return NRef.of(null);
        }

        public NRef() {
        }

        public NRef(T value) {
            this.value = value;
        }

        public T get() {
            return this.value;
        }

        public T orElse(T other) {
            if (this.value == null) {
                return other;
            }
            return this.value;
        }

        public void setNonNull(T value) {
            if (value != null) {
                this.set(value);
            }
        }

        public void set(T value) {
            this.value = value;
            this.set = true;
        }

        public void unset() {
            this.value = null;
            this.set = false;
        }

        public boolean isNotNull() {
            return this.value != null;
        }

        public boolean isEmpty() {
            return this.value == null || String.valueOf(this.value).isEmpty();
        }

        public boolean isNull() {
            return this.value == null;
        }

        public boolean isSet() {
            return this.set;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public boolean isValue(Object o) {
            return Objects.equals(this.value, o);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NRef nRef = (NRef)o;
            return this.set == nRef.set && Objects.equals(this.value, nRef.value);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.set);
        }
    }
}

