/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.cmdline;

import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootArg {
    public static final String KEY_PATTERN_STRING = "[a-zA-Z0-9_.@&^$%][a-zA-Z0-9_.@&^$%+!-]*";
    public static final Pattern PATTERN_OPTION_EQ = Pattern.compile("^((?<optp>[-]+|[+]+)(?<cmt>//)?(?<flg>[!~])?)?(?<optk>[a-zA-Z0-9_.@&^$%][a-zA-Z0-9_.@&^$%+!-]*)?(?<opts>[=](?<optv>.*))?(?<optr>.*)$");
    public static final Pattern PATTERN_OPTION_COL = Pattern.compile("^((?<optp>[-]+|[+]+)(?<cmt>//)?(?<flg>[!~])?)?(?<optk>[a-zA-Z0-9_.@&^$%][a-zA-Z0-9_.@&^$%+!-]*)?(?<opts>[:](?<optv>.*))?(?<optr>.*)$");
    private final char eq;
    private final String key;
    private final String value;
    private final String optionPrefix;
    private final String optionName;
    private final boolean enabled;
    private final boolean active;
    private final boolean option;
    private final String image;

    public static boolean isSimpleKey(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean isKeyStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '.' || c == '@' || c == '&' || c == '^' || c == '$' || c == '%';
    }

    public static boolean isKeyPart(char c) {
        return NBootArg.isKeyStart(c) || c == '-' || c == '+' || c == '!';
    }

    public NBootArg(String expression) {
        this(expression, '=');
    }

    public NBootArg(String image, char eq) {
        Pattern currOptionsPattern;
        this.eq = (char)(eq == '\u0000' ? 61 : (int)eq);
        this.image = image;
        switch (this.eq) {
            case '=': {
                currOptionsPattern = PATTERN_OPTION_EQ;
                break;
            }
            case ':': {
                currOptionsPattern = PATTERN_OPTION_COL;
                break;
            }
            default: {
                currOptionsPattern = Pattern.compile("^((?<optp>[-]+|[+]+)(?<cmt>//)?(?<flg>[!~])?)?(?<optk>[a-zA-Z0-9_.@&^$%][a-zA-Z0-9_.@&^$%+!-]**)?(?<opts>[" + eq + "](?<optv>.*))?(?<optr>.*)$");
            }
        }
        Matcher matcher = currOptionsPattern.matcher(image == null ? "" : image);
        if (matcher.find()) {
            String optp = matcher.group("optp");
            String cmt = matcher.group("cmt");
            String flg = matcher.group("flg");
            String optk = matcher.group("optk");
            String opts = matcher.group("opts");
            String optv = matcher.group("optv");
            String optr = matcher.group("optr");
            if (optp != null && optp.length() > 0) {
                this.option = true;
                this.active = cmt == null || cmt.length() <= 0;
                this.enabled = flg == null || flg.length() <= 0;
                this.optionPrefix = optp;
                if (optr != null && optr.length() > 0) {
                    this.optionName = (optk == null ? "" : optk) + optr;
                    this.key = optp + this.optionName;
                    this.value = null;
                } else {
                    String string = this.optionName = optk == null ? "" : optk;
                    if (opts != null && opts.length() > 0) {
                        this.key = optp + this.optionName;
                        this.value = optv + optr;
                    } else {
                        this.key = optp + this.optionName;
                        this.value = null;
                    }
                }
            } else {
                this.option = false;
                this.active = true;
                this.enabled = true;
                this.optionPrefix = null;
                this.optionName = null;
                if (opts != null && opts.length() > 0) {
                    this.key = image == null ? null : (optk == null ? "" : optk);
                    this.value = optv;
                } else {
                    this.key = image == null ? null : (optk == null ? "" : optk) + optr;
                    this.value = null;
                }
            }
        } else {
            this.active = true;
            this.enabled = true;
            this.option = false;
            this.optionName = null;
            this.key = null;
            this.value = null;
            this.optionPrefix = null;
        }
    }

    public boolean isOption() {
        return this.option;
    }

    public boolean isNonOption() {
        return !this.isOption();
    }

    public String getStringKey() {
        return this.getKey();
    }

    public String key() {
        String k = this.getStringKey();
        return k == null ? "" : k;
    }

    public String value() {
        return this.getStringValue();
    }

    public String getStringValue() {
        return this.getValue();
    }

    public boolean isNegated() {
        return !this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isActive() {
        return this.active;
    }

    public NBootArg required() {
        if (this.image == null) {
            throw new NoSuchElementException("missing value");
        }
        return this;
    }

    public boolean isKeyValue() {
        return this.value != null;
    }

    public String getOptionPrefix() {
        return this.optionPrefix;
    }

    public String getSeparator() {
        return String.valueOf(this.eq);
    }

    public String getOptionName() {
        return this.optionName;
    }

    public String getValue() {
        return this.value;
    }

    public Boolean getBooleanValue() {
        boolean v = NBootUtils.parseBooleanOr(this.getValue(), true);
        if (this.isNegated()) {
            return this.isNegated() != v;
        }
        return v;
    }

    public Integer getIntValue() {
        return NBootUtils.parseInt(this.getValue());
    }

    public String getKey() {
        return this.key == null ? this.image : this.key;
    }

    public boolean isFlagOption() {
        return this.isOption() && this.getValue() == null;
    }

    public String toString() {
        return String.valueOf(this.image);
    }

    public String getImage() {
        return this.image;
    }

    public static NBootArg of(String s) {
        return new NBootArg(s);
    }
}

