/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot;

import java.util.Arrays;
import net.thevpc.nuts.boot.NBootArguments;
import net.thevpc.nuts.boot.NBootOptionsInfo;
import net.thevpc.nuts.boot.NBootWorkspaceImpl;
import net.thevpc.nuts.boot.NBootWorkspaceNativeExec;
import net.thevpc.nuts.boot.core.NExceptionWithExitCodeBase;
import net.thevpc.nuts.boot.core.NWorkspaceBase;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public interface NBootWorkspace {
    public static final String NUTS_BOOT_VERSION = "0.8.9";

    public static NBootWorkspace of(String[] args) {
        return NBootWorkspace.of(NBootArguments.of(args));
    }

    public static NBootWorkspace of(NBootOptionsInfo options) {
        return new NBootWorkspaceImpl(options);
    }

    public static NBootWorkspace of(NBootArguments userOptionsUnparsed) {
        if (userOptionsUnparsed == null) {
            userOptionsUnparsed = new NBootArguments();
        }
        if (userOptionsUnparsed.getOptionArgs() != null && userOptionsUnparsed.getOptionArgs().length > 0 && userOptionsUnparsed.getOptionArgs()[0].equals("native-exec")) {
            userOptionsUnparsed.setOptionArgs(Arrays.copyOfRange(userOptionsUnparsed.getOptionArgs(), 1, userOptionsUnparsed.getOptionArgs().length));
            return new NBootWorkspaceNativeExec(userOptionsUnparsed);
        }
        return new NBootWorkspaceImpl(userOptionsUnparsed);
    }

    public static int exitOnError(Throwable th) {
        if (th != null) {
            int c;
            NExceptionWithExitCodeBase ec = NBootUtils.findThrowable(th, NExceptionWithExitCodeBase.class, null);
            int n = c = ec == null ? 254 : ec.getExitCode();
            if (c != 0) {
                System.exit(c);
            }
            return c;
        }
        return 0;
    }

    public NBootArguments getBootArguments();

    public NBootOptionsInfo getOptions();

    public NWorkspaceBase getWorkspace();

    public NBootWorkspace runWorkspace();
}

