/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.boot.NBootAddRepositoryOptions;
import net.thevpc.nuts.boot.NBootException;
import net.thevpc.nuts.boot.NBootRepositorySelectorList;
import net.thevpc.nuts.boot.internal.util.NBootMsg;
import net.thevpc.nuts.boot.internal.util.NBootRepositoryDB;
import net.thevpc.nuts.boot.internal.util.NBootStringMapFormat;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootRepositoryLocation
implements Comparable<NBootRepositoryLocation>,
Cloneable {
    protected static final Pattern FULL_PATTERN = Pattern.compile("((?<n>[a-zA-Z][a-zA-Z0-9_-]*)?=)?((?<t>[a-zA-Z][a-zA-Z0-9_-]*)?@)?(?<r>.*)");
    private final String name;
    private final String locationType;
    private final String path;
    private final Map<String, String> properties;

    private NBootRepositoryLocation(String name, String locationType, String path, Map<String, String> properties) {
        this.name = name;
        this.locationType = locationType;
        this.path = path;
        this.properties = properties;
    }

    public static NBootRepositoryLocation of(String name, String locationType, String path) {
        return NBootRepositoryLocation.of(name, locationType, path, null);
    }

    public static NBootRepositoryLocation of(String name, String locationType, String path, Map<String, String> properties) {
        PathAndProps u = NBootRepositoryLocation.createPathAndProps(path);
        if (properties != null) {
            for (Map.Entry<String, String> e : properties.entrySet()) {
                if (e.getKey() == null) continue;
                u.props.put(e.getKey(), e.getValue());
            }
        }
        return new NBootRepositoryLocation(NBootUtils.trimToNull(name), NBootUtils.trimToNull(locationType), u.path, u.props);
    }

    protected NBootRepositoryLocation(String locationString) {
        String path0;
        Matcher nm;
        if (locationString == null) {
            locationString = "";
        }
        if ((nm = FULL_PATTERN.matcher(locationString)).find()) {
            this.name = NBootUtils.trimToNull(nm.group("n"));
            this.locationType = NBootUtils.trimToNull(nm.group("t"));
            path0 = NBootUtils.trimToNull(nm.group("r"));
        } else {
            this.name = null;
            this.locationType = null;
            path0 = NBootUtils.trimToNull(locationString);
        }
        PathAndProps p = NBootRepositoryLocation.createPathAndProps(path0);
        this.path = p.path;
        this.properties = p.props;
    }

    public static NBootRepositoryLocation of(String locationString) {
        return new NBootRepositoryLocation(locationString);
    }

    public static NBootRepositoryLocation ofName(String name) {
        return NBootRepositoryLocation.of(name, (String)null);
    }

    public static NBootRepositoryLocation of(String name, String fullLocation) {
        NBootRepositoryLocation q = NBootRepositoryLocation.of(fullLocation);
        if (name != null) {
            q = q.setName(name);
        }
        return q;
    }

    public static NBootRepositoryLocation of(String locationString, NBootRepositoryDB db) {
        String name = null;
        String url = null;
        if (locationString == null) {
            return null;
        }
        if ((locationString = locationString.trim()).startsWith("-") || locationString.startsWith("+") || locationString.startsWith("=") || locationString.indexOf(44) >= 0 || locationString.indexOf(59) >= 0) {
            throw new NBootException(NBootMsg.ofC("invalid selection syntax : %s", locationString));
        }
        Matcher matcher = Pattern.compile("(?<name>[a-zA-Z-_]+)=(?<value>.+)").matcher(locationString);
        if (matcher.find()) {
            name = matcher.group("name");
            url = matcher.group("value");
        } else if (locationString.matches("[a-zA-Z][a-zA-Z0-9-_]+")) {
            String u;
            name = locationString;
            NBootAddRepositoryOptions ro = db.getRepositoryOptionsByName(name);
            String string = u = ro == null ? null : ro.getConfig().getLocation().getFullLocation();
            url = u == null ? name : u;
        } else {
            url = locationString;
            NBootAddRepositoryOptions ro = db.getRepositoryOptionsByLocation(name);
            String n = ro == null ? null : ro.getName();
            name = n == null ? null : n;
        }
        if (url.length() > 0) {
            return NBootRepositoryLocation.of(name, url);
        }
        return null;
    }

    public static NBootRepositoryLocation[] of(String repositorySelectionExpression, NBootRepositoryLocation[] available, NBootRepositoryDB db) {
        NBootRepositorySelectorList li = NBootRepositorySelectorList.of(repositorySelectionExpression, db);
        if (li == null) {
            return new NBootRepositoryLocation[0];
        }
        return li.resolve(available, db);
    }

    public String getName() {
        return this.name;
    }

    public NBootRepositoryLocation setName(String name) {
        return new NBootRepositoryLocation(NBootUtils.trimToNull(name), this.locationType, this.path, new LinkedHashMap<String, String>(this.properties));
    }

    public String getPath() {
        return this.path;
    }

    public NBootRepositoryLocation setPath(String path) {
        PathAndProps p = NBootRepositoryLocation.createPathAndProps(path);
        p.props.putAll(this.properties);
        return new NBootRepositoryLocation(this.name, this.locationType, p.path, p.props);
    }

    private static PathAndProps createPathAndProps(String path) {
        LinkedHashMap properties;
        String validPath;
        if (path == null) {
            validPath = null;
            properties = new LinkedHashMap<String, String>();
        } else {
            int i = path.indexOf(63);
            if (i >= 0) {
                String ms = path.substring(i + 1);
                LinkedHashMap m = NBootStringMapFormat.URL_FORMAT.parse(ms);
                properties = m == null ? new LinkedHashMap() : m;
                validPath = path.substring(0, i);
            } else {
                validPath = path;
                properties = new LinkedHashMap();
            }
        }
        return new PathAndProps(validPath, properties);
    }

    public String getTypeAndPath() {
        StringBuilder sb = new StringBuilder();
        if (!NBootUtils.isBlank(this.locationType)) {
            sb.append(this.locationType);
            sb.append("@");
        }
        if (!NBootUtils.isBlank(this.path)) {
            sb.append(this.path);
        }
        return sb.toString();
    }

    public String getLocationType() {
        return this.locationType;
    }

    public NBootRepositoryLocation setLocationType(String locationType) {
        return new NBootRepositoryLocation(this.name, NBootUtils.trimToNull(locationType), this.path, new LinkedHashMap<String, String>(this.properties));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBootRepositoryLocation that = (NBootRepositoryLocation)o;
        return Objects.equals(this.toString(), that.toString());
    }

    public String getFullLocation() {
        StringBuilder sb = new StringBuilder();
        if (!NBootUtils.isBlank(this.locationType)) {
            sb.append(this.locationType);
            sb.append("@");
        }
        if (!NBootUtils.isBlank(this.path)) {
            sb.append(this.path);
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            sb.append("?");
            sb.append(NBootStringMapFormat.URL_FORMAT.format(this.properties));
        }
        return sb.toString();
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!NBootUtils.isBlank(this.name)) {
            sb.append(this.name);
            sb.append("=");
        }
        sb.append(this.getFullLocation());
        return sb.toString();
    }

    public boolean isBlank() {
        if (!NBootUtils.isBlank(this.name)) {
            return false;
        }
        if (!NBootUtils.isBlank(this.locationType)) {
            return false;
        }
        if (!NBootUtils.isBlank(this.path)) {
            return false;
        }
        return this.properties.isEmpty();
    }

    @Override
    public int compareTo(NBootRepositoryLocation o) {
        if (o == null) {
            return 1;
        }
        return this.toString().compareTo(o.toString());
    }

    public NBootRepositoryLocation copy() {
        return this.clone();
    }

    protected NBootRepositoryLocation clone() {
        try {
            return (NBootRepositoryLocation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private static class PathAndProps {
        String path;
        Map<String, String> props;

        public PathAndProps(String path, Map<String, String> props) {
            this.path = path;
            this.props = props;
        }
    }
}

