/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.artifact;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import java.util.regex.Pattern;
import net.thevpc.nuts.artifact.DefaultNVersion;
import net.thevpc.nuts.artifact.NVersionComparator;
import net.thevpc.nuts.artifact.NVersionFilter;
import net.thevpc.nuts.artifact.NVersionInterval;
import net.thevpc.nuts.artifact.NVersionPart;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;

public interface NVersion
extends Serializable,
Comparable<NVersion>,
NBlankable {
    public static final Pattern PATTERN = Pattern.compile("[A-Za-z0-9._*,()\\[\\] ${}+-]+");
    public static final NVersion BLANK = new DefaultNVersion("");

    public static NOptional<NVersion> get(String version) {
        if (NBlankable.isBlank(version)) {
            return NOptional.of(BLANK);
        }
        String version2 = NStringUtils.trim(version);
        if (PATTERN.matcher(version2).matches()) {
            return NOptional.of(new DefaultNVersion(version2));
        }
        return NOptional.ofError(() -> NMsg.ofC("invalid version format : %s", version));
    }

    public static NVersion of(String version) {
        return NVersion.get(version).get();
    }

    public boolean isNull();

    public String getValue();

    @Override
    public int compareTo(String var1);

    @Override
    public int compareTo(NVersion var1);

    public int compareTo(NVersion var1, NVersionComparator var2);

    public int compareTo(String var1, NVersionComparator var2);

    public NVersion toCanonical();

    public NVersion toNormalized();

    public NVersionFilter filter();

    public NVersionFilter filter(NVersionComparator var1);

    public NVersion compatNewer();

    public NVersion compatOlder();

    public NOptional<List<NVersionInterval>> intervals();

    public NOptional<List<NVersionInterval>> intervals(NVersionComparator var1);

    public boolean isSingleValue();

    public NOptional<String> asSingleValue();

    public boolean isFilter();

    public NVersion inc();

    public NVersion inc(int var1);

    public NVersion inc(int var1, long var2);

    public NVersion inc(int var1, BigInteger var2);

    public int size();

    public int numberSize();

    public NOptional<NLiteral> get(int var1);

    public NLiteral[] split();

    public NOptional<NLiteral> getNumberLiteralAt(int var1);

    public NOptional<Integer> getIntegerAt(int var1);

    public NOptional<Long> getLongAt(int var1);

    public boolean isLatestVersion();

    public boolean isReleaseVersion();

    public boolean isSnapshotVersion();

    public List<NVersionPart> parts();
}

