/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.artifact;

import java.util.EnumSet;
import net.thevpc.nuts.artifact.NDependencyScope;
import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NEnumUtils;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NOptional;

public enum NDependencyScopePattern implements NEnum
{
    API,
    IMPLEMENTATION,
    PROVIDED,
    IMPORT,
    RUNTIME,
    SYSTEM,
    TEST_API,
    TEST_IMPLEMENTATION,
    TEST_PROVIDED,
    TEST_RUNTIME,
    TEST_SYSTEM,
    OTHER,
    TEST_OTHER,
    TEST_COMPILE,
    TEST,
    COMPILE,
    RUN,
    RUN_TEST,
    ALL;

    private final String id = NNameFormat.ID_NAME.format(this.name());

    public static NOptional<NDependencyScopePattern> parse(String value) {
        return NEnumUtils.parseEnum(value, NDependencyScopePattern.class, s -> {
            switch (s.getNormalizedValue()) {
                case "COMPILEONLY": 
                case "COMPILE_ONLY": 
                case "PROVIDED": {
                    return NOptional.of(PROVIDED);
                }
                case "TESTCOMPILE": 
                case "TESTAPI": 
                case "TEST_API": {
                    return NOptional.of(TEST_API);
                }
                case "TESTRUNTIME": 
                case "TEST_RUNTIME": {
                    return NOptional.of(TEST_RUNTIME);
                }
                case "TESTSYSTEM": 
                case "TEST_SYSTEM": {
                    return NOptional.of(TEST_SYSTEM);
                }
                case "TESTPROVIDED": 
                case "TEST_PROVIDED": 
                case "TESTCOMPILEONLY": 
                case "TEST_COMPILE_ONLY": {
                    return NOptional.of(TEST_PROVIDED);
                }
                case "API": {
                    return NOptional.of(API);
                }
                case "IMPL": 
                case "IMPLEMENTATION": {
                    return NOptional.of(IMPLEMENTATION);
                }
                case "IMPORT": {
                    return NOptional.of(IMPORT);
                }
                case "RUNTIME": {
                    return NOptional.of(RUNTIME);
                }
                case "TEST_IMPL": 
                case "TEST_IMPLEMENTATION": {
                    return NOptional.of(TEST_IMPLEMENTATION);
                }
                case "TEST_OTHER": {
                    return NOptional.of(TEST_OTHER);
                }
                case "OTHER": {
                    return NOptional.of(OTHER);
                }
                case "SYSTEM": {
                    return NOptional.of(SYSTEM);
                }
                case "TEST_COMPILE": {
                    return NOptional.of(TEST_COMPILE);
                }
                case "TEST": {
                    return NOptional.of(TEST);
                }
                case "COMPILE": {
                    return NOptional.of(COMPILE);
                }
                case "RUN": {
                    return NOptional.of(RUN);
                }
                case "RUN_TEST": {
                    return NOptional.of(RUN_TEST);
                }
                case "ALL": {
                    return NOptional.of(ALL);
                }
            }
            return null;
        });
    }

    @Override
    public String id() {
        return this.id;
    }

    public EnumSet<NDependencyScope> toScopes() {
        EnumSet<NDependencyScope> v = EnumSet.noneOf(NDependencyScope.class);
        switch (this.ordinal()) {
            case 16: {
                v.add(NDependencyScope.API);
                v.add(NDependencyScope.IMPLEMENTATION);
                v.add(NDependencyScope.SYSTEM);
                v.add(NDependencyScope.RUNTIME);
                break;
            }
            case 17: {
                v.addAll(RUN.toScopes());
                v.add(NDependencyScope.TEST_API);
                v.add(NDependencyScope.TEST_RUNTIME);
                break;
            }
            case 15: {
                v.add(NDependencyScope.API);
                v.add(NDependencyScope.IMPLEMENTATION);
                v.add(NDependencyScope.SYSTEM);
                v.add(NDependencyScope.PROVIDED);
                break;
            }
            case 14: {
                v.add(NDependencyScope.TEST_API);
                v.add(NDependencyScope.TEST_RUNTIME);
                v.add(NDependencyScope.TEST_PROVIDED);
                break;
            }
            case 18: {
                v.add(NDependencyScope.API);
                v.add(NDependencyScope.IMPLEMENTATION);
                v.add(NDependencyScope.RUNTIME);
                v.add(NDependencyScope.SYSTEM);
                v.add(NDependencyScope.PROVIDED);
                v.add(NDependencyScope.TEST_API);
                v.add(NDependencyScope.TEST_RUNTIME);
                v.add(NDependencyScope.TEST_PROVIDED);
                v.add(NDependencyScope.OTHER);
                break;
            }
            case 0: {
                v.add(NDependencyScope.API);
            }
            case 3: {
                v.add(NDependencyScope.IMPORT);
            }
            case 1: {
                v.add(NDependencyScope.IMPLEMENTATION);
            }
            case 2: {
                v.add(NDependencyScope.PROVIDED);
            }
            case 4: {
                v.add(NDependencyScope.RUNTIME);
            }
            case 5: {
                v.add(NDependencyScope.SYSTEM);
            }
            case 13: {
                v.add(NDependencyScope.TEST_API);
            }
            case 8: {
                v.add(NDependencyScope.TEST_PROVIDED);
            }
            case 9: {
                v.add(NDependencyScope.TEST_RUNTIME);
            }
            case 10: {
                v.add(NDependencyScope.TEST_SYSTEM);
            }
            case 6: {
                v.add(NDependencyScope.TEST_API);
            }
            case 7: {
                v.add(NDependencyScope.TEST_IMPLEMENTATION);
            }
            case 12: {
                v.add(NDependencyScope.TEST_OTHER);
            }
            case 11: {
                v.add(NDependencyScope.OTHER);
            }
            default: {
                throw new IllegalArgumentException("unsupported scope pattern " + this);
            }
        }
        return v;
    }
}

