/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.artifact;

import java.io.Serializable;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.artifact.NVersionComparator;
import net.thevpc.nuts.artifact.NVersionInterval;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNVersionInterval
implements NVersionInterval,
Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean includeLowerBound;
    private final boolean includeUpperBound;
    private final String lowerBound;
    private final String upperBound;
    private NVersionComparator versionComparator;

    public DefaultNVersionInterval(boolean inclusiveLowerBoundary, boolean inclusiveUpperBoundary, String min, String max, NVersionComparator versionComparator) {
        this.includeLowerBound = inclusiveLowerBoundary;
        this.includeUpperBound = inclusiveUpperBoundary;
        this.lowerBound = NStringUtils.trimToNull(min);
        this.upperBound = NStringUtils.trimToNull(max);
        this.versionComparator = versionComparator;
    }

    @Override
    public boolean acceptVersion(NVersion version) {
        int t;
        NVersionComparator versionComparator;
        NVersionComparator nVersionComparator = versionComparator = this.versionComparator == null ? NVersionComparator.ofMaven() : this.versionComparator;
        if (!(NBlankable.isBlank(this.lowerBound) || this.lowerBound.equals("LATEST") || this.lowerBound.equals("RELEASE"))) {
            t = versionComparator.compare(version, NVersion.of(this.lowerBound));
            if (this.includeLowerBound && t < 0 || !this.includeLowerBound && t <= 0) {
                return false;
            }
        }
        if (!(NBlankable.isBlank(this.upperBound) || this.upperBound.equals("LATEST") || this.upperBound.equals("RELEASE"))) {
            t = versionComparator.compare(version, NVersion.of(this.upperBound));
            return !(this.includeUpperBound && t > 0 || !this.includeUpperBound && t >= 0);
        }
        return true;
    }

    @Override
    public boolean isFixedValue() {
        return this.includeLowerBound && this.includeUpperBound && NStringUtils.trim(this.lowerBound).equals(NStringUtils.trim(this.upperBound)) && !"LATEST".equals(this.lowerBound) && !"RELEASE".equals(this.lowerBound);
    }

    @Override
    public boolean isIncludeLowerBound() {
        return this.includeLowerBound;
    }

    @Override
    public boolean isIncludeUpperBound() {
        return this.includeUpperBound;
    }

    @Override
    public String getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public String getUpperBound() {
        return this.upperBound;
    }

    public String toString() {
        String lb;
        String ub = this.upperBound == null ? "" : this.upperBound;
        boolean sameBound = ub.equals(lb = this.lowerBound == null ? "" : this.lowerBound);
        if (sameBound && !lb.isEmpty()) {
            return (this.includeLowerBound ? "[" : "]") + lb + (this.includeUpperBound ? "]" : "[");
        }
        return (this.includeLowerBound ? "[" : "]") + lb + "," + ub + (this.includeUpperBound ? "]" : "[");
    }
}

