/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.artifact;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyBuilder;
import net.thevpc.nuts.artifact.NEnvCondition;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.artifact.NIdFilter;
import net.thevpc.nuts.artifact.NIdFilters;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.boot.internal.util.NBootUtils;
import net.thevpc.nuts.internal.NReservedLangUtils;
import net.thevpc.nuts.internal.NReservedUtils;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStringMapFormat;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNId
implements NId {
    public static final long serialVersionUID = 1L;
    private final String groupId;
    private final String artifactId;
    private final String classifier;
    private final NVersion version;
    private final String properties;
    private final NEnvCondition condition;

    public DefaultNId() {
        this.groupId = null;
        this.artifactId = null;
        this.version = NVersion.BLANK;
        this.classifier = null;
        this.condition = NEnvCondition.BLANK;
        this.properties = "";
    }

    public DefaultNId(String groupId, String artifactId, NVersion version) {
        this.groupId = NStringUtils.trimToNull(groupId);
        this.artifactId = NStringUtils.trimToNull(artifactId);
        this.version = version == null ? NVersion.BLANK : version;
        this.classifier = null;
        this.condition = NEnvCondition.BLANK;
        this.properties = "";
    }

    public DefaultNId(String groupId, String artifactId, String classifier, NVersion version, Map<String, String> properties, NEnvCondition condition) {
        this.groupId = NStringUtils.trimToNull(groupId);
        this.artifactId = NStringUtils.trimToNull(artifactId);
        this.version = version == null ? NVersion.BLANK : version;
        this.classifier = NStringUtils.trimToNull(classifier);
        this.condition = condition == null ? NEnvCondition.BLANK : condition;
        this.properties = NStringUtils.trim(NStringMapFormat.DEFAULT.format(properties));
    }

    public DefaultNId(String groupId, String artifactId, String classifier, NVersion version, String properties, NEnvCondition condition) {
        this(groupId, artifactId, classifier, version, NStringMapFormat.DEFAULT.parse(properties).get(), condition);
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isBlank() {
        return this.toString().isEmpty();
    }

    @Override
    public String getMavenFolder() {
        StringBuilder sb = new StringBuilder();
        if (!NBootUtils.isBlank(this.groupId)) {
            sb.append(String.join((CharSequence)"/", NStringUtils.split(this.groupId, "./\\", true, true)));
        }
        if (!NBootUtils.isBlank(this.artifactId)) {
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(this.artifactId);
            if (!NBlankable.isBlank(this.version)) {
                sb.append("/");
                sb.append(this.version);
            }
        }
        return sb.toString();
    }

    @Override
    public String getMavenFileName(String extension) {
        StringBuilder sb = new StringBuilder();
        if (!NBlankable.isBlank(this.artifactId)) {
            sb.append(this.artifactId);
        }
        if (!NBlankable.isBlank(this.version)) {
            sb.append("-").append(this.version);
        }
        if (!NBlankable.isBlank(this.classifier)) {
            sb.append("-").append(this.classifier);
        }
        if (!NBlankable.isBlank(extension)) {
            sb.append(".").append(extension);
        }
        return sb.toString();
    }

    @Override
    public String getMavenPath(String extension) {
        String p = this.getMavenFolder();
        String n = this.getMavenFileName(extension);
        if (p.isEmpty()) {
            return n;
        }
        if (n.isEmpty()) {
            return p + "/";
        }
        return p + "/" + n;
    }

    @Override
    public boolean equalsShortId(NId other) {
        if (other == null) {
            return false;
        }
        return NStringUtils.trim(this.groupId).equals(NStringUtils.trim(other.getGroupId())) && NStringUtils.trim(this.artifactId).equals(NStringUtils.trim(other.getArtifactId())) && Objects.equals(this.getClassifier(), other.getClassifier());
    }

    @Override
    public boolean isLongId() {
        if (NBlankable.isBlank(this.properties)) {
            return true;
        }
        return this.getProperties().isEmpty();
    }

    @Override
    public boolean isShortId() {
        return NBlankable.isBlank(this.properties) && NBlankable.isBlank(this.version);
    }

    @Override
    public boolean equalsLongId(NId other) {
        if (other == null) {
            return false;
        }
        return NStringUtils.trim(this.groupId).equals(NStringUtils.trim(other.getGroupId())) && NStringUtils.trim(this.artifactId).equals(NStringUtils.trim(other.getArtifactId())) && Objects.equals(this.version == null || this.version.isBlank() ? null : this.version, other.getVersion() == null || other.getVersion().isBlank() ? null : other.getVersion()) && Objects.equals(this.getClassifier(), other.getClassifier());
    }

    @Override
    public String getFace() {
        String s = this.getProperties().get("face");
        return NStringUtils.trimToNull(s);
    }

    @Override
    public String getClassifier() {
        return NStringUtils.trimToNull(this.classifier);
    }

    @Override
    public String getPackaging() {
        String s = this.getProperties().get("packaging");
        return NStringUtils.trimToNull(s);
    }

    @Override
    public NEnvCondition getCondition() {
        return this.condition;
    }

    @Override
    public String getPropertiesQuery() {
        return this.properties;
    }

    @Override
    public Map<String, String> getProperties() {
        return NStringMapFormat.DEFAULT.parse(this.properties).get();
    }

    @Override
    public String getRepository() {
        String s = this.getProperties().get("repo");
        return NStringUtils.trimToNull(s);
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public NId getShortId() {
        return new DefaultNId(this.groupId, this.artifactId, this.classifier, (NVersion)null, "", NEnvCondition.BLANK);
    }

    @Override
    public NId getLongId() {
        return new DefaultNId(this.groupId, this.artifactId, this.classifier, this.version, "", NEnvCondition.BLANK);
    }

    @Override
    public String getShortName() {
        return NReservedUtils.getIdShortName(this.groupId, this.artifactId, this.classifier);
    }

    @Override
    public String getLongName() {
        return NReservedUtils.getIdLongName(this.groupId, this.artifactId, this.version, this.classifier);
    }

    @Override
    public String getFullName() {
        return this.toString();
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public NVersion getVersion() {
        return this.version;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (NBlankable.isBlank(this.classifier)) {
            if (!NBlankable.isBlank(this.groupId)) {
                sb.append(this.groupId).append(":");
            }
            sb.append(NStringUtils.trim(this.artifactId));
        } else {
            sb.append(NStringUtils.trim(this.groupId));
            sb.append(":").append(NStringUtils.trim(this.artifactId));
            sb.append(":").append(NStringUtils.trim(this.classifier));
        }
        NVersion v = this.getVersion();
        if (!v.isBlank()) {
            sb.append("#");
            sb.append(v);
        }
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.putAll(NReservedUtils.toMap(this.condition));
        for (Map.Entry<String, String> e : NStringMapFormat.DEFAULT.parse(this.properties).get().entrySet()) {
            if (m.containsKey(e.getKey())) continue;
            m.put(e.getKey(), e.getValue());
        }
        if (!m.isEmpty()) {
            sb.append("?").append(NStringMapFormat.DEFAULT.format(m));
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNId nutsId = (DefaultNId)o;
        if (!Objects.equals(this.groupId, nutsId.groupId)) {
            return false;
        }
        if (!Objects.equals(this.artifactId, nutsId.artifactId)) {
            return false;
        }
        if (!Objects.equals(this.version, nutsId.version)) {
            return false;
        }
        if (!Objects.equals(this.classifier, nutsId.classifier)) {
            return false;
        }
        return Objects.equals(this.properties, nutsId.properties);
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }

    @Override
    public NDependency toDependency() {
        Map<String, String> properties = this.getProperties();
        String exc = properties.get("exclusions");
        if (exc == null) {
            exc = "";
        }
        ArrayList<NId> a = new ArrayList<NId>();
        for (String s : NReservedLangUtils.splitDefault(exc)) {
            NId n = NId.get(s).get();
            if (n == null) continue;
            a.add(n);
        }
        return NDependencyBuilder.of().setRepository(this.getRepository()).setArtifactId(this.getArtifactId()).setGroupId(this.getGroupId()).setClassifier(this.getClassifier()).setVersion(this.getVersion()).setScope(properties.get("scope")).setOptional(properties.get("optional")).setExclusions(a).setCondition(this.getCondition()).setProperties(properties).build();
    }

    @Override
    public NIdBuilder builder() {
        return NIdBuilder.of(this);
    }

    @Override
    public int compareTo(NId o2) {
        int x = NStringUtils.trim(this.getGroupId()).compareTo(NStringUtils.trim(o2.getGroupId()));
        if (x != 0) {
            return x;
        }
        x = NStringUtils.trim(this.getArtifactId()).compareTo(NStringUtils.trim(o2.getArtifactId()));
        if (x != 0) {
            return x;
        }
        x = NStringUtils.trim(this.getClassifier()).compareTo(NStringUtils.trim(o2.getClassifier()));
        if (x != 0) {
            return x;
        }
        x = this.getVersion().compareTo(o2.getVersion());
        if (x != 0) {
            return x;
        }
        return 0;
    }

    @Override
    public NIdFilter filter() {
        return NIdFilters.of().byValue(this);
    }

    @Override
    public NId compatNewer() {
        return this.builder().setVersion(this.getVersion().compatNewer()).build();
    }

    @Override
    public NId compatOlder() {
        return this.builder().setVersion(this.getVersion().compatOlder()).build();
    }
}

