/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.app;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.app.NAppBuilder;
import net.thevpc.nuts.app.NAppDefinition;
import net.thevpc.nuts.app.NAppInstaller;
import net.thevpc.nuts.app.NAppRunner;
import net.thevpc.nuts.app.NAppUninstaller;
import net.thevpc.nuts.app.NAppUpdater;
import net.thevpc.nuts.app.NApplication;
import net.thevpc.nuts.boot.NBootException;
import net.thevpc.nuts.boot.internal.util.NBootMsg;
import net.thevpc.nuts.text.NI18n;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NExceptions;

public final class NApplications {
    private static final ThreadLocal<Map<String, Object>> sharedMap = new ThreadLocal();

    private NApplications() {
    }

    public static Map<String, Object> getSharedMap() {
        Map<String, Object> m = sharedMap.get();
        if (m == null) {
            m = new LinkedHashMap<String, Object>();
            sharedMap.set(m);
        }
        return m;
    }

    @Deprecated
    public static <T extends NApplication> T createApplicationInstance(Class<T> appType) {
        String[] args = null;
        return NApplications.createApplicationInstance(appType, args);
    }

    public static NAppDefinition resolveApplicationAnnotation(Class appClass) {
        Class<?> validAppClass = NApplications.unproxyType(appClass);
        return validAppClass.getAnnotation(NAppDefinition.class);
    }

    public static boolean isAnnotatedApplicationClass(Class appClass) {
        return NApplications.resolveApplicationAnnotation(appClass) != null;
    }

    public static NApplication createApplicationInstanceFromAnnotatedInstance(Object appInstance) {
        NAssert.requireNonNull(appInstance, "appInstance");
        if (appInstance instanceof NApplication) {
            return (NApplication)appInstance;
        }
        Class<?> appClass = NApplications.unproxyType(appInstance.getClass());
        NAppDefinition appAnnotation = appClass.getAnnotation(NAppDefinition.class);
        if (appAnnotation == null) {
            throw new NBootException(NBootMsg.ofC("class %s is missing annotation @" + NAppDefinition.class.getSimpleName(), appClass.getName()));
        }
        NAssert.requireNonNull(appAnnotation, "@NAppDefinition annotation");
        ArrayList<Method> runMethods = new ArrayList<Method>();
        ArrayList<Method> installMethods = new ArrayList<Method>();
        ArrayList<Method> uninstallMethods = new ArrayList<Method>();
        ArrayList<Method> updateMethods = new ArrayList<Method>();
        HashSet<String> visited = new HashSet<String>();
        for (Class<?> cc = appClass; cc != null; cc = cc.getSuperclass()) {
            for (Method m : cc.getMethods()) {
                if (m.getParameterCount() != 0 || !visited.add(m.getName())) continue;
                if (m.getAnnotation(NAppRunner.class) != null) {
                    runMethods.add(m);
                }
                if (m.getAnnotation(NAppUpdater.class) != null) {
                    updateMethods.add(m);
                }
                if (m.getAnnotation(NAppInstaller.class) != null) {
                    installMethods.add(m);
                }
                if (m.getAnnotation(NAppUninstaller.class) == null) continue;
                uninstallMethods.add(m);
            }
            try {
                for (Method m : cc.getDeclaredMethods()) {
                    NApplications.checkAllowedMethodWithNutsAnnotation(m, NAppRunner.class);
                    NApplications.checkAllowedMethodWithNutsAnnotation(m, NAppInstaller.class);
                    NApplications.checkAllowedMethodWithNutsAnnotation(m, NAppUninstaller.class);
                    NApplications.checkAllowedMethodWithNutsAnnotation(m, NAppUpdater.class);
                }
                continue;
            }
            catch (NBootException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new AnnotationClassNApplication(runMethods, installMethods, updateMethods, uninstallMethods, appInstance);
    }

    private static boolean checkAllowedMethodWithNutsAnnotation(Method m, Class annClass) {
        Object u = m.getAnnotation(annClass);
        if (u != null) {
            if (m.getParameterCount() != 0) {
                throw new NBootException(NBootMsg.ofC("method %s has annotation @%s. it should not have parameters", m, annClass.getName()));
            }
            if (!Modifier.isPublic(m.getModifiers())) {
                throw new NBootException(NBootMsg.ofC("method %s has annotation @%s. it should be public"));
            }
            return true;
        }
        return false;
    }

    private static boolean isProxyType(Class<?> aClass) {
        if (aClass == null) {
            return false;
        }
        String simpleName = aClass.getSimpleName();
        return simpleName.contains("$$EnhancerBySpringCGLIB$$") || simpleName.contains("$$CGLIB$$") || simpleName.contains("$$SpringCGLIB$$");
    }

    public static Class<?> unproxyType(Class<?> aClass) {
        Class<?> u;
        if (aClass == null) {
            return null;
        }
        if (NApplications.isProxyType(aClass) && (u = NApplications.unproxyType(aClass.getSuperclass())) != null) {
            return u;
        }
        return aClass;
    }

    public static <T extends NApplication> T createApplicationInstance(Class<T> appType, String[] args) {
        try {
            for (Method declaredMethod : appType.getDeclaredMethods()) {
                if (!Modifier.isStatic(declaredMethod.getModifiers()) || !declaredMethod.getName().equals("createApplicationInstance") || declaredMethod.getParameterCount() != 1 || !declaredMethod.getParameterTypes()[0].equals(String[].class)) continue;
                if (appType.isAssignableFrom(declaredMethod.getReturnType())) {
                    declaredMethod.setAccessible(true);
                    Object o = declaredMethod.invoke(null, new Object[]{args});
                    if (o == null) break;
                    return (T)((NApplication)appType.cast(o));
                }
                throw NExceptions.ofSafeIllegalArgumentException(NMsg.ofC(NI18n.of("createApplicationInstance must return an instance of type %s"), appType.getName()));
            }
            Constructor<?> dconstructor = null;
            for (Constructor<?> constructor : appType.getConstructors()) {
                if (constructor.getParameterCount() == 1 && constructor.getParameterTypes()[0].equals(String[].class)) {
                    return (T)((NApplication)constructor.newInstance(new Object[]{args}));
                }
                if (constructor.getParameterCount() != 0) continue;
                dconstructor = constructor;
                return (T)((NApplication)dconstructor.newInstance(new Object[0]));
            }
        }
        catch (InstantiationException ex) {
            Throwable c = ex.getCause();
            if (c instanceof RuntimeException) {
                throw (RuntimeException)c;
            }
            if (c instanceof Error) {
                throw (Error)c;
            }
            throw NExceptions.ofSafeIllegalArgumentException(NMsg.ofC(NI18n.of("unable to instantiate application %s"), appType.getName()), ex);
        }
        catch (IllegalAccessException ex) {
            throw NExceptions.ofSafeIllegalArgumentException(NMsg.ofC(NI18n.of("illegal access to default constructor for %s"), appType.getName()), ex);
        }
        catch (InvocationTargetException ex) {
            throw NExceptions.ofSafeIllegalArgumentException(NMsg.ofC(NI18n.of("invocation exception for %s"), appType.getName()), ex);
        }
        throw NExceptions.ofSafeIllegalArgumentException(NMsg.ofC(NI18n.of("missing application constructor for %s from of : \n\t static createApplicationInstance(NSession,String[])\n\t Constructor(NSession,String[])\n\t Constructor()"), appType.getName()));
    }

    public static NAppBuilder builder() {
        return new NAppBuilder();
    }

    static class AnnotationClassNApplication
    implements NApplication {
        private final List<Method> runMethods;
        private final List<Method> installMethods;
        private final List<Method> updateMethods;
        private final List<Method> uninstallMethods;
        private final Object appInstance;

        public AnnotationClassNApplication(List<Method> runMethods, List<Method> installMethods, List<Method> updateMethods, List<Method> uninstallMethods, Object appInstance) {
            this.runMethods = runMethods;
            this.installMethods = installMethods;
            this.updateMethods = updateMethods;
            this.uninstallMethods = uninstallMethods;
            this.appInstance = appInstance;
        }

        public Object getAppInstance() {
            return this.appInstance;
        }

        @Override
        public void run() {
            for (Method runMethod : this.runMethods) {
                this.doRunThis(runMethod);
            }
        }

        @Override
        public void onInstallApplication() {
            for (Method runMethod : this.installMethods) {
                this.doRunThis(runMethod);
            }
        }

        @Override
        public void onUpdateApplication() {
            for (Method runMethod : this.updateMethods) {
                this.doRunThis(runMethod);
            }
        }

        @Override
        public void onUninstallApplication() {
            for (Method runMethod : this.uninstallMethods) {
                this.doRunThis(runMethod);
            }
        }

        private void doRunThis(Method m) {
            try {
                if (Modifier.isStatic(m.getModifiers())) {
                    m.invoke(null, new Object[0]);
                } else {
                    m.invoke(this.appInstance, new Object[0]);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                if (e.getTargetException() != null) {
                    throw new RuntimeException(e.getTargetException());
                }
                throw new RuntimeException(e);
            }
        }
    }
}

