/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.app;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.app.NApp;
import net.thevpc.nuts.app.NAppInitInfo;
import net.thevpc.nuts.app.NApplication;
import net.thevpc.nuts.app.NApplicationHandleMode;
import net.thevpc.nuts.app.NApplications;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.boot.NBootArguments;
import net.thevpc.nuts.boot.internal.cmdline.NBootCmdLine;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.text.NI18n;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NClock;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NExceptionHandler;

public class NAppBuilder {
    private NApplicationHandleMode handleMode = NApplicationHandleMode.HANDLE;
    private Object instance;
    private String[] nutsArgs;
    private String[] args;

    public static NAppBuilder of() {
        return new NAppBuilder();
    }

    public static NAppBuilder of(String[] args) {
        return new NAppBuilder().args(args);
    }

    public NAppBuilder handleErrors() {
        this.handleMode = NApplicationHandleMode.HANDLE;
        return this;
    }

    public NAppBuilder propagateErrors() {
        this.handleMode = NApplicationHandleMode.PROPAGATE;
        return this;
    }

    public NAppBuilder fatalErrors() {
        this.handleMode = NApplicationHandleMode.EXIT;
        return this;
    }

    public NAppBuilder ignoreErrors() {
        this.handleMode = NApplicationHandleMode.NOP;
        return this;
    }

    private void runInstance(NApplication applicationInstance) {
        String appClassName;
        boolean inherited = NWorkspace.of().getBootOptions().getInherited().orElse(false);
        NApp nApp = NApp.of();
        String string = appClassName = nApp.getAppClass() == null ? null : nApp.getAppClass().getName();
        if (appClassName == null) {
            appClassName = applicationInstance.getClass().getName();
        }
        NId appId = nApp.getId().orNull();
        NLog.of(NApplications.class).log(NMsg.ofC(NI18n.of("running application %s: %s (%s) %s"), inherited ? "(" + NI18n.of("inherited") + ")" : "", appId == null ? "<" + NI18n.of("unresolved-id") + ">" : appId, appClassName, nApp.getCmdLine()).asFine().withIntent(NMsgIntent.START));
        try {
            switch (nApp.getMode()) {
                case RUN: 
                case AUTO_COMPLETE: {
                    applicationInstance.run();
                    return;
                }
                case INSTALL: {
                    applicationInstance.onInstallApplication();
                    return;
                }
                case UPDATE: {
                    applicationInstance.onUpdateApplication();
                    return;
                }
                case UNINSTALL: {
                    applicationInstance.onUninstallApplication();
                    return;
                }
            }
        }
        catch (NExecutionException e) {
            if (e.getExitCode() == 0) {
                return;
            }
            throw e;
        }
        throw new NExecutionException(NMsg.ofC(NI18n.of("unsupported execution mode %s"), nApp.getMode()), 255);
    }

    public NApplicationHandleMode getHandleMode() {
        return this.handleMode;
    }

    public NAppBuilder setHandleMode(NApplicationHandleMode mode) {
        this.handleMode = mode;
        return this;
    }

    public Object getInstance() {
        return this.instance;
    }

    public NAppBuilder instance(Object applicationInstance) {
        this.instance = applicationInstance;
        return this;
    }

    private Object createInstance(Class applicationType) {
        try {
            return applicationType == null ? null : applicationType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public NAppBuilder type(Class applicationType) {
        this.instance = applicationType == null ? null : this.createInstance(applicationType);
        return this;
    }

    public String[] getNutsArgs() {
        return this.nutsArgs;
    }

    public NAppBuilder setNutsArgs(String ... nutsArgs) {
        this.nutsArgs = nutsArgs;
        return this;
    }

    public NAppBuilder setNutsArgsLine(String nutsArgs) {
        this.nutsArgs = NBootCmdLine.parseDefault(nutsArgs);
        return this;
    }

    public NAppBuilder setNutsArgsLine(String nutsArgs, String[] extraArgs) {
        ArrayList<String> all = new ArrayList<String>();
        all.addAll(Arrays.asList(NBootCmdLine.parseDefault(nutsArgs)));
        if (extraArgs != null) {
            for (String s : extraArgs) {
                if (s == null) continue;
                all.add(s);
            }
        }
        this.nutsArgs = all.toArray(new String[0]);
        return this;
    }

    public String[] getArgs() {
        return this.args;
    }

    public NAppBuilder args(String[] args) {
        this.args = args;
        return this;
    }

    public void run() {
        NApplicationHandleMode m = this.getHandleMode() == null ? NApplicationHandleMode.HANDLE : this.getHandleMode();
        try {
            Class<?> c;
            Method main;
            StackTraceElement[] stackTrace;
            NClock now = NClock.now();
            String[] args = this.getArgs() == null ? new String[]{} : this.getArgs();
            Object applicationInstanceObj = this.getInstance();
            if (applicationInstanceObj == null && (stackTrace = new Throwable().getStackTrace()).length >= 1 && Objects.equals(stackTrace[1].getMethodName(), "main") && Modifier.isStatic((main = (c = Class.forName(stackTrace[1].getClassName(), true, Thread.currentThread().getContextClassLoader())).getDeclaredMethod("main", String[].class)).getModifiers())) {
                applicationInstanceObj = this.createInstance(c);
            }
            NAssert.requireNonNull(applicationInstanceObj, "applicationInstance");
            NApplication applicationInstance = applicationInstanceObj instanceof NApplication ? (NApplication)applicationInstanceObj : NApplications.createApplicationInstanceFromAnnotatedInstance(applicationInstanceObj);
            Class<?> appClass = applicationInstance instanceof NApplications.AnnotationClassNApplication ? ((NApplications.AnnotationClassNApplication)applicationInstance).getAppInstance().getClass() : applicationInstance.getClass();
            NWorkspace ws = NWorkspace.get().orNull();
            if (ws == null) {
                ws = Nuts.openWorkspace(NBootArguments.of(this.getNutsArgs()).setAppArgs(args));
            }
            ws.runWith(() -> {
                NApp a = NApp.of();
                a.setArguments(args);
                a.prepare(new NAppInitInfo(args, appClass, now));
                this.runInstance(applicationInstance);
            });
            switch (m) {
                case EXIT: {
                    System.exit(0);
                }
            }
        }
        catch (Exception e) {
            switch (m) {
                case PROPAGATE: {
                    NExceptionHandler.of(e).propagate();
                    break;
                }
                case EXIT: {
                    NExceptionHandler.of(e).handleFatal();
                    break;
                }
                case HANDLE: {
                    NExceptionHandler.of(e).handle();
                    break;
                }
                default: {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

