/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.ToggleButtonBehavior;
import com.sun.javafx.scene.control.skin.LabeledSkinBase;
import com.sun.javafx.scene.control.skin.Utils;
import javafx.scene.Node;
import javafx.scene.control.RadioButton;
import javafx.scene.layout.StackPane;

public class RadioButtonSkin
extends LabeledSkinBase<RadioButton, ToggleButtonBehavior<RadioButton>> {
    private StackPane radio = RadioButtonSkin.createRadio();

    public RadioButtonSkin(RadioButton radioButton) {
        super(radioButton, new ToggleButtonBehavior<RadioButton>(radioButton));
        this.updateChildren();
    }

    @Override
    protected void updateChildren() {
        super.updateChildren();
        if (this.radio != null) {
            this.getChildren().add(this.radio);
        }
    }

    private static StackPane createRadio() {
        StackPane radio = new StackPane();
        radio.getStyleClass().setAll((String[])new String[]{"radio"});
        radio.setSnapToPixel(false);
        StackPane region = new StackPane();
        region.getStyleClass().setAll((String[])new String[]{"dot"});
        radio.getChildren().clear();
        radio.getChildren().addAll((Node[])new Node[]{region});
        return radio;
    }

    @Override
    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computeMinWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSize(this.radio.minWidth(-1.0));
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Math.max(this.snapSize(super.computeMinHeight(width - this.radio.minWidth(-1.0), topInset, rightInset, bottomInset, leftInset)), topInset + this.radio.minHeight(-1.0) + bottomInset);
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSize(this.radio.prefWidth(-1.0));
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Math.max(this.snapSize(super.computePrefHeight(width - this.radio.prefWidth(-1.0), topInset, rightInset, bottomInset, leftInset)), topInset + this.radio.prefHeight(-1.0) + bottomInset);
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        RadioButton radioButton = (RadioButton)this.getSkinnable();
        double radioWidth = this.radio.prefWidth(-1.0);
        double radioHeight = this.radio.prefHeight(-1.0);
        double computeWidth = Math.max(radioButton.prefWidth(-1.0), radioButton.minWidth(-1.0));
        double labelWidth = Math.min(computeWidth - radioWidth, w - this.snapSize(radioWidth));
        double labelHeight = Math.min(radioButton.prefHeight(labelWidth), h);
        double maxHeight = Math.max(radioHeight, labelHeight);
        double xOffset = Utils.computeXOffset(w, labelWidth + radioWidth, radioButton.getAlignment().getHpos()) + x;
        double yOffset = Utils.computeYOffset(h, maxHeight, radioButton.getAlignment().getVpos()) + y;
        this.layoutLabelInArea(xOffset + radioWidth, yOffset, labelWidth, maxHeight, radioButton.getAlignment());
        this.radio.resize(this.snapSize(radioWidth), this.snapSize(radioHeight));
        this.positionInArea(this.radio, xOffset, yOffset, radioWidth, maxHeight, 0.0, radioButton.getAlignment().getHpos(), radioButton.getAlignment().getVpos());
    }
}

