/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font.freetype;

import com.sun.javafx.font.DisposerRecord;
import com.sun.javafx.font.FontStrikeDesc;
import com.sun.javafx.font.Glyph;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.PrismFontStrike;
import com.sun.javafx.font.freetype.FTFontFile;
import com.sun.javafx.font.freetype.FTGlyph;
import com.sun.javafx.font.freetype.FT_Matrix;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.transform.BaseTransform;

class FTFontStrike
extends PrismFontStrike<FTFontFile> {
    FT_Matrix matrix;

    protected FTFontStrike(FTFontFile fontResource, float size, BaseTransform tx, int aaMode, FontStrikeDesc desc) {
        super(fontResource, size, tx, aaMode, desc);
        float maxDim = PrismFontFactory.getFontSizeLimit();
        if (tx.isTranslateOrIdentity()) {
            this.drawShapes = size > maxDim;
        } else {
            BaseTransform tx2d = this.getTransform();
            this.matrix = new FT_Matrix();
            this.matrix.xx = (int)(tx2d.getMxx() * 65536.0);
            this.matrix.yx = (int)(-tx2d.getMyx() * 65536.0);
            this.matrix.xy = (int)(-tx2d.getMxy() * 65536.0);
            this.matrix.yy = (int)(tx2d.getMyy() * 65536.0);
            if (Math.abs(tx2d.getMxx() * (double)size) > (double)maxDim || Math.abs(tx2d.getMyx() * (double)size) > (double)maxDim || Math.abs(tx2d.getMxy() * (double)size) > (double)maxDim || Math.abs(tx2d.getMyy() * (double)size) > (double)maxDim) {
                this.drawShapes = true;
            }
        }
    }

    @Override
    protected DisposerRecord createDisposer(FontStrikeDesc desc) {
        return null;
    }

    @Override
    protected Glyph createGlyph(int glyphCode) {
        return new FTGlyph(this, glyphCode, this.drawShapes);
    }

    @Override
    protected Path2D createGlyphOutline(int glyphCode) {
        FTFontFile fontResource = (FTFontFile)this.getFontResource();
        return fontResource.createGlyphOutline(glyphCode, this.getSize());
    }

    void initGlyph(FTGlyph glyph) {
        FTFontFile fontResource = (FTFontFile)this.getFontResource();
        fontResource.initGlyph(glyph, this);
    }
}

