/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NEnumUtils;
import net.thevpc.nuts.util.NOptional;

public enum NWordFormat implements NEnum
{
    CAPITALIZED,
    UPPERCASE,
    LOWERCASE,
    UNCAPITALIZED;

    private final String id = this.name().toLowerCase();

    public static NOptional<NWordFormat> parse(String value) {
        return NEnumUtils.parseEnum(value, NWordFormat.class);
    }

    @Override
    public String id() {
        return this.id;
    }

    public String formatWord(String value) {
        if (value != null) {
            switch (this.ordinal()) {
                case 1: {
                    return value.toUpperCase();
                }
                case 2: {
                    return value.toLowerCase();
                }
                case 0: {
                    if (value.isEmpty()) break;
                    char[] c = value.toCharArray();
                    c[0] = Character.toUpperCase(c[0]);
                    for (int i = 1; i < value.length(); ++i) {
                        c[i] = Character.toLowerCase(c[i]);
                    }
                    return new String(c);
                }
                case 3: {
                    if (value.isEmpty()) break;
                    char[] c = value.toCharArray();
                    c[0] = Character.toLowerCase(c[0]);
                    return new String(c);
                }
            }
        }
        throw new UnsupportedOperationException();
    }
}

