/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.util.NImmutable;
import net.thevpc.nuts.util.NUplet;

final class NUpletImpl<T>
implements NUplet<T>,
NImmutable {
    private T[] values;

    public NUpletImpl(T[] a) {
        this.values = Arrays.copyOf(a, a.length);
    }

    @Override
    public Iterator<T> iterator() {
        return Arrays.asList(this.values).iterator();
    }

    @Override
    public T get(int index) {
        return this.values[index];
    }

    @Override
    public NUplet<T> set(T newValue, int index) {
        T[] b = Arrays.copyOf(this.values, this.values.length);
        b[index] = newValue;
        return new NUpletImpl<T>(b);
    }

    @Override
    public List<T> toList() {
        return Arrays.asList(this.values);
    }

    @Override
    public T[] toArray() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    @Override
    public int size() {
        return this.values.length;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NUpletImpl nUplet = (NUpletImpl)o;
        return Objects.deepEquals(this.values, nUplet.values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public String toString() {
        int iMax = this.values.length - 1;
        if (iMax == -1) {
            return "()";
        }
        StringBuilder b = new StringBuilder();
        b.append('(');
        int i = 0;
        while (true) {
            b.append(this.values[i]);
            if (i == iMax) {
                return b.append(')').toString();
            }
            b.append(", ");
            ++i;
        }
    }
}

