/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.reflect.NReflectUtils;
import net.thevpc.nuts.util.NImmutable;
import net.thevpc.nuts.util.NUplet3;

final class NUplet3Impl<A extends T, B extends T, C extends T, T>
implements NUplet3<A, B, C, T>,
NImmutable {
    private final A a;
    private final B b;
    private final C c;

    public NUplet3Impl(A a, B b, C c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }

    @Override
    public A first() {
        return this.a;
    }

    @Override
    public B second() {
        return this.b;
    }

    @Override
    public C third() {
        return this.c;
    }

    @Override
    public T get(int index) {
        switch (index) {
            case 0: {
                return (T)this.a;
            }
            case 1: {
                return (T)this.b;
            }
            case 2: {
                return (T)this.c;
            }
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    @Override
    public NUplet3<A, B, C, T> set(T newValue, int index) {
        switch (index) {
            case 0: {
                return new NUplet3Impl<T, B, C, T>(newValue, this.b, this.c);
            }
            case 1: {
                return new NUplet3Impl<A, T, C, T>(this.a, newValue, this.c);
            }
            case 2: {
                return new NUplet3Impl<A, B, T, T>(this.a, this.b, newValue);
            }
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    @Override
    public NUplet3<A, B, C, T> setFirst(A t) {
        return this.set(t, 0);
    }

    @Override
    public NUplet3<A, B, C, T> setSecond(B t) {
        return this.set(t, 1);
    }

    @Override
    public NUplet3<A, B, C, T> setThird(C t) {
        return this.set(t, 2);
    }

    @Override
    public Iterator<T> iterator() {
        return Arrays.asList(this.a, this.b, this.c).iterator();
    }

    @Override
    public List<T> toList() {
        return Arrays.asList(this.a, this.b, this.c);
    }

    @Override
    public T[] toArray() {
        Class<?> cc;
        Class<?> ca = this.a == null ? null : this.a.getClass();
        Class<?> cb = this.b == null ? null : this.b.getClass();
        Class<?> clazz = cc = this.c == null ? null : this.c.getClass();
        if (ca == null && cb == null && cc == null) {
            return new Object[]{this.a, this.b, this.c};
        }
        Object[] ts = (Object[])Array.newInstance(NReflectUtils.commonAncestor(ca, cb, cc), 3);
        ts[0] = this.a;
        ts[1] = this.b;
        ts[2] = this.c;
        return ts;
    }

    @Override
    public int size() {
        return 3;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NUplet3Impl nUplet3 = (NUplet3Impl)o;
        return Objects.equals(this.a, nUplet3.a) && Objects.equals(this.b, nUplet3.b) && Objects.equals(this.c, nUplet3.c);
    }

    public int hashCode() {
        return Objects.hash(this.a, this.b, this.c);
    }

    public String toString() {
        return "(" + this.a + ", " + this.b + ", " + this.c + ')';
    }
}

