/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NEnumUtils;
import net.thevpc.nuts.util.NExceptions;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NOptional;

public enum NSupportMode implements NEnum
{
    SUPPORTED,
    PREFERRED,
    ALWAYS,
    NEVER;

    private final String id = NNameFormat.ID_NAME.format(this.name());

    public static NOptional<NSupportMode> parse(String value) {
        return NEnumUtils.parseEnum(value, NSupportMode.class, s -> {
            switch (s.getNormalizedValue()) {
                case "UNSUPPORTED": 
                case "NO": 
                case "FALSE": {
                    return NOptional.of(NEVER);
                }
                case "YES": 
                case "TRUE": {
                    return NOptional.of(ALWAYS);
                }
            }
            return null;
        });
    }

    @Override
    public String id() {
        return this.id;
    }

    public boolean acceptCondition(NSupportMode request) {
        if (request == null) {
            request = NEVER;
        }
        switch (this.ordinal()) {
            case 3: {
                return false;
            }
            case 2: {
                return true;
            }
            case 0: {
                switch (request.ordinal()) {
                    case 3: {
                        return false;
                    }
                    case 0: 
                    case 2: {
                        return true;
                    }
                    case 1: {
                        return false;
                    }
                }
                throw NExceptions.ofSafeUnsupportedEnumException(request);
            }
            case 1: {
                switch (request.ordinal()) {
                    case 3: {
                        return false;
                    }
                    case 0: 
                    case 1: 
                    case 2: {
                        return true;
                    }
                }
                throw NExceptions.ofSafeUnsupportedEnumException(request);
            }
        }
        throw NExceptions.ofSafeUnsupportedEnumException(this);
    }
}

