/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringMapFormatBuilder;
import net.thevpc.nuts.util.NStringUtils;

public class NStringMapFormat {
    public static final Function<String, String> URL_ENCODER = x -> {
        try {
            return URLEncoder.encode(x, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    };
    public static final Function<String, String> URL_DECODER = x -> {
        try {
            return URLDecoder.decode(x, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    };
    public static NStringMapFormat URL_FORMAT = NStringMapFormatBuilder.of().setEqualsChars("=").setSeparatorChars("&").setSort(true).setEncoder(URL_ENCODER).setDecoder(URL_DECODER).setAcceptNullKeys(false).build();
    public static NStringMapFormat HTTP_HEADER_FORMAT = NStringMapFormatBuilder.of().setEqualsChars("=").setSeparatorChars(";").setDoubleQuoteSupported(true).setSort(false).setEncoder(URL_ENCODER).setDecoder(URL_DECODER).setAcceptNullKeys(false).build();
    public static NStringMapFormat COMMA_FORMAT = NStringMapFormatBuilder.of().setEqualsChars("=").setSeparatorChars(",").setEscapeChars("\\").setSort(true).setQuoteSupported(true).setAcceptNullKeys(false).build();
    public static NStringMapFormat DEFAULT = URL_FORMAT;
    private final String equalsChars;
    private final String separatorChars;
    private final String escapeChars;
    private final boolean sort;
    private final Function<String, String> decoder;
    private final Function<String, String> encoder;
    private boolean doubleQuoteSupported;
    private boolean simpleQuoteSupported;
    private boolean acceptNullKeys;

    NStringMapFormat(NStringMapFormatBuilder builder) {
        if (builder == null) {
            builder = new NStringMapFormatBuilder();
        }
        this.sort = builder.isSort();
        this.encoder = builder.getEncoder();
        this.decoder = builder.getDecoder();
        if (builder.getEqualsChars() != null) {
            for (char c : builder.getEqualsChars().toCharArray()) {
                if (!NStringMapFormat.isWhitespace(c)) continue;
                throw new IllegalArgumentException("eq chars could not include whitespaces");
            }
        }
        if (builder.getEscapeChars() != null) {
            for (char c : builder.getEscapeChars().toCharArray()) {
                if (!NStringMapFormat.isWhitespace(c)) continue;
                throw new IllegalArgumentException("eq chars could not include whitespaces");
            }
        }
        if (builder.getSeparatorChars() != null) {
            for (char c : builder.getSeparatorChars().toCharArray()) {
                if (!NStringMapFormat.isWhitespace(c)) continue;
                throw new IllegalArgumentException("eq chars could not include whitespaces");
            }
        }
        this.equalsChars = builder.getEqualsChars() == null ? "" : builder.getEqualsChars();
        this.separatorChars = builder.getSeparatorChars() == null ? "" : builder.getSeparatorChars();
        this.escapeChars = builder.getEscapeChars() == null ? "" : builder.getEscapeChars();
        this.doubleQuoteSupported = builder.isDoubleQuoteSupported();
        this.simpleQuoteSupported = builder.isSimpleQuoteSupported();
        this.acceptNullKeys = builder.isAcceptNullKeys();
    }

    private Token readToken(PushbackReader reader, Function<String, String> decoder) {
        try {
            if (decoder == null) {
                decoder = x -> x;
            }
            String escapedTokens = this.escapeChars;
            String eqChars = this.equalsChars;
            String sepChars = this.separatorChars;
            StringBuilder value = new StringBuilder();
            StringBuilder image = new StringBuilder();
            int r = reader.read();
            if (r == -1) {
                return null;
            }
            char r1 = (char)r;
            if (NStringMapFormat.isWhitespace(r1)) {
                do {
                    if ((r = reader.read()) != -1) continue;
                    return null;
                } while (NStringMapFormat.isWhitespace((char)r));
                r1 = (char)r;
            } else {
                if (eqChars.indexOf(r1) >= 0) {
                    return new Token(TokenType.EQ, decoder.apply(String.valueOf(r1)), String.valueOf(r1));
                }
                if (sepChars.indexOf(r1) >= 0) {
                    return new Token(TokenType.SEP, decoder.apply(String.valueOf(r1)), String.valueOf(r1));
                }
            }
            if (r == 34 && this.doubleQuoteSupported || r == 39 && this.simpleQuoteSupported) {
                char cr = (char)r;
                image.append(cr);
                block16: while (true) {
                    if ((r = reader.read()) == -1) {
                        throw new RuntimeException("Expected " + cr);
                    }
                    image.append(cr);
                    if (r == cr) {
                        return new Token(cr == '\"' ? TokenType.SIMPLE_QUOTED : TokenType.DOUBLE_QUOTED, decoder.apply(value.toString()), value.toString());
                    }
                    if (r == 92) {
                        r = reader.read();
                        if (r == -1) {
                            throw new RuntimeException("Expected " + cr);
                        }
                        image.append((char)r);
                        switch ((char)r) {
                            case 'n': {
                                value.append('\n');
                                continue block16;
                            }
                            case 'r': {
                                value.append('\r');
                                continue block16;
                            }
                            case 'f': {
                                value.append('\f');
                                continue block16;
                            }
                            case 't': {
                                value.append('\t');
                                continue block16;
                            }
                        }
                        value.append('\\');
                        value.append((char)r);
                        continue;
                    }
                    value.append((char)r);
                }
            }
            reader.unread(r);
            block17: while (true) {
                if ((r = reader.read()) < 0) {
                    return new Token(TokenType.WORD, decoder.apply(value.toString()), image.toString());
                }
                char cr = (char)r;
                if (escapedTokens.indexOf(cr) >= 0) {
                    image.append(cr);
                    r = reader.read();
                    if (r == -1) {
                        value.append(cr);
                        return new Token(TokenType.WORD, decoder.apply(value.toString()), image.toString());
                    }
                    cr = (char)r;
                    image.append(cr);
                    if (escapedTokens.indexOf(cr) >= 0 || NStringMapFormat.isWhitespace(cr) || eqChars.indexOf(cr) >= 0 || sepChars.indexOf(cr) >= 0) {
                        value.append(cr);
                        continue;
                    }
                    switch ((char)r) {
                        case ' ': {
                            value.append(' ');
                            continue block17;
                        }
                        case 'n': {
                            value.append('\n');
                            continue block17;
                        }
                        case 'r': {
                            value.append('\r');
                            continue block17;
                        }
                        case 'f': {
                            value.append('\f');
                            continue block17;
                        }
                        case 't': {
                            value.append('\t');
                            continue block17;
                        }
                    }
                    value.append(cr);
                    value.append((char)r);
                    continue;
                }
                if (NStringMapFormat.isWhitespace(cr) || eqChars.indexOf(cr) >= 0 || sepChars.indexOf(cr) >= 0) {
                    reader.unread(cr);
                    return new Token(TokenType.WORD, decoder.apply(value.toString()), image.toString());
                }
                value.append(cr);
                image.append(cr);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public NOptional<Map<String, String>> parse(String text) {
        NOptional<Map<String, List<String>>> d = this.parseDuplicates(text);
        return d.map(x -> {
            LinkedHashMap<String, String> r = new LinkedHashMap<String, String>();
            for (Map.Entry e : x.entrySet()) {
                r.put((String)e.getKey(), (String)((List)e.getValue()).get(((List)e.getValue()).size() - 1));
            }
            return r;
        });
    }

    public NOptional<Map<String, List<String>>> parseDuplicates(String text) {
        Function<String, String> decoder = this.decoder;
        if (decoder == null) {
            decoder = x -> x;
        }
        LinkedHashMap<String, List> m = new LinkedHashMap<String, List>();
        if (NBlankable.isBlank(text)) {
            return NOptional.of(m);
        }
        PushbackReader reader = new PushbackReader(new StringReader(text));
        ArrayList<Token> tokens = new ArrayList<Token>();
        while (true) {
            Token r = null;
            try {
                r = this.readToken(reader, decoder);
            }
            catch (UncheckedIOException | NIOException e) {
                return NOptional.ofError(() -> NMsg.ofPlain("failed to read token"), (Throwable)e);
            }
            if (r == null) break;
            tokens.add(r);
        }
        if (this.skipSeparator(tokens)) {
            m.computeIfAbsent(null, v -> new ArrayList()).add(null);
        }
        while (true) {
            this.skipSeparator(tokens);
            Map.Entry<String, String> u = this.readEntry(tokens);
            if (u == null) break;
            m.computeIfAbsent(u.getKey(), v -> new ArrayList()).add(u.getValue());
        }
        return NOptional.of(m);
    }

    private boolean skipSeparator(List<Token> tokens) {
        if (!tokens.isEmpty() && tokens.get((int)0).type == TokenType.SEP) {
            tokens.remove(0);
            return true;
        }
        return false;
    }

    private Map.Entry<String, String> readEntry(List<Token> tokens) {
        boolean acceptNullKeys = this.acceptNullKeys;
        if (!tokens.isEmpty()) {
            if (tokens.get((int)0).type.isAnyWord()) {
                String k = tokens.remove((int)0).value;
                if (!tokens.isEmpty()) {
                    if (tokens.get((int)0).type == TokenType.EQ) {
                        tokens.remove(0);
                        if (!tokens.isEmpty()) {
                            if (tokens.get((int)0).type.isAnyWord()) {
                                Token v = tokens.remove(0);
                                return new AbstractMap.SimpleEntry<String, String>(k, v.value);
                            }
                            return new AbstractMap.SimpleEntry<String, Object>(k, null);
                        }
                        return new AbstractMap.SimpleEntry<String, Object>(k, null);
                    }
                    if (tokens.get((int)0).type == TokenType.SEP) {
                        tokens.remove(0);
                        return new AbstractMap.SimpleEntry<String, Object>(k, null);
                    }
                    if (this.getEqualsChars().isEmpty() && tokens.get((int)0).type.isAnyWord()) {
                        String v = tokens.remove((int)0).value;
                        return new AbstractMap.SimpleEntry<String, String>(k, v);
                    }
                    return new AbstractMap.SimpleEntry<String, Object>(k, null);
                }
                return new AbstractMap.SimpleEntry<String, Object>(k, null);
            }
            if (tokens.get((int)0).type == TokenType.SEP) {
                tokens.remove(0);
                return new AbstractMap.SimpleEntry<String, Object>(acceptNullKeys ? null : "", null);
            }
            if (tokens.get((int)0).type == TokenType.EQ) {
                tokens.remove(0);
                if (!tokens.isEmpty()) {
                    if (tokens.get((int)0).type.isAnyWord()) {
                        Token v = tokens.remove(0);
                        return new AbstractMap.SimpleEntry<String, String>(acceptNullKeys ? null : "", v.value);
                    }
                    return new AbstractMap.SimpleEntry<String, Object>(acceptNullKeys ? null : "", null);
                }
                return new AbstractMap.SimpleEntry<String, Object>(acceptNullKeys ? null : "", null);
            }
            return new AbstractMap.SimpleEntry<String, Object>(acceptNullKeys ? null : "", null);
        }
        return null;
    }

    private static boolean isWhitespace(char c) {
        if (c <= ' ') {
            return true;
        }
        return Character.isWhitespace(c);
    }

    public String format(Map<String, String> map) {
        if (map != null) {
            HashMap<String, List<String>> map2 = new HashMap<String, List<String>>();
            for (Map.Entry<String, String> e : map.entrySet()) {
                map2.put(e.getKey(), Arrays.asList(e.getValue()));
            }
            return this.formatDuplicates(map2);
        }
        return "";
    }

    public String formatDuplicates(Map<String, List<String>> map) {
        Function<String, String> encoder = this.encoder == null ? x -> x : this.encoder;
        StringBuilder sb = new StringBuilder();
        if (map != null) {
            if (this.sort) {
                map = new TreeMap<String, List<String>>(map);
            }
            Set<String> sortedKeys = map.keySet();
            for (String k : sortedKeys) {
                List<String> strings = map.get(k);
                for (String v : strings) {
                    if (v != null) {
                        if (sb.length() > 0) {
                            sb.append(this.separatorChars);
                        }
                        if (v.isEmpty()) {
                            sb.append(encoder.apply(k));
                            continue;
                        }
                        sb.append(encoder.apply(k)).append(this.equalsChars).append(encoder.apply(v));
                        continue;
                    }
                    if (sb.length() > 0) {
                        sb.append(this.separatorChars);
                    }
                    sb.append(encoder.apply(k));
                }
            }
        }
        return NStringUtils.trimToNull(sb.toString());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NStringMapFormat that = (NStringMapFormat)o;
        return this.sort == that.sort && Objects.equals(this.equalsChars, that.equalsChars) && Objects.equals(this.separatorChars, that.separatorChars) && Objects.equals(this.escapeChars, that.escapeChars) && Objects.equals(this.decoder, that.decoder) && Objects.equals(this.encoder, that.encoder);
    }

    public int hashCode() {
        return Objects.hash(this.equalsChars, this.separatorChars, this.escapeChars, this.sort, this.decoder, this.encoder);
    }

    public String getEqualsChars() {
        return this.equalsChars;
    }

    public String getSeparatorChars() {
        return this.separatorChars;
    }

    public String getEscapeChars() {
        return this.escapeChars;
    }

    public boolean isSort() {
        return this.sort;
    }

    public Function<String, String> getDecoder() {
        return this.decoder;
    }

    public Function<String, String> getEncoder() {
        return this.encoder;
    }

    public NStringMapFormatBuilder builder() {
        return NStringMapFormatBuilder.of().copyFrom(this);
    }

    private static class Token {
        TokenType type;
        String value;
        String image;

        public Token(TokenType type, String value) {
            this(type, value, value);
        }

        public Token(TokenType type, String value, String image) {
            this.type = type;
            this.value = value;
            this.image = image;
        }

        public String toString() {
            return "Token{type=" + (Object)((Object)this.type) + ", value='" + this.value + '\'' + ", image='" + this.image + '\'' + '}';
        }
    }

    private static enum TokenType {
        DOUBLE_QUOTED,
        SIMPLE_QUOTED,
        WORD,
        EQ,
        SEP;


        boolean isAnyWord() {
            return this == DOUBLE_QUOTED || this == SIMPLE_QUOTED || this == WORD;
        }
    }
}

