/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.function.Supplier;
import net.thevpc.nuts.util.NBooleanRef;
import net.thevpc.nuts.util.NByteRef;
import net.thevpc.nuts.util.NDoubleRef;
import net.thevpc.nuts.util.NFloatRef;
import net.thevpc.nuts.util.NIntRef;
import net.thevpc.nuts.util.NLongRef;
import net.thevpc.nuts.util.NObjectRef;
import net.thevpc.nuts.util.NShortRef;

public interface NRef<T>
extends Supplier<T> {
    public static <T> NRef<T> of() {
        return new NObjectRef<Object>(null);
    }

    public static <T> NRef<T> of(T t) {
        return new NObjectRef<T>(t);
    }

    public static <T> NRef<T> of(T t, Class<T> type) {
        return new NObjectRef<T>(t);
    }

    public static <T> NRef<T> ofNull(Class<T> t) {
        return new NObjectRef<Object>(null);
    }

    public static <T> NRef<T> ofNull() {
        return NRef.of(null);
    }

    public static NLongRef ofLong(Long value) {
        return new NLongRef(value);
    }

    public static NLongRef ofLong(long value) {
        return new NLongRef(value);
    }

    public static NLongRef ofLong() {
        return new NLongRef(null);
    }

    public static NIntRef ofInt(Integer value) {
        return new NIntRef(value);
    }

    public static NIntRef ofInt(int value) {
        return new NIntRef(value);
    }

    public static NIntRef ofInt() {
        return new NIntRef(null);
    }

    public static NBooleanRef ofFalse() {
        return new NBooleanRef(false);
    }

    public static NBooleanRef ofTrue() {
        return new NBooleanRef(true);
    }

    public static NBooleanRef ofBoolean(Boolean value) {
        return new NBooleanRef(value);
    }

    public static NBooleanRef ofBoolean(boolean value) {
        return new NBooleanRef(value);
    }

    public static NBooleanRef ofBoolean() {
        return new NBooleanRef(null);
    }

    public static NByteRef ofByte(Byte value) {
        return new NByteRef(value);
    }

    public static NByteRef ofByte(byte value) {
        return new NByteRef(value);
    }

    public static NByteRef ofByte() {
        return new NByteRef(null);
    }

    public static NShortRef ofShort(Short value) {
        return new NShortRef(value);
    }

    public static NShortRef ofShort(short value) {
        return new NShortRef(value);
    }

    public static NShortRef ofShort() {
        return new NShortRef(null);
    }

    public static NFloatRef ofFloat(Float value) {
        return new NFloatRef(value);
    }

    public static NFloatRef ofFloat(float value) {
        return new NFloatRef(Float.valueOf(value));
    }

    public static NFloatRef ofFloat() {
        return new NFloatRef(null);
    }

    public static NDoubleRef ofDouble(Double value) {
        return new NDoubleRef(value);
    }

    public static NDoubleRef ofDouble(double value) {
        return new NDoubleRef(value);
    }

    public static NDoubleRef ofDouble() {
        return new NDoubleRef(null);
    }

    @Override
    public T get();

    public T orElse(T var1);

    public void setNonNull(T var1);

    public void set(T var1);

    public void unset();

    public boolean isNotNull();

    public boolean isBlank();

    public boolean isEmpty();

    public boolean isNull();

    public boolean isSet();

    public String toString();

    public boolean isValue(Object var1);
}

