/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.util.NHex;
import net.thevpc.nuts.util.NStringBuilder;
import net.thevpc.nuts.util.NStringUtils;

public class NPropsTransformer {
    private Map<String, Function<String, String>> replacements = new LinkedHashMap<String, Function<String, String>>();
    private boolean sort = false;
    private boolean distinct = false;

    public static String encodeKey(String theString) {
        return NPropsTransformer.encodeString(theString, true, true, false);
    }

    public static String encodeValue(String theString) {
        return NPropsTransformer.encodeString(theString, false, false, false);
    }

    public static String encodeString(String theString, boolean escapeSpace, boolean escapeSep, boolean escapeComment) {
        if (theString == null) {
            theString = "";
        }
        char[] chars = theString.toCharArray();
        StringBuilder buffer = new StringBuilder(chars.length);
        block10: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\\': {
                    buffer.append("\\\\");
                    continue block10;
                }
                case ' ': {
                    if (i == 0 || i == chars.length - 1 || escapeSpace) {
                        buffer.append('\\');
                    }
                    buffer.append(' ');
                    continue block10;
                }
                case '\t': {
                    if (i == 0 || i == chars.length - 1 || escapeSpace) {
                        buffer.append("\\t");
                        continue block10;
                    }
                    buffer.append(c);
                    continue block10;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block10;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block10;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block10;
                }
                case '!': 
                case '#': {
                    if (escapeComment || i == 0) {
                        buffer.append('\\');
                    }
                    buffer.append(c);
                    continue block10;
                }
                case ':': 
                case '=': {
                    if (escapeSep) {
                        buffer.append('\\');
                    }
                    buffer.append(c);
                    continue block10;
                }
                default: {
                    if (c > '=' && c < '\u007f') {
                        buffer.append(c);
                        continue block10;
                    }
                    if (c < ' ' || c > '~') {
                        buffer.append('\\');
                        buffer.append('u');
                        buffer.append(NHex.toHexChar(c >> 12 & 0xF));
                        buffer.append(NHex.toHexChar(c >> 8 & 0xF));
                        buffer.append(NHex.toHexChar(c >> 4 & 0xF));
                        buffer.append(NHex.toHexChar(c & 0xF));
                        continue block10;
                    }
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public static void storeProperties(Map<String, String> props, OutputStream out, boolean sort) {
        NPropsTransformer.storeProperties(props, new OutputStreamWriter(out), sort);
    }

    public static void storeProperties(Map<String, String> props, Writer w, boolean sort) {
        try {
            Set<String> keys = props.keySet();
            if (sort) {
                keys = new TreeSet<String>(keys);
            }
            for (String key : keys) {
                String value = props.get(key);
                w.write(NPropsTransformer.encodeKey(key));
                w.write("=");
                w.write(NPropsTransformer.encodeValue(value));
                w.write("\n");
                w.flush();
            }
            w.flush();
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    public boolean isSort() {
        return this.sort;
    }

    public NPropsTransformer sort() {
        this.sort = true;
        return this;
    }

    public NPropsTransformer sort(boolean sort) {
        this.sort = sort;
        return this;
    }

    public NPropsTransformer setSort(boolean sort) {
        this.sort = sort;
        return this;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public NPropsTransformer distinct() {
        this.distinct = true;
        return this;
    }

    public NPropsTransformer distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public NPropsTransformer setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public NPropsTransformer remove(String varName) {
        this.replacements.put(varName, s -> null);
        return this;
    }

    public NPropsTransformer replace(String varName, String replacement) {
        NPropsTransformer.validateKeyName(varName);
        if (replacement == null) {
            this.replacements.put(varName, null);
        } else {
            this.replacements.put(varName, s -> replacement);
        }
        return this;
    }

    public NPropsTransformer unreplace(String varName) {
        this.replacements.remove(varName);
        return this;
    }

    public NPropsTransformer replace(String varName, Function<String, String> replacement) {
        NPropsTransformer.validateKeyName(varName);
        if (replacement == null) {
            this.replacements.put(varName, null);
        } else {
            this.replacements.put(varName, replacement);
        }
        return this;
    }

    private static void validateKeyName(String varName) {
        for (char c : varName.toCharArray()) {
            if (Character.isWhitespace(c)) {
                throw new IllegalArgumentException("invalid variable name " + varName);
            }
            if (c == '=') {
                throw new IllegalArgumentException("invalid variable name " + varName);
            }
            if (c != ':') continue;
            throw new IllegalArgumentException("invalid variable name " + varName);
        }
    }

    public void transform(Reader reader, PrintStream out) {
        BufferedReader bReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        ArrayList<Row> rows = new ArrayList<Row>();
        while (true) {
            Object sb;
            String line;
            block17: {
                line = null;
                sb = null;
                while (true) {
                    try {
                        line = bReader.readLine();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (line == null) break block17;
                    if (!line.endsWith("\\")) break;
                    if (sb == null) {
                        sb = new NStringBuilder();
                    }
                    ((NStringBuilder)sb).println(line);
                }
                if (sb == null) {
                    sb = new NStringBuilder();
                }
                ((NStringBuilder)sb).append(line);
            }
            if (sb == null) break;
            line = ((NStringBuilder)sb).toString();
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty()) {
                rows.add(new Row(RowType.EMPTY, null, line));
                continue;
            }
            if (trimmedLine.startsWith("#") || trimmedLine.startsWith("!")) {
                rows.add(new Row(RowType.COMMENT, null, line));
                continue;
            }
            if (this.processLine(line, rows)) continue;
            rows.add(this.newKeyVal(this.extractKey(line), line, rows));
        }
        if (this.distinct || this.sort) {
            int index = 1;
            for (Row row : rows) {
                row.index = index++;
            }
            if (this.sort) {
                rows.sort((a, b) -> {
                    if (a.type == RowType.KEY_VAL && b.type == RowType.KEY_VAL) {
                        int x = a.key.compareTo(b.key);
                        if (x != 0) {
                            return x;
                        }
                        return a.index - b.index;
                    }
                    if (a.index != b.index) {
                        return a.index - b.index;
                    }
                    return a.key.compareTo(b.key);
                });
            }
            if (this.distinct) {
                HashMap<String, Integer> keyToPos = new HashMap<String, Integer>();
                for (int i = 0; i < rows.size(); ++i) {
                    Row row = (Row)rows.get(i);
                    if (row.type != RowType.KEY_VAL) continue;
                    Integer pos = (Integer)keyToPos.get(row.key);
                    if (pos != null) {
                        rows.set(pos, row);
                        --i;
                        continue;
                    }
                    keyToPos.put(row.key, i);
                }
            }
        }
        for (Row row : rows) {
            if (row.headers != null) {
                for (Row header : row.headers) {
                    out.println(header.row);
                }
            }
            out.println(row.row);
        }
        out.flush();
    }

    private String extractKey(String line) {
        if (line == null) {
            return null;
        }
        line = line.trim();
        StringBuilder sb = new StringBuilder();
        StringBuilder pending = new StringBuilder();
        char[] charArray = line.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (Character.isWhitespace(c)) {
                pending.append(c);
                continue;
            }
            if (c == '=' || c == ':') break;
            if (c == '\\') {
                sb.append(c);
                if (++i >= charArray.length) continue;
                sb.append(charArray[i]);
                continue;
            }
            if (pending.length() > 0) {
                if (sb.length() > 0) {
                    sb.append((CharSequence)pending);
                }
                pending.setLength(0);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private Row newKeyVal(String key, String value, List<Row> rows) {
        ArrayList<Row> comments = new ArrayList<Row>();
        while (!rows.isEmpty() && rows.get((int)(rows.size() - 1)).type == RowType.COMMENT) {
            comments.add(0, rows.remove(rows.size() - 1));
        }
        Row row = new Row(RowType.KEY_VAL, key, value);
        if (comments.size() > 0) {
            row.headers = comments;
        }
        return row;
    }

    private boolean processLine(String line, List<Row> rows) {
        for (Map.Entry<String, Function<String, String>> e : this.replacements.entrySet()) {
            if (!this.replaceVar(e.getKey(), e.getValue(), line, rows)) continue;
            return true;
        }
        return false;
    }

    private boolean replaceVar(String varName, Function<String, String> suffix, String line, List<Row> rows) {
        String lineTrimmed = line.trim();
        if (lineTrimmed.startsWith(varName)) {
            String ext = lineTrimmed.substring(varName.length());
            if (ext.trim().startsWith("=")) {
                int e = line.indexOf(61);
                String oldValue = NStringUtils.trimLeft(ext.substring(1));
                String nv = suffix.apply(NPropsTransformer.decodeString(oldValue));
                if (nv != null) {
                    rows.add(this.newKeyVal(varName, line.substring(0, e + 1) + NPropsTransformer.encodeValue(nv), rows));
                }
                return true;
            }
            if (ext.trim().startsWith(":")) {
                int e = line.indexOf(58);
                String oldValue = NStringUtils.trimLeft(ext.substring(1));
                String nv = suffix.apply(NPropsTransformer.decodeString(oldValue));
                if (nv != null) {
                    rows.add(this.newKeyVal(varName, line.substring(0, e + 1) + NPropsTransformer.encodeValue(nv), rows));
                }
                return true;
            }
        }
        return false;
    }

    public static String decodeString(String str) {
        int i = 0;
        char[] in = str.toCharArray();
        int len = str.length();
        int bLen = len * 2;
        if (bLen < 0) {
            bLen = Integer.MAX_VALUE;
        }
        char[] out = new char[bLen];
        int oi = 0;
        int end = i + len;
        block7: while (i < end) {
            char c;
            if ((c = in[i++]) == '\\') {
                if ((c = in[i++]) == 'u') {
                    int nc = 0;
                    for (int j = 0; j < 4; ++j) {
                        if ((c = in[i++]) >= '0' && c <= '9') {
                            nc = (nc << 4) + c - 48;
                            continue;
                        }
                        if (c >= 'A' && c <= 'F') {
                            nc = (nc << 4) + 10 + c - 65;
                            continue;
                        }
                        if (c >= 'a' && c <= 'f') {
                            nc = (nc << 4) + 10 + c - 97;
                            continue;
                        }
                        throw new IllegalArgumentException("Invalid \\uxxxx encoding");
                    }
                    out[oi++] = (char)nc;
                    continue;
                }
                switch (c) {
                    case 't': {
                        out[oi++] = 9;
                        continue block7;
                    }
                    case 'r': {
                        out[oi++] = 13;
                        continue block7;
                    }
                    case 'n': {
                        out[oi++] = 10;
                        continue block7;
                    }
                    case 'f': {
                        out[oi++] = 12;
                        continue block7;
                    }
                    case '\\': {
                        out[oi++] = 92;
                        continue block7;
                    }
                }
                out[oi++] = c;
                continue;
            }
            out[oi++] = c;
        }
        return new String(out, 0, oi);
    }

    private static class Row {
        List<Row> headers;
        String key;
        String row;
        RowType type;
        int index;

        public Row(RowType type, String key, String row) {
            this.type = type;
            this.key = key;
            this.row = row;
        }
    }

    private static enum RowType {
        KEY_VAL,
        EMPTY,
        COMMENT;

    }
}

