/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Predicate;
import net.thevpc.nuts.spi.base.AbstractNPredicate;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NPredicate;

public class NPredicates {
    private static final Never NEVER = new Never();
    private static final Always ALWAYS = new Always();
    private static final Null NULL = new Null();
    private static final Blank BLANK = new Blank();

    public static <T> NPredicate<T> never() {
        return NEVER;
    }

    public static NPredicate<String> blank() {
        return BLANK;
    }

    public static <T> NPredicate<T> always() {
        return ALWAYS;
    }

    public static <T> NPredicate<T> isNull() {
        return NULL;
    }

    public static <T> NPredicate<T> nonNull() {
        return NULL.negate();
    }

    private static String withPars(String sl) {
        if (!sl.matches("\\w")) {
            return "(" + sl + ")";
        }
        return sl;
    }

    public static class Never<T>
    extends BaseOpPredicate<T> {
        @Override
        public boolean test(T t) {
            return false;
        }

        public int hashCode() {
            return this.getClass().getName().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Never;
        }

        public String toString() {
            return "never";
        }
    }

    private static class Blank<T>
    extends BaseOpPredicate<T>
    implements Serializable {
        private Blank() {
        }

        @Override
        public boolean test(T t) {
            if (t == null) {
                return true;
            }
            if (t instanceof CharSequence) {
                return t.toString().trim().isEmpty();
            }
            if (t instanceof NBlankable) {
                return ((NBlankable)t).isBlank();
            }
            if (t instanceof char[]) {
                return NBlankable.isBlank((char[])t);
            }
            return false;
        }

        public int hashCode() {
            return this.getClass().getName().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Blank;
        }

        public String toString() {
            return "blank";
        }
    }

    private static class Always<T>
    extends BaseOpPredicate<T> {
        private Always() {
        }

        @Override
        public boolean test(T t) {
            return true;
        }

        public int hashCode() {
            return this.getClass().getName().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Always;
        }

        public String toString() {
            return "always";
        }
    }

    private static class Null<T>
    extends BaseOpPredicate<T>
    implements Serializable {
        private Null() {
        }

        @Override
        public boolean test(T t) {
            return t == null;
        }

        public int hashCode() {
            return this.getClass().getName().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Null;
        }

        public String toString() {
            return "isNull";
        }
    }

    public static class And<T>
    extends BaseOpPredicate<T> {
        private final Predicate<T> left;
        private final Predicate<? super T> right;

        public And(Predicate<T> left, Predicate<? super T> right) {
            NAssert.requireNonNull(left, "left");
            NAssert.requireNonNull(right, "right");
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean test(T t) {
            if (!this.left.test(t)) {
                return false;
            }
            return this.right.test(t);
        }

        public int hashCode() {
            return Objects.hash(this.left, this.right);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            And and = (And)o;
            return Objects.equals(this.left, and.left) && Objects.equals(this.right, and.right);
        }

        public String toString() {
            return NPredicates.withPars(this.left.toString()) + " & " + NPredicates.withPars(this.right.toString());
        }
    }

    public static class Or<T>
    extends BaseOpPredicate<T> {
        private final Predicate<T> left;
        private final Predicate<? super T> right;

        public Or(Predicate<T> left, Predicate<? super T> right) {
            NAssert.requireNonNull(left, "left");
            NAssert.requireNonNull(right, "right");
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean test(T t) {
            if (this.left.test(t)) {
                return true;
            }
            return this.right.test(t);
        }

        public int hashCode() {
            return Objects.hash(this.left, this.right);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Or or = (Or)o;
            return Objects.equals(this.left, or.left) && Objects.equals(this.right, or.right);
        }

        public String toString() {
            return NPredicates.withPars(this.left.toString()) + " | " + NPredicates.withPars(this.right.toString());
        }
    }

    public static class Not<T>
    extends BaseOpPredicate<T>
    implements Serializable {
        private final Predicate<T> base;

        public Not(Predicate<T> base) {
            NAssert.requireNonNull(base, "base");
            this.base = base;
        }

        @Override
        public boolean test(T t) {
            return !this.base.test(t);
        }

        public int hashCode() {
            return Objects.hash(this.base);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Not not = (Not)o;
            return this.base.equals(not.base);
        }

        public String toString() {
            return "!" + NPredicates.withPars(this.base.toString());
        }
    }

    public static abstract class BaseOpPredicate<T>
    extends AbstractNPredicate<T> {
    }
}

