/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NException;
import net.thevpc.nuts.util.NExceptions;

public class NParseEnumException
extends NException {
    private final String invalidValue;
    private final Class<?> enumType;

    public NParseEnumException(String invalidValue, Class<?> enumType) {
        this(null, invalidValue, enumType);
    }

    public NParseEnumException(NMsg message, String invalidValue, Class<?> enumType) {
        super(message == null ? NMsg.ofC("invalid value %s of type %s", invalidValue, enumType.getName()) : message);
        if (enumType == null || !Enum.class.isAssignableFrom(enumType) && !NEnum.class.isAssignableFrom(enumType)) {
            throw NExceptions.ofSafeIllegalArgumentException(NMsg.ofC("failed creating NutsParseEnumException for %s", enumType == null ? null : enumType.getName()));
        }
        this.enumType = enumType;
        this.invalidValue = invalidValue;
    }

    public String getInvalidValue() {
        return this.invalidValue;
    }

    public Class getEnumType() {
        return this.enumType;
    }
}

