/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.thevpc.nuts.concurrent.NCallable;
import net.thevpc.nuts.elem.NElementDescribable;
import net.thevpc.nuts.internal.optional.NReservedOptionalEmpty;
import net.thevpc.nuts.internal.optional.NReservedOptionalError;
import net.thevpc.nuts.internal.optional.NReservedOptionalValidCallable;
import net.thevpc.nuts.internal.optional.NReservedOptionalValidValue;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NExceptions;
import net.thevpc.nuts.util.NMessagedPredicate;
import net.thevpc.nuts.util.NOptionalType;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringUtils;

public interface NOptional<T>
extends NBlankable,
NElementDescribable {
    public static ExceptionFactory getDefaultExceptionFactory() {
        return NExceptions.getDefaultExceptionFactory();
    }

    public static void setDefaultExceptionFactory(ExceptionFactory defaultExceptionFactory) {
        NExceptions.setDefaultExceptionFactory(defaultExceptionFactory);
    }

    public static <T> NOptional<T> ofNamedEmpty(String name) {
        return NOptional.ofEmpty(() -> NMsg.ofC("missing %s", NStringUtils.firstNonBlank(name, "value")));
    }

    public static <T> NOptional<T> ofNamedEmpty(NMsg message) {
        return NOptional.ofEmpty(NMsg.ofC("missing %s", message == null ? "value" : message));
    }

    public static <T> NOptional<T> ofNamedError(NMsg message) {
        return NOptional.ofError(message == null ? () -> NMsg.ofC("error evaluating %s", "value") : () -> message);
    }

    public static <T> NOptional<T> ofNamedError(NMsg message, Throwable throwable) {
        return NOptional.ofError(message == null ? () -> NMsg.ofC("error evaluating %s", "value") : () -> message, throwable);
    }

    public static <T> NOptional<T> ofNamedError(String name) {
        return NOptional.ofError(() -> NMsg.ofC("error evaluating %s", NStringUtils.firstNonBlank(name, "value")));
    }

    public static <T> NOptional<T> ofNamedError(String name, Throwable throwable) {
        return NOptional.ofError(() -> NMsg.ofC("error evaluating %s", name), throwable);
    }

    public static <T> NOptional<T> ofEmpty() {
        return NOptional.ofEmpty((Supplier<NMsg>)null);
    }

    public static <T> NOptional<T> ofEmpty(Supplier<NMsg> emptyMessage) {
        return new NReservedOptionalEmpty(emptyMessage);
    }

    public static <T> NOptional<T> ofEmpty(NMsg emptyMessage) {
        return new NReservedOptionalEmpty(() -> emptyMessage);
    }

    public static <T> NOptional<T> ofError(Supplier<NMsg> errorMessage) {
        return NOptional.ofError(errorMessage, null);
    }

    public static <T> NOptional<T> ofError(NMsg errorMessage) {
        return NOptional.ofError(errorMessage == null ? null : () -> errorMessage, null);
    }

    public static <T> NOptional<T> ofError(NMsg errorMessage, Throwable throwable) {
        return NOptional.ofError(errorMessage == null ? null : () -> errorMessage, throwable);
    }

    public static <T> NOptional<T> ofError(Supplier<NMsg> errorMessage, Throwable throwable) {
        return new NReservedOptionalError(errorMessage, throwable);
    }

    public static <T> NOptional<T> ofError(Throwable throwable) {
        return new NReservedOptionalError(null, throwable);
    }

    public static <T> NOptional<T> of(T value) {
        return NOptional.of(value, (Supplier<NMsg>)null);
    }

    public static <T> NOptional<T> ofNullable(T value) {
        return new NReservedOptionalValidValue<T>(value);
    }

    public static <T> NOptional<T> ofCallable(NCallable<T> value) {
        NAssert.requireNonNull(value, "callable");
        return new NReservedOptionalValidCallable(() -> NOptional.of(value.call()));
    }

    public static <T> NOptional<T> ofSupplier(Supplier<T> value) {
        NAssert.requireNonNull(value, "supplier");
        return new NReservedOptionalValidCallable(() -> NOptional.of(value.get()));
    }

    public static <T> NOptional<T> ofNamed(T value, String name) {
        return NOptional.of(value, () -> NMsg.ofC("missing %s", NStringUtils.firstNonBlank(name, "value")));
    }

    public static <T> NOptional<T> ofNamed(T value, NMsg name) {
        return NOptional.of(value, () -> NMsg.ofC("missing %s", name == null ? "value" : name));
    }

    public static <T> NOptional<T> of(T value, Supplier<NMsg> emptyMessage) {
        if (value == null) {
            return NOptional.ofEmpty(emptyMessage);
        }
        return NOptional.ofNullable(value);
    }

    public static <T> NOptional<T> of(T value, NMsg emptyMessage) {
        if (value == null) {
            return NOptional.ofEmpty(emptyMessage);
        }
        return NOptional.ofNullable(value);
    }

    public static <T> NOptional<T> ofNull() {
        return NOptional.ofNullable(null);
    }

    public static <T> NOptional<T> ofNamedOptional(Optional<T> optional, String name) {
        return NOptional.ofOptional(optional, () -> NMsg.ofC("missing %s", NStringUtils.firstNonBlank(name, "value")));
    }

    public static <T> NOptional<T> ofOptional(Optional<T> optional, NMsg errorMessage) {
        return NOptional.ofOptional(optional, () -> errorMessage);
    }

    public static <T> NOptional<T> ofOptional(Optional<T> optional, Supplier<NMsg> errorMessage) {
        if (optional.isPresent()) {
            return NOptional.of(optional.get());
        }
        return NOptional.ofEmpty(errorMessage);
    }

    public static <T> NOptional<T> ofSingleton(Collection<T> collection) {
        return NOptional.ofSingleton(collection, null, null);
    }

    public static <T> NOptional<T> ofNamedSingleton(Collection<T> collection, String name) {
        if (name == null) {
            return NOptional.ofSingleton(collection, null, null);
        }
        return NOptional.ofSingleton(collection, () -> NMsg.ofC("missing %s", NStringUtils.firstNonBlank(name, "value")), () -> NMsg.ofC("too many elements %s>1 for %s", collection == null ? 0 : collection.size(), NStringUtils.firstNonBlank(name, "value")));
    }

    public static <T> NOptional<T> ofSingleton(Collection<T> collection, Supplier<NMsg> emptyMessage, Supplier<NMsg> errorMessage) {
        if (collection == null || collection.isEmpty()) {
            return NOptional.ofEmpty(emptyMessage);
        }
        if (collection.size() > 1) {
            if (errorMessage == null) {
                errorMessage = () -> NMsg.ofC("too many elements %s>1", collection.size());
            }
            return NOptional.ofError(errorMessage);
        }
        Iterator<T> iterator = collection.iterator();
        if (iterator.hasNext()) {
            T t = iterator.next();
            return NOptional.of(t);
        }
        return NOptional.ofEmpty(errorMessage);
    }

    public static <T> NOptional<T> ofNamedFirst(Collection<T> collection, String name) {
        return NOptional.ofFirst(collection, () -> NMsg.ofC("missing %s", NStringUtils.firstNonBlank(name, "value")));
    }

    public static <T> NOptional<T> ofFirst(Collection<T> collection) {
        return NOptional.ofFirst(collection, null);
    }

    public static <T> NOptional<T> ofFirst(Collection<T> collection, Supplier<NMsg> emptyMessage) {
        if (emptyMessage == null) {
            emptyMessage = () -> NMsg.ofPlain("missing element");
        }
        if (collection == null || collection.isEmpty()) {
            return NOptional.ofEmpty(emptyMessage);
        }
        Iterator<T> iterator = collection.iterator();
        if (iterator.hasNext()) {
            T t = iterator.next();
            return NOptional.of(t);
        }
        return NOptional.ofEmpty(emptyMessage);
    }

    default public NOptional<T> failFast() {
        if (this.isError()) {
            this.get();
        }
        return this;
    }

    public <V> NOptional<V> flatMap(Function<T, NOptional<V>> var1);

    public NOptional<T> withDefault(Supplier<T> var1);

    public NOptional<T> withDefaultOptional(Supplier<NOptional<T>> var1);

    public NOptional<T> withDefault(T var1);

    public NOptional<T> withoutDefault();

    public <V> NOptional<V> mapIfPresent(Function<T, V> var1);

    public <V> NOptional<V> mapIfNotBlank(Function<T, V> var1);

    public <V> NOptional<V> mapIfNotEmpty(Function<T, V> var1);

    public <V> NOptional<V> mapIfNotNull(Function<T, V> var1);

    public <V> NOptional<V> mapIf(Predicate<T> var1, Function<T, V> var2, Function<T, V> var3);

    public NOptional<T> mapIf(Predicate<T> var1, Function<T, T> var2);

    public NOptional<T> mapIfNotDefault(Function<T, T> var1);

    public NOptional<T> mapIfDefault(Function<T, T> var1);

    public <V> NOptional<V> mapIfNotError(Function<T, V> var1);

    public <V> NOptional<V> map(Function<T, V> var1);

    public <V> NOptional<V> instanceOf(Class<V> var1);

    public <V> NOptional<V> then(Function<T, V> var1);

    public <V> NOptional<V> thenOptional(Function<T, NOptional<V>> var1);

    public NOptional<T> filter(NMessagedPredicate<T> var1);

    public NOptional<T> filter(Predicate<T> var1);

    public NOptional<T> filter(Predicate<T> var1, Supplier<NMsg> var2);

    public NOptional<T> ifPresent(Consumer<T> var1);

    public T orElse(T var1);

    public T orElseGet(Supplier<? extends T> var1);

    public NOptional<T> orElseOf(Supplier<T> var1);

    public NOptional<T> orElseOfNullable(Supplier<T> var1);

    public T ifEmptyGet(Supplier<? extends T> var1);

    public NOptional<T> ifEmptyOf(Supplier<T> var1);

    public NOptional<T> ifEmptyOfNullable(Supplier<T> var1);

    public NOptional<T> orElseUse(Supplier<NOptional<T>> var1);

    public <R extends Throwable> T orElseThrow(Supplier<? extends R> var1) throws R;

    public NOptional<T> ifEmpty(T var1);

    public NOptional<T> ifEmptyUse(Supplier<NOptional<T>> var1);

    public T get();

    public T get(Supplier<NMsg> var1);

    public Throwable getError();

    public ExceptionFactory getExceptionFactory();

    public T orNull();

    public T orDefault();

    public NOptional<T> orDefaultOptional();

    public NOptional<T> ifEmptyNull();

    public NOptional<T> ifBlank(T var1);

    public NOptional<T> ifBlankEmpty(Supplier<NMsg> var1);

    public NOptional<T> ifBlankEmpty();

    public NOptional<T> ifErrorNull();

    public NOptional<T> ifError(T var1);

    public NOptional<T> ifBlankUse(Supplier<NOptional<T>> var1);

    public NOptional<T> ifNullUse(Supplier<NOptional<T>> var1);

    public NOptional<T> ifNullEmpty();

    public NOptional<T> ifErrorUse(Supplier<NOptional<T>> var1);

    public boolean isEmpty();

    public boolean isNull();

    public boolean isError();

    public boolean isPresent();

    public boolean isNotPresent();

    public NOptionalType getType();

    public Supplier<NMsg> getMessage();

    public NOptional<T> withMessage(Supplier<NMsg> var1);

    public NOptional<T> withMessage(NMsg var1);

    public NOptional<T> withName(NMsg var1);

    public NOptional<T> withName(String var1);

    public NOptional<T> withExceptionFactory(ExceptionFactory var1);

    public Optional<T> asOptional();

    public NStream<T> stream();

    public static interface ExceptionFactory {
        public RuntimeException createOptionalEmptyException(NMsg var1);

        public RuntimeException createOptionalErrorException(NMsg var1, Throwable var2);

        public RuntimeException createAssertException(NMsg var1, Throwable var2);

        public RuntimeException createCmdLineException(NMsg var1, Throwable var2);
    }
}

