/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NColor;
import net.thevpc.nuts.util.NNameFormat;

public class NNames {
    public static List<String> ADJECTIVES = Collections.unmodifiableList(new ArrayList<String>(NNames.loadNames("net/thevpc/nuts/adjectives.txt")));
    public static List<String> NAMES = Collections.unmodifiableList(new ArrayList<String>(NNames.loadNames("net/thevpc/nuts/names.txt")));
    private static Map<Integer, List<String[]>> CACHED_COLOR_NAMES_BY_EQ_SIZE = new HashMap<Integer, List<String[]>>();
    private static Map<Integer, List<String[]>> CACHED_COLOR_NAMES_BY_LTE_SIZE = new HashMap<Integer, List<String[]>>();

    private static Set<String> loadNames(String ... resources) {
        TreeSet<String> all = new TreeSet<String>();
        for (String resource : resources) {
            Enumeration<URL> found = null;
            try {
                found = NNames.class.getClassLoader().getResources(resource);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            while (found.hasMoreElements()) {
                URL u = found.nextElement();
                try {
                    InputStream is = u.openStream();
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                            for (String s : line.split("[, ;]+")) {
                                String ts = s.trim();
                                if (ts.isEmpty()) continue;
                                all.add(ts.toLowerCase());
                            }
                        }
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return all;
    }

    public static String pickName(int hash, int minCount, int maxCount, NNameFormat format) {
        String[] selected;
        String word;
        int i;
        int range;
        int wordsCount;
        if (format == null) {
            format = NNameFormat.TITLE_NAME;
        }
        if (minCount <= 0) {
            minCount = 1;
        }
        if (maxCount <= minCount) {
            maxCount = minCount;
        }
        NAssert.requireTrue((wordsCount = NNames.ihash(hash, range = Math.max(1, maxCount - minCount + 1)) + minCount) > 0, () -> NMsg.ofC("size must be > 0"));
        if (wordsCount == 1) {
            int usecase = NNames.ihash(hash, 2);
            switch (usecase) {
                case 0: {
                    return format.format(NNames.lhash(hash, NAMES));
                }
                case 1: {
                    List<String[]> parts = NNames.colorNames(1);
                    String[] selected2 = parts.get(NNames.ihash(hash, parts.size()));
                    return format.format(selected2);
                }
            }
            throw new IllegalArgumentException("should never happen");
        }
        if (wordsCount == 2) {
            int usecase = NNames.ihash(hash, 3);
            switch (usecase) {
                case 0: {
                    String[] aa = new String[]{NNames.lhash(hash, ADJECTIVES), NNames.lhash(hash, NAMES)};
                    return format.format(aa);
                }
                case 1: {
                    List<String[]> parts = NNames.colorNames(1);
                    String[] selected3 = parts.get(NNames.ihash(hash, parts.size()));
                    return format.format(new String[]{NNames.lhash(hash, ADJECTIVES), selected3[0]});
                }
                case 2: {
                    List<String[]> parts = NNames.colorNames(2);
                    String[] selected4 = parts.get(NNames.ihash(hash, parts.size()));
                    return format.format(selected4);
                }
            }
            throw new IllegalArgumentException("should never happen");
        }
        if (wordsCount == 3) {
            int usecase = NNames.ihash(hash, 3);
            switch (usecase) {
                case 0: {
                    ArrayList<String> aa = new ArrayList<String>();
                    aa.add(NNames.lhash(hash, ADJECTIVES));
                    List<String[]> parts = NNames.colorNames(1);
                    String[] selected5 = parts.get(NNames.ihash(hash, parts.size()));
                    aa.add(selected5[0]);
                    aa.add(NNames.lhash(hash, NAMES));
                    return format.format(aa.toArray(new String[0]));
                }
                case 1: {
                    ArrayList<String> aa = new ArrayList<String>();
                    aa.add(NNames.lhash(hash, ADJECTIVES));
                    List<String[]> parts = NNames.colorNames(2);
                    String[] selected6 = parts.get(NNames.ihash(hash, parts.size()));
                    aa.addAll(Arrays.asList(selected6));
                    return format.format(aa.toArray(new String[0]));
                }
                case 2: {
                    ArrayList<String> aa = new ArrayList<String>();
                    List<String[]> parts = NNames.colorNames(3);
                    String[] selected7 = parts.get(NNames.ihash(hash, parts.size()));
                    aa.addAll(Arrays.asList(selected7));
                    return format.format(aa.toArray(new String[0]));
                }
            }
            throw new IllegalArgumentException("should never happen");
        }
        List<int[]> triples = NNames.findTriples(wordsCount);
        int[] useCase = triples.get(NNames.ihash(hash, triples.size()));
        int adjectives = useCase[0];
        int colors = useCase[1];
        int names = useCase[2];
        ArrayList<String> aa = new ArrayList<String>();
        int h = hash;
        for (i = 0; i < adjectives; ++i) {
            word = NNames.lhash(h, ADJECTIVES);
            h = Integer.rotateLeft(h, 5) ^ word.hashCode();
            aa.add(word);
        }
        h = hash;
        for (int remains = colors; remains > 0; remains -= selected.length) {
            List<String[]> parts = NNames.colorNamesLte(Math.min(3, remains));
            selected = parts.get(NNames.ihash(h, parts.size()));
            aa.addAll(Arrays.asList(selected));
            for (int i2 = 0; i2 < selected.length; ++i2) {
                h = Integer.rotateLeft(h, 5) ^ selected[i2].hashCode();
            }
        }
        h = hash;
        for (i = 0; i < names; ++i) {
            word = NNames.lhash(h, NAMES);
            h = Integer.rotateLeft(h, 5) ^ word.hashCode();
            aa.add(word);
        }
        return format.format(aa.toArray(new String[0]));
    }

    private static List<int[]> findTriples(int n) {
        int b;
        if (n <= 3) {
            throw new IllegalArgumentException("n must be > 3");
        }
        ArrayList<int[]> result = new ArrayList<int[]>();
        int a = 0;
        while (a <= n) {
            b = n - a;
            result.add(new int[]{a++, b, 0});
        }
        a = 0;
        while (a <= n - 1) {
            b = n - 1 - a;
            result.add(new int[]{a++, b, 1});
        }
        return result;
    }

    private static int ihash(int hash, int count) {
        return Math.abs(hash) % count;
    }

    private static String lhash(int hash, List<String> list) {
        return list.get(NNames.ihash(hash, list.size()));
    }

    private static List<String[]> colorNames(int size) {
        return CACHED_COLOR_NAMES_BY_EQ_SIZE.computeIfAbsent(size, currentSize -> NColor.ALL_CANONICAL.stream().map(x -> {
            String[] a = NNameFormat.parse(x.getName());
            if (a.length == currentSize) {
                return a;
            }
            return null;
        }).filter(x -> x != null).collect(Collectors.toList()));
    }

    private static List<String[]> colorNamesLte(int size) {
        return CACHED_COLOR_NAMES_BY_LTE_SIZE.computeIfAbsent(size, currentSize -> NColor.ALL_CANONICAL.stream().map(x -> {
            String[] a = NNameFormat.parse(x.getName());
            if (a.length <= currentSize) {
                return a;
            }
            return null;
        }).filter(x -> x != null).collect(Collectors.toList()));
    }
}

