/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.io.Serializable;
import java.io.StringReader;
import java.util.Arrays;
import net.thevpc.nuts.elem.NMapBy;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NImmutable;
import net.thevpc.nuts.util.NMemorySizeFormat;
import net.thevpc.nuts.util.NMemoryUnit;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStreamTokenizer;
import net.thevpc.nuts.util.NStringUtils;

public class NMemorySize
implements Serializable,
NImmutable {
    private final long[] values = new long[NMemoryUnit.values().length];
    private final NMemoryUnit smallestUnit;
    private final NMemoryUnit largestUnit;
    private final long bytes;
    private final int bits;
    private final long KB;
    private final boolean iec;

    @NMapBy
    public NMemorySize(@NMapBy(name="bits") long bits, @NMapBy(name="bytes") long bytes, @NMapBy(name="kiloBytes") long kiloBytes, @NMapBy(name="megaBytes") long megaBytes, @NMapBy(name="teraBytes") long teraBytes, @NMapBy(name="petaBytes") long petaBytes, @NMapBy(name="zetaBytes") long zetaBytes, @NMapBy(name="smallestUnit") NMemoryUnit smallestUnit, @NMapBy(name="largestUnit") NMemoryUnit largestUnit, @NMapBy(name="iec") boolean iec) {
        this.iec = iec;
        this.KB = iec ? 1000L : 1024L;
        this.values[NMemoryUnit.BIT.ordinal()] = bits;
        this.values[NMemoryUnit.BYTE.ordinal()] = bytes;
        this.values[NMemoryUnit.KILO_BYTE.ordinal()] = kiloBytes;
        this.values[NMemoryUnit.MEGA_BYTE.ordinal()] = megaBytes;
        this.values[NMemoryUnit.TERA_BYTE.ordinal()] = teraBytes;
        this.values[NMemoryUnit.PETA_BYTE.ordinal()] = petaBytes;
        this.values[NMemoryUnit.ZETA_BYTE.ordinal()] = zetaBytes;
        this.bytes = this.rebuildSizeBytes();
        this.bits = this.rebuildSizeBits();
        this.smallestUnit = smallestUnit == null ? this.detectSmallestUnit() : smallestUnit;
        NMemoryUnit nMemoryUnit = largestUnit = largestUnit == null ? this.detectLargestUnit() : largestUnit;
        if (largestUnit.ordinal() < this.smallestUnit.ordinal()) {
            largestUnit = this.smallestUnit;
        }
        this.largestUnit = largestUnit;
        this.applyUnits();
        this.checkMe();
    }

    public NMemorySize(long memBytes, int memBits, boolean iec) {
        this.iec = iec;
        this.KB = iec ? 1000L : 1024L;
        memBytes += (long)(memBits / 8);
        this.bytes = memBytes;
        this.bits = memBits %= 8;
        this.values[NMemoryUnit.ZETA_BYTE.ordinal()] = memBytes / (this.KB * this.KB * this.KB * this.KB * this.KB * this.KB);
        this.values[NMemoryUnit.PETA_BYTE.ordinal()] = (memBytes %= this.KB * this.KB * this.KB * this.KB * this.KB * this.KB) / (this.KB * this.KB * this.KB * this.KB * this.KB);
        this.values[NMemoryUnit.TERA_BYTE.ordinal()] = (memBytes %= this.KB * this.KB * this.KB * this.KB * this.KB) / (this.KB * this.KB * this.KB * this.KB);
        this.values[NMemoryUnit.GIGA_BYTE.ordinal()] = (memBytes %= this.KB * this.KB * this.KB * this.KB) / (this.KB * this.KB * this.KB);
        this.values[NMemoryUnit.MEGA_BYTE.ordinal()] = (memBytes %= this.KB * this.KB * this.KB) / (this.KB * this.KB);
        this.values[NMemoryUnit.KILO_BYTE.ordinal()] = (memBytes %= this.KB * this.KB) / this.KB;
        this.values[NMemoryUnit.BYTE.ordinal()] = memBytes %= this.KB;
        this.smallestUnit = this.detectSmallestUnit();
        this.largestUnit = this.detectLargestUnit();
        this.checkMe();
    }

    public NMemorySize(long memBytes, int memBits, NMemoryUnit smallestUnit, NMemoryUnit largestUnit, boolean iec) {
        this.iec = iec;
        this.KB = iec ? 1000L : 1024L;
        memBytes += (long)(memBits / 8);
        this.bytes = memBytes;
        this.bits = memBits %= 8;
        if (smallestUnit != null && largestUnit != null) {
            this.smallestUnit = smallestUnit;
            if (largestUnit.ordinal() < this.smallestUnit.ordinal()) {
                largestUnit = this.smallestUnit;
            }
            this.largestUnit = largestUnit;
            int largestUnitOrdinal = this.largestUnit.ordinal();
            int smallestUnitOrdinal = this.smallestUnit.ordinal();
            if (smallestUnitOrdinal <= NMemoryUnit.BIT.ordinal()) {
                if (largestUnitOrdinal > NMemoryUnit.BIT.ordinal()) {
                    this.values[NMemoryUnit.BIT.ordinal()] = memBits;
                } else {
                    this.values[NMemoryUnit.BIT.ordinal()] = (long)memBits + memBytes * 8L;
                    return;
                }
            }
            if (smallestUnitOrdinal <= NMemoryUnit.BYTE.ordinal()) {
                if (largestUnitOrdinal > NMemoryUnit.BYTE.ordinal()) {
                    this.values[NMemoryUnit.BYTE.ordinal()] = memBytes % this.KB;
                } else {
                    this.values[NMemoryUnit.BYTE.ordinal()] = memBytes;
                    return;
                }
            }
            if (smallestUnitOrdinal <= NMemoryUnit.KILO_BYTE.ordinal()) {
                if (largestUnitOrdinal > NMemoryUnit.KILO_BYTE.ordinal()) {
                    this.values[NMemoryUnit.KILO_BYTE.ordinal()] = (int)(memBytes / this.KB % this.KB);
                } else {
                    this.values[NMemoryUnit.KILO_BYTE.ordinal()] = memBytes / this.KB;
                    return;
                }
            }
            if (smallestUnitOrdinal <= NMemoryUnit.MEGA_BYTE.ordinal()) {
                if (largestUnitOrdinal > NMemoryUnit.MEGA_BYTE.ordinal()) {
                    this.values[NMemoryUnit.MEGA_BYTE.ordinal()] = (int)(memBytes / (this.KB * this.KB) % this.KB);
                } else {
                    this.values[NMemoryUnit.MEGA_BYTE.ordinal()] = memBytes / (this.KB * this.KB);
                    return;
                }
            }
            if (smallestUnitOrdinal <= NMemoryUnit.GIGA_BYTE.ordinal()) {
                if (largestUnitOrdinal > NMemoryUnit.GIGA_BYTE.ordinal()) {
                    this.values[NMemoryUnit.GIGA_BYTE.ordinal()] = (int)(memBytes / (this.KB * this.KB * this.KB) % this.KB);
                } else {
                    this.values[NMemoryUnit.GIGA_BYTE.ordinal()] = memBytes / (this.KB * this.KB * this.KB);
                    return;
                }
            }
            if (smallestUnitOrdinal <= NMemoryUnit.TERA_BYTE.ordinal()) {
                if (largestUnitOrdinal > NMemoryUnit.TERA_BYTE.ordinal()) {
                    this.values[NMemoryUnit.TERA_BYTE.ordinal()] = (int)(memBytes / (this.KB * this.KB * this.KB * this.KB) % this.KB);
                } else {
                    this.values[NMemoryUnit.TERA_BYTE.ordinal()] = memBytes / (this.KB * this.KB * this.KB * this.KB);
                    return;
                }
            }
            if (smallestUnitOrdinal <= NMemoryUnit.PETA_BYTE.ordinal()) {
                if (largestUnitOrdinal > NMemoryUnit.PETA_BYTE.ordinal()) {
                    this.values[NMemoryUnit.PETA_BYTE.ordinal()] = (int)(memBytes / (this.KB * this.KB * this.KB * this.KB * this.KB) % this.KB);
                } else {
                    this.values[NMemoryUnit.PETA_BYTE.ordinal()] = memBytes / (this.KB * this.KB * this.KB * this.KB * this.KB);
                    return;
                }
            }
            if (smallestUnitOrdinal <= NMemoryUnit.ZETA_BYTE.ordinal()) {
                this.values[NMemoryUnit.ZETA_BYTE.ordinal()] = memBytes / (this.KB * this.KB * this.KB * this.KB * this.KB * this.KB);
            }
        } else {
            this.values[NMemoryUnit.ZETA_BYTE.ordinal()] = memBytes / (this.KB * this.KB * this.KB * this.KB * this.KB * this.KB);
            this.values[NMemoryUnit.PETA_BYTE.ordinal()] = (memBytes %= this.KB * this.KB * this.KB * this.KB * this.KB * this.KB) / (this.KB * this.KB * this.KB * this.KB * this.KB);
            this.values[NMemoryUnit.TERA_BYTE.ordinal()] = (memBytes %= this.KB * this.KB * this.KB * this.KB * this.KB) / (this.KB * this.KB * this.KB * this.KB);
            this.values[NMemoryUnit.GIGA_BYTE.ordinal()] = (memBytes %= this.KB * this.KB * this.KB * this.KB) / (this.KB * this.KB * this.KB);
            this.values[NMemoryUnit.MEGA_BYTE.ordinal()] = (memBytes %= this.KB * this.KB * this.KB) / (this.KB * this.KB);
            this.values[NMemoryUnit.KILO_BYTE.ordinal()] = (memBytes %= this.KB * this.KB) / this.KB;
            this.values[NMemoryUnit.BYTE.ordinal()] = memBytes %= this.KB;
            this.smallestUnit = smallestUnit == null ? this.detectSmallestUnit() : smallestUnit;
            NMemoryUnit nMemoryUnit = largestUnit = largestUnit == null ? this.detectLargestUnit() : largestUnit;
            if (largestUnit.ordinal() < this.smallestUnit.ordinal()) {
                largestUnit = this.smallestUnit;
            }
            this.largestUnit = largestUnit;
            this.applyUnits();
        }
        this.checkMe();
    }

    public NMemorySize(long[] values, NMemoryUnit smallestUnit, NMemoryUnit largestUnit, boolean iec) {
        this.iec = iec;
        this.KB = iec ? 1000L : 1024L;
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = values[i];
        }
        this.smallestUnit = smallestUnit == null ? this.detectSmallestUnit() : smallestUnit;
        NMemoryUnit nMemoryUnit = largestUnit = largestUnit == null ? this.detectLargestUnit() : largestUnit;
        if (largestUnit.ordinal() < this.smallestUnit.ordinal()) {
            largestUnit = this.smallestUnit;
        }
        this.largestUnit = largestUnit;
        this.applyUnits();
        this.bytes = this.rebuildSizeBytes();
        this.bits = this.rebuildSizeBits();
    }

    private void checkMe() {
    }

    private int rebuildSizeBits() {
        return (int)(this.values[NMemoryUnit.BIT.ordinal()] % 8L);
    }

    private long rebuildSizeBytes() {
        return this.values[NMemoryUnit.BYTE.ordinal()] + this.values[NMemoryUnit.KILO_BYTE.ordinal()] * this.KB + this.values[NMemoryUnit.MEGA_BYTE.ordinal()] * this.KB * this.KB + this.values[NMemoryUnit.GIGA_BYTE.ordinal()] * this.KB * this.KB * this.KB + this.values[NMemoryUnit.TERA_BYTE.ordinal()] * this.KB * this.KB * this.KB * this.KB + this.values[NMemoryUnit.PETA_BYTE.ordinal()] * this.KB * this.KB * this.KB * this.KB * this.KB + this.values[NMemoryUnit.ZETA_BYTE.ordinal()] * this.KB * this.KB * this.KB * this.KB * this.KB * this.KB;
    }

    private void applyUnits() {
        int uo = this.smallestUnit.ordinal();
        for (int i = 0; i < uo; ++i) {
            this.values[i] = 0L;
        }
        switch (this.largestUnit) {
            case ZETA_BYTE: {
                break;
            }
            case PETA_BYTE: {
                this.add(NMemoryUnit.PETA_BYTE, this.KB * this.get(NMemoryUnit.ZETA_BYTE));
                this.set(NMemoryUnit.ZETA_BYTE, 0L);
                break;
            }
            case TERA_BYTE: {
                this.add(NMemoryUnit.TERA_BYTE, this.KB * this.get(NMemoryUnit.PETA_BYTE) + this.KB * this.KB * this.get(NMemoryUnit.ZETA_BYTE));
                this.set(NMemoryUnit.PETA_BYTE, 0L);
                this.set(NMemoryUnit.ZETA_BYTE, 0L);
                break;
            }
            case GIGA_BYTE: {
                this.add(NMemoryUnit.TERA_BYTE, this.KB * this.get(NMemoryUnit.TERA_BYTE) + this.KB * this.KB * this.get(NMemoryUnit.PETA_BYTE) + this.KB * this.KB * this.KB * this.get(NMemoryUnit.ZETA_BYTE));
                this.set(NMemoryUnit.TERA_BYTE, 0L);
                this.set(NMemoryUnit.PETA_BYTE, 0L);
                this.set(NMemoryUnit.ZETA_BYTE, 0L);
                break;
            }
            case MEGA_BYTE: {
                this.add(NMemoryUnit.MEGA_BYTE, this.KB * this.get(NMemoryUnit.GIGA_BYTE) + this.KB * this.KB * this.get(NMemoryUnit.TERA_BYTE) + this.KB * this.KB * this.KB * this.get(NMemoryUnit.PETA_BYTE) + this.KB * this.KB * this.KB * this.KB * this.get(NMemoryUnit.ZETA_BYTE));
                this.set(NMemoryUnit.GIGA_BYTE, 0L);
                this.set(NMemoryUnit.TERA_BYTE, 0L);
                this.set(NMemoryUnit.ZETA_BYTE, 0L);
                this.set(NMemoryUnit.PETA_BYTE, 0L);
                break;
            }
            case KILO_BYTE: {
                this.add(NMemoryUnit.KILO_BYTE, this.KB * this.get(NMemoryUnit.MEGA_BYTE) + this.KB * this.KB * this.get(NMemoryUnit.GIGA_BYTE) + this.KB * this.KB * this.KB * this.get(NMemoryUnit.TERA_BYTE) + this.KB * this.KB * this.KB * this.KB * this.get(NMemoryUnit.PETA_BYTE) + this.KB * this.KB * this.KB * this.KB * this.KB * this.get(NMemoryUnit.ZETA_BYTE));
                this.set(NMemoryUnit.MEGA_BYTE, 0L);
                this.set(NMemoryUnit.GIGA_BYTE, 0L);
                this.set(NMemoryUnit.TERA_BYTE, 0L);
                this.set(NMemoryUnit.ZETA_BYTE, 0L);
                this.set(NMemoryUnit.PETA_BYTE, 0L);
                break;
            }
            case BYTE: {
                this.add(NMemoryUnit.BYTE, this.KB * this.get(NMemoryUnit.KILO_BYTE) + this.KB * this.KB * this.get(NMemoryUnit.MEGA_BYTE) + this.KB * this.KB * this.KB * this.get(NMemoryUnit.GIGA_BYTE) + this.KB * this.KB * this.KB * this.KB * this.get(NMemoryUnit.TERA_BYTE) + this.KB * this.KB * this.KB * this.KB * this.KB * this.get(NMemoryUnit.PETA_BYTE) + this.KB * this.KB * this.KB * this.KB * this.KB * this.KB * this.get(NMemoryUnit.ZETA_BYTE));
                this.set(NMemoryUnit.KILO_BYTE, 0L);
                this.set(NMemoryUnit.MEGA_BYTE, 0L);
                this.set(NMemoryUnit.GIGA_BYTE, 0L);
                this.set(NMemoryUnit.TERA_BYTE, 0L);
                this.set(NMemoryUnit.ZETA_BYTE, 0L);
                this.set(NMemoryUnit.PETA_BYTE, 0L);
                break;
            }
            case BIT: {
                this.add(NMemoryUnit.BIT, 8L * this.get(NMemoryUnit.BYTE) + 8L * this.KB * this.get(NMemoryUnit.KILO_BYTE) + 8L * this.KB * this.KB * this.get(NMemoryUnit.MEGA_BYTE) + 8L * this.KB * this.KB * this.KB * this.get(NMemoryUnit.GIGA_BYTE) + 8L * this.KB * this.KB * this.KB * this.KB * this.get(NMemoryUnit.TERA_BYTE) + 8L * this.KB * this.KB * this.KB * this.KB * this.KB * this.get(NMemoryUnit.PETA_BYTE) + 8L * this.KB * this.KB * this.KB * this.KB * this.KB * this.KB * this.get(NMemoryUnit.ZETA_BYTE));
                this.set(NMemoryUnit.BYTE, 0L);
                this.set(NMemoryUnit.KILO_BYTE, 0L);
                this.set(NMemoryUnit.MEGA_BYTE, 0L);
                this.set(NMemoryUnit.GIGA_BYTE, 0L);
                this.set(NMemoryUnit.TERA_BYTE, 0L);
                this.set(NMemoryUnit.ZETA_BYTE, 0L);
                this.set(NMemoryUnit.PETA_BYTE, 0L);
            }
        }
    }

    private boolean isZero0() {
        for (long value : this.values) {
            if (value == 0L) continue;
            return false;
        }
        return true;
    }

    private NMemoryUnit detectSmallestUnit() {
        if (this.isZero0()) {
            return NMemoryUnit.BIT;
        }
        for (int i = 0; i < this.values.length; ++i) {
            long value = this.values[i];
            if (value == 0L) continue;
            return NMemoryUnit.values()[i];
        }
        return NMemoryUnit.ZETA_BYTE;
    }

    private NMemoryUnit detectLargestUnit() {
        if (this.isZero0()) {
            return NMemoryUnit.BIT;
        }
        for (int i = this.values.length - 1; i >= 0; --i) {
            long value = this.values[i];
            if (value == 0L) continue;
            return NMemoryUnit.values()[i];
        }
        return NMemoryUnit.ZETA_BYTE;
    }

    public static NMemorySize ofBits(long bits, boolean iec) {
        long bytes = bits / 8L;
        int b = (int)(bits % 8L);
        return new NMemorySize(bytes, b, iec);
    }

    public static NMemorySize ofBits(long bits, NMemoryUnit smallestUnit, NMemoryUnit largestUnit) {
        return NMemorySize.ofBits(bits, smallestUnit, largestUnit, false);
    }

    public static NMemorySize ofBits(long bits, NMemoryUnit smallestUnit, NMemoryUnit largestUnit, boolean iec) {
        long bytes = bits / 8L;
        int b = (int)(bits % 8L);
        return new NMemorySize(bytes, b, smallestUnit, largestUnit, iec);
    }

    public static NMemorySize ofBitsOnly(long value) {
        return NMemorySize.ofBitsOnly(value, false);
    }

    public static NMemorySize ofBytesOnly(long value) {
        return NMemorySize.ofBytesOnly(value, false);
    }

    public static NMemorySize ofKiloBytesOnly(long value) {
        return NMemorySize.ofKiloBytesOnly(value, false);
    }

    public static NMemorySize ofMegaBytesOnly(long value) {
        return NMemorySize.ofMegaBytesOnly(value, false);
    }

    public static NMemorySize ofTeraBytesOnly(long value) {
        return NMemorySize.ofTeraBytesOnly(value, false);
    }

    public static NMemorySize ofPetaBytesOnly(long value) {
        return NMemorySize.ofPetaBytesOnly(value, false);
    }

    public static NMemorySize ofZetaBytesOnly(long value) {
        return NMemorySize.ofZetaBytesOnly(value, false);
    }

    public static NMemorySize ofBits(long value) {
        return NMemorySize.ofBits(value, false);
    }

    public static NMemorySize ofBytes(long value) {
        return NMemorySize.ofBytes(value, false);
    }

    public static NMemorySize ofKiloBytes(long value) {
        return NMemorySize.ofKiloBytes(value, false);
    }

    public static NMemorySize ofMegaBytes(long value) {
        return NMemorySize.ofMegaBytes(value, false);
    }

    public static NMemorySize ofTeraBytes(long value) {
        return NMemorySize.ofTeraBytes(value, false);
    }

    public static NMemorySize ofPetaBytes(long value) {
        return NMemorySize.ofPetaBytes(value, false);
    }

    public static NMemorySize ofZetaBytes(long value) {
        return NMemorySize.ofZetaBytes(value, false);
    }

    public static NMemorySize ofBitsOnly(long value, boolean iec) {
        return NMemorySize.ofUnitOnly(value, NMemoryUnit.BIT, iec);
    }

    public static NMemorySize ofBytesOnly(long value, boolean iec) {
        return NMemorySize.ofUnitOnly(value, NMemoryUnit.BYTE, iec);
    }

    public static NMemorySize ofKiloBytesOnly(long value, boolean iec) {
        return NMemorySize.ofUnitOnly(value, NMemoryUnit.KILO_BYTE, iec);
    }

    public static NMemorySize ofMegaBytesOnly(long value, boolean iec) {
        return NMemorySize.ofUnitOnly(value, NMemoryUnit.MEGA_BYTE, iec);
    }

    public static NMemorySize ofTeraBytesOnly(long value, boolean iec) {
        return NMemorySize.ofUnitOnly(value, NMemoryUnit.TERA_BYTE, iec);
    }

    public static NMemorySize ofPetaBytesOnly(long value, boolean iec) {
        return NMemorySize.ofUnitOnly(value, NMemoryUnit.PETA_BYTE, iec);
    }

    public static NMemorySize ofZetaBytesOnly(long value, boolean iec) {
        return NMemorySize.ofUnitOnly(value, NMemoryUnit.ZETA_BYTE, iec);
    }

    public static NMemorySize ofBytes(long value, boolean iec) {
        return NMemorySize.ofUnit(value, NMemoryUnit.BYTE, iec);
    }

    public static NMemorySize ofKiloBytes(long value, boolean iec) {
        return NMemorySize.ofUnit(value, NMemoryUnit.KILO_BYTE, iec);
    }

    public static NMemorySize ofMegaBytes(long value, boolean iec) {
        return NMemorySize.ofUnit(value, NMemoryUnit.MEGA_BYTE, iec);
    }

    public static NMemorySize ofTeraBytes(long value, boolean iec) {
        return NMemorySize.ofUnit(value, NMemoryUnit.TERA_BYTE, iec);
    }

    public static NMemorySize ofPetaBytes(long value, boolean iec) {
        return NMemorySize.ofUnit(value, NMemoryUnit.PETA_BYTE, iec);
    }

    public static NMemorySize ofZetaBytes(long value, boolean iec) {
        return NMemorySize.ofUnit(value, NMemoryUnit.ZETA_BYTE, iec);
    }

    public static NMemorySize ofUnitOnly(long value, NMemoryUnit unit, boolean iec) {
        long[] values = new long[NMemoryUnit.values().length];
        values[unit.ordinal()] = value;
        return new NMemorySize(values, null, null, iec);
    }

    public static NMemorySize ofUnit(long valueInUnit, NMemoryUnit unit, boolean iec) {
        return NMemorySize.ofUnitOnly(valueInUnit, unit, iec).canonicalize();
    }

    public static NMemorySize ofBytes(long durationMillis, NMemoryUnit smallestUnit, NMemoryUnit largestUnit, boolean iec) {
        return new NMemorySize(durationMillis, 0, smallestUnit, largestUnit, iec);
    }

    public static NMemorySize ofBytesAndBits(long bytes, int bits, boolean iec) {
        return new NMemorySize(bytes, bits, iec);
    }

    public static NMemorySize of(long[] values, NMemoryUnit smallestUnit, NMemoryUnit largestUnit, boolean iec) {
        return new NMemorySize(values, smallestUnit, largestUnit, iec);
    }

    public static NMemorySize of(long[] values, boolean iec) {
        return NMemorySize.of(values, null, null, iec);
    }

    public NMemoryUnit firstNonZeroUp(NMemoryUnit unit) {
        NMemoryUnit[] values = NMemoryUnit.values();
        for (int o = unit.ordinal(); o < values.length; ++o) {
            if (this.get(values[o]) == 0L) continue;
            return values[o];
        }
        return null;
    }

    public NMemoryUnit firstNonZeroDown(NMemoryUnit unit) {
        NMemoryUnit[] values = NMemoryUnit.values();
        for (int o = unit.ordinal(); o > 0; --o) {
            if (this.get(values[o]) == 0L) continue;
            return values[o];
        }
        return null;
    }

    public boolean isZero(NMemoryUnit fromIclusive, NMemoryUnit toInclusive) {
        for (int i = fromIclusive.ordinal(); i <= toInclusive.ordinal(); ++i) {
            if (this.get(NMemoryUnit.values()[i]) == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean isZeroDown(NMemoryUnit unit) {
        return this.isZero(NMemoryUnit.BIT, unit);
    }

    public boolean isZeroUp(NMemoryUnit unit) {
        return this.isZero(unit, NMemoryUnit.TERA_BYTE);
    }

    public long getAs(NMemoryUnit unit) {
        switch (unit) {
            case ZETA_BYTE: {
                return this.getAsZetaBytes();
            }
            case PETA_BYTE: {
                return this.getAsPetaBytes();
            }
            case TERA_BYTE: {
                return this.getAsTeraBytes();
            }
            case MEGA_BYTE: {
                return this.getAsMegaBytes();
            }
            case KILO_BYTE: {
                return this.getAsKiloBytes();
            }
            case BYTE: {
                return this.getAsBytes();
            }
            case BIT: {
                return this.getAsBits();
            }
        }
        return 0L;
    }

    private void add(NMemoryUnit unit, long value) {
        int n = unit.ordinal();
        this.values[n] = this.values[n] + value;
    }

    private void set(NMemoryUnit unit, long value) {
        this.values[unit.ordinal()] = value;
    }

    public long get(NMemoryUnit unit) {
        return this.values[unit.ordinal()];
    }

    public long getBits() {
        return this.get(NMemoryUnit.BIT);
    }

    public long getBytes() {
        return this.get(NMemoryUnit.BYTE);
    }

    public long getKiloBytes() {
        return this.get(NMemoryUnit.KILO_BYTE);
    }

    public long getMegaBytes() {
        return this.get(NMemoryUnit.MEGA_BYTE);
    }

    public long getTeraBytes() {
        return this.get(NMemoryUnit.TERA_BYTE);
    }

    public long getPetaBytes() {
        return this.get(NMemoryUnit.PETA_BYTE);
    }

    public long getZetaBytes() {
        return this.get(NMemoryUnit.ZETA_BYTE);
    }

    public NMemoryUnit getLargestUnit() {
        return this.largestUnit;
    }

    public NMemoryUnit getSmallestUnit() {
        return this.smallestUnit;
    }

    public long getAsZetaBytes() {
        return this.bytes / (this.KB * this.KB * this.KB * this.KB * this.KB);
    }

    public long getAsPetaBytes() {
        return this.bytes / (this.KB * this.KB * this.KB * this.KB);
    }

    public long getAsTeraBytes() {
        return this.bytes / (this.KB * this.KB * this.KB);
    }

    public long getAsMegaBytes() {
        return this.bytes / (this.KB * this.KB);
    }

    public long getAsKiloBytes() {
        return this.bytes / this.KB;
    }

    public long getAsBytes() {
        return this.bytes;
    }

    public long getAsBits() {
        return this.bytes * 8L + (long)this.bits;
    }

    public long getMemoryBytes() {
        return this.bytes;
    }

    public int getMemoryBits() {
        return this.bits;
    }

    public boolean isIEC() {
        return this.iec;
    }

    public NMemorySize withIEC(boolean iec) {
        if (this.iec == iec) {
            return this;
        }
        return new NMemorySize(this.toUnitsArray(), this.smallestUnit, this.largestUnit, iec);
    }

    public NMemorySize withSmallestUnit(NMemoryUnit smallestUnit) {
        if (smallestUnit == this.getSmallestUnit()) {
            return this;
        }
        NMemorySize d = new NMemorySize(this.toUnitsArray(), smallestUnit, this.largestUnit, this.iec);
        return d.canonicalize();
    }

    public NMemorySize normalize() {
        return this.withUnits(NMemoryUnit.BIT, NMemoryUnit.ZETA_BYTE).canonicalize();
    }

    public NMemorySize withLargestUnit() {
        return this.withLargestUnit(NMemoryUnit.ZETA_BYTE);
    }

    public NMemorySize withSmallestUnit() {
        return this.withSmallestUnit(NMemoryUnit.BIT);
    }

    public NMemorySize withLargestUnit(NMemoryUnit largestUnit) {
        if (largestUnit == this.getLargestUnit()) {
            return this;
        }
        NMemorySize d = new NMemorySize(this.toUnitsArray(), this.smallestUnit, largestUnit, this.iec);
        return d.canonicalize();
    }

    public NMemorySize withUnits(NMemoryUnit smallestUnit, NMemoryUnit largestUnit) {
        if (smallestUnit == null) {
            smallestUnit = this.getSmallestUnit();
        }
        if (largestUnit == null) {
            largestUnit = this.getLargestUnit();
        }
        if (smallestUnit == this.getSmallestUnit() && largestUnit == this.getLargestUnit()) {
            return this;
        }
        NMemorySize d = new NMemorySize(this.toUnitsArray(), smallestUnit, largestUnit, this.iec);
        if (this.bytes != d.bytes || this.bits != d.bits) {
            throw new IllegalArgumentException("unexpected");
        }
        return d.canonicalize();
    }

    private boolean normalizeNegativeUnit(long[] values, NMemoryUnit curr, NMemoryUnit next, long multiplier) {
        if (values[curr.ordinal()] < 0L) {
            if (values[next.ordinal()] > 0L) {
                long requiredMicros = -values[next.ordinal()] / multiplier;
                if (requiredMicros * multiplier < -values[next.ordinal()]) {
                    ++requiredMicros;
                }
                if ((requiredMicros = Math.min(requiredMicros, values[next.ordinal()])) > 0L) {
                    int n = curr.ordinal();
                    values[n] = values[n] + requiredMicros * multiplier;
                    int n2 = next.ordinal();
                    values[n2] = values[n2] - requiredMicros;
                }
                return values[curr.ordinal()] < 0L;
            }
            return true;
        }
        return false;
    }

    public NMemorySize neg() {
        long[] a = this.toUnitsArray();
        for (int i = 0; i < a.length; ++i) {
            a[i] = -a[i];
        }
        return NMemorySize.of(a, this.smallestUnit, this.largestUnit, this.iec);
    }

    public NMemorySize add(NMemorySize other) {
        long[] a = this.toUnitsArray();
        long[] b = other.toUnitsArray();
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] + b[i];
        }
        return NMemorySize.of(a, this.smallestUnit.compareTo(other.getSmallestUnit()) < 0 ? this.smallestUnit : other.smallestUnit, this.largestUnit.compareTo(other.getSmallestUnit()) > 0 ? this.largestUnit : other.smallestUnit, this.iec);
    }

    public NMemorySize mul(double other) {
        double ms = (double)this.bytes * other;
        long msL = (long)((double)this.bytes * other);
        long ns = (long)((double)this.bits * other + (ms - (double)msL) * 8.0);
        return NMemorySize.ofBytesAndBits(msL, (int)ns, this.iec).withUnits(this.smallestUnit, this.largestUnit);
    }

    public NMemorySize mul(long other) {
        long[] a = this.toUnitsArray();
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] * other;
        }
        return NMemorySize.of(a, this.smallestUnit, this.largestUnit, this.iec);
    }

    public NMemorySize subtract(NMemorySize other) {
        long[] a = this.toUnitsArray();
        long[] b = other.toUnitsArray();
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] - b[i];
        }
        return NMemorySize.of(a, this.smallestUnit.compareTo(other.getSmallestUnit()) < 0 ? this.smallestUnit : other.smallestUnit, this.largestUnit.compareTo(other.getSmallestUnit()) > 0 ? this.largestUnit : other.smallestUnit, this.iec);
    }

    public NMemorySize canonicalize() {
        long n;
        int i;
        long[] values = this.toUnitsArray();
        NMemoryUnit[] mUnits = NMemoryUnit.values();
        for (int i2 = 0; i2 < mUnits.length - 1; ++i2) {
            NMemoryUnit value = mUnits[i2];
            long mul = i2 == 0 ? 8L : this.KB;
            for (int j = i2; j < mUnits.length && this.normalizeNegativeUnit(values, value, mUnits[j], mul); ++j) {
                mul *= this.KB;
            }
        }
        NMemoryUnit[] memUnits = mUnits;
        block2: for (i = 0; i < memUnits.length - 1; ++i) {
            n = values[i];
            if (n >= 0L) continue;
            long mul = 1L;
            for (int j = i + 1; j < memUnits.length; ++j) {
                mul *= j == 1 ? 8L : this.KB;
                long p = values[j];
                if (p <= 0L) continue;
                long u = -n / mul;
                if (-n % mul > 0L) {
                    ++u;
                }
                long x = Math.min(p, u);
                int n2 = j;
                values[n2] = values[n2] - x;
                values[i] = n += x * mul;
                if (n >= 0L) continue block2;
            }
        }
        for (i = 0; i < memUnits.length - 1; ++i) {
            long r;
            n = values[i];
            long l = r = i == 0 ? 8L : this.KB;
            if (n < r) continue;
            values[i] = n % r;
            int n3 = i + 1;
            values[n3] = values[n3] + n / r;
        }
        NMemorySize d = new NMemorySize(values, this.smallestUnit, this.largestUnit, this.iec);
        if (this.bytes != d.bytes || this.bits != d.bits) {
            throw new IllegalArgumentException("unexpected " + d + "<>" + this);
        }
        return d;
    }

    public boolean isZero() {
        return (this.bytes | (long)this.bits) == 0L;
    }

    public long[] toUnitsArray() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    public String toString() {
        return NMemorySizeFormat.DEFAULT.format(this);
    }

    public String toString(boolean fixed, Boolean iec) {
        return NMemorySizeFormat.of(fixed, iec).format(this);
    }

    public String toString(boolean fixed) {
        return NMemorySizeFormat.of(fixed, null).format(this);
    }

    public static NOptional<NMemorySize> parse(String value, NMemoryUnit defaultUnit) {
        if (defaultUnit == null) {
            defaultUnit = NMemoryUnit.BYTE;
        }
        if ((value = NStringUtils.trimToNull(value)) == null) {
            return NOptional.ofNull();
        }
        NStreamTokenizer st = new NStreamTokenizer(new StringReader(value));
        try {
            int r = st.nextToken();
            switch (r) {
                case -15: 
                case -14: 
                case -13: 
                case -12: 
                case -11: 
                case -10: 
                case -2: {
                    Number nval = st.nval;
                    StringBuilder sb = new StringBuilder();
                    while ((r = st.nextToken()) != -1) {
                        if (r == 32) continue;
                        if (r >= 97 && r <= 122 || r >= 65 && r <= 90) {
                            sb.append((char)r);
                            continue;
                        }
                        String finalValue = value;
                        int finalR = r;
                        return NOptional.ofError(() -> NMsg.ofC("unexpected char %s in memory size : %s", String.valueOf((char)finalR), String.valueOf(finalValue)));
                    }
                    String unitString = sb.toString();
                    if (unitString.isEmpty()) {
                        return NOptional.of(NMemorySize.ofUnit(nval.longValue(), defaultUnit, false));
                    }
                    return NOptional.ofNull();
                }
            }
        }
        catch (Exception ie) {
            String finalValue1 = value;
            return NOptional.ofError(() -> NMsg.ofC("erroneous memory size : %s", String.valueOf(finalValue1)), (Throwable)ie);
        }
        String finalValue1 = value;
        return NOptional.ofError(() -> NMsg.ofC("erroneous memory size : %s", String.valueOf(finalValue1)));
    }

    public NMemorySize reduceToLargestUnit() {
        return this.withSmallestUnit(this.getLargestUnit());
    }

    public NMemorySize reduceToSmallestUnit() {
        return this.withSmallestUnit(this.getSmallestUnit());
    }

    public NMemorySize reduceToUnit(NMemoryUnit unit) {
        if (unit == null) {
            return this;
        }
        return new NMemorySize(this.toUnitsArray(), unit, unit, this.iec);
    }
}

