/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NMapSideStrategy;
import net.thevpc.nuts.util.NOptional;

public class NMapStrategy {
    private static final NMapStrategy[][] _CACHE = new NMapStrategy[NMapSideStrategy.values().length][NMapSideStrategy.values().length];
    public static final NMapStrategy ANY = NMapStrategy.of(NMapSideStrategy.ANY, NMapSideStrategy.ANY);
    public static final NMapStrategy TARGET_NON_NULL = NMapStrategy.of(NMapSideStrategy.ANY, NMapSideStrategy.NON_NULL);
    public static final NMapStrategy SOURCE_NON_NULL = NMapStrategy.of(NMapSideStrategy.NON_NULL, NMapSideStrategy.ANY);
    private NMapSideStrategy source;
    private NMapSideStrategy target;

    public static NMapStrategy of(NMapSideStrategy source, NMapSideStrategy target) {
        int to;
        int so;
        NMapStrategy o;
        if (source == null) {
            source = NMapSideStrategy.ANY;
        }
        if (target == null) {
            target = NMapSideStrategy.ANY;
        }
        if ((o = _CACHE[so = source.ordinal()][to = target.ordinal()]) != null) {
            return o;
        }
        NMapStrategy._CACHE[so][to] = o = new NMapStrategy(source, target);
        return o;
    }

    public NMapStrategy(NMapSideStrategy source, NMapSideStrategy target) {
        NAssert.requireNonNull(source, "source");
        NAssert.requireNonNull(target, "target");
        this.source = source;
        this.target = target;
    }

    public NMapSideStrategy source() {
        return this.source;
    }

    public NMapSideStrategy target() {
        return this.target;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NMapStrategy that = (NMapStrategy)o;
        return this.source == that.source && this.target == that.target;
    }

    public int hashCode() {
        return Objects.hash(this.source, this.target);
    }

    public String toString() {
        return "NMapStrategy{source=" + this.source + ", target=" + this.target + '}';
    }

    public <T> boolean applyOptional(Supplier<NOptional<T>> sourceGetter, Supplier<NOptional<T>> targetGetter, Consumer<T> targetSetter) {
        return this.apply(() -> ((NOptional)sourceGetter.get()).orNull(), () -> ((NOptional)targetGetter.get()).orNull(), targetSetter);
    }

    public <T> boolean apply(Supplier<T> sourceGetter, Supplier<T> targetGetter, Consumer<T> targetSetter) {
        Supplier<Object> sourceGetter2;
        switch (this.source) {
            case ANY: {
                sourceGetter2 = sourceGetter;
                break;
            }
            case NULL: {
                Object s = sourceGetter.get();
                if (s == null) {
                    sourceGetter2 = () -> s;
                    break;
                }
                return false;
            }
            case NON_NULL: {
                Object s = sourceGetter.get();
                if (s != null) {
                    sourceGetter2 = () -> s;
                    break;
                }
                return false;
            }
            case BLANK: {
                Object s = sourceGetter.get();
                if (NBlankable.isBlank(s)) {
                    sourceGetter2 = () -> s;
                    break;
                }
                return false;
            }
            case NON_BLANK: {
                Object s = sourceGetter.get();
                if (!NBlankable.isBlank(s)) {
                    sourceGetter2 = () -> s;
                    break;
                }
                return false;
            }
            default: {
                return false;
            }
        }
        switch (this.target) {
            case ANY: {
                targetSetter.accept(sourceGetter2.get());
                return true;
            }
            case NULL: {
                T t = targetGetter.get();
                if (t == null) {
                    targetSetter.accept(sourceGetter2.get());
                    return true;
                }
                return false;
            }
            case BLANK: {
                T t = targetGetter.get();
                if (NBlankable.isBlank(t)) {
                    targetSetter.accept(sourceGetter2.get());
                    return true;
                }
                return false;
            }
            case NON_BLANK: {
                T t = targetGetter.get();
                if (!NBlankable.isBlank(t)) {
                    targetSetter.accept(sourceGetter2.get());
                    return true;
                }
                return false;
            }
            case NON_NULL: {
                T t = targetGetter.get();
                if (t != null) {
                    targetSetter.accept(sourceGetter2.get());
                    return true;
                }
                return false;
            }
        }
        return false;
    }
}

