/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class NMapBuilder<K, V> {
    private Map<K, V> base;
    private boolean ignoreNulls;

    public static <K, V> NMapBuilder<K, V> of() {
        return new NMapBuilder(new HashMap());
    }

    public static <K, V> NMapBuilder<K, V> ofLinked() {
        return new NMapBuilder(new LinkedHashMap());
    }

    public static <K, V> NMapBuilder<K, V> ofSorted() {
        return new NMapBuilder(new TreeMap());
    }

    public static <K, V> NMapBuilder<K, V> ofSorted(Comparator<? super K> comparator) {
        return new NMapBuilder(new TreeMap(comparator));
    }

    public boolean isIgnoreNulls() {
        return this.ignoreNulls;
    }

    public NMapBuilder<K, V> setIgnoreNulls(boolean ignoreNulls) {
        this.ignoreNulls = ignoreNulls;
        return this;
    }

    public NMapBuilder(Map<K, V> base) {
        this.base = base == null ? new HashMap() : base;
    }

    public NMapBuilder<K, V> put(K k, V v) {
        if (this.ignoreNulls) {
            if (k != null) {
                this.base.put(k, v);
            }
        } else {
            this.base.put(k, v);
        }
        return this;
    }

    public NMapBuilder<K, V> putAll(Map.Entry<K, V> ... k) {
        block3: {
            block2: {
                if (!this.ignoreNulls) break block2;
                if (k == null) break block3;
                for (Map.Entry<K, V> k1 : k) {
                    if (k1 == null || k1.getKey() == null) continue;
                    this.base.put(k1.getKey(), k1.getValue());
                }
                break block3;
            }
            for (Map.Entry<K, V> k1 : k) {
                this.base.put(k1.getKey(), k1.getValue());
            }
        }
        return this;
    }

    public NMapBuilder<K, V> putAll(Map<K, V> map) {
        if (this.ignoreNulls) {
            if (map != null) {
                for (Map.Entry<K, V> k1 : map.entrySet()) {
                    if (k1.getKey() == null) continue;
                    this.base.put(k1.getKey(), k1.getValue());
                }
            }
        } else {
            this.base.putAll(map);
        }
        return this;
    }

    public int size() {
        return this.base.size();
    }

    public Map<K, V> build() {
        return this.base;
    }
}

