/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import net.thevpc.nuts.util.NCoalesceIterator;
import net.thevpc.nuts.util.NComparator;
import net.thevpc.nuts.util.NConvertedNonNullIterator;
import net.thevpc.nuts.util.NDistinctPredicate;
import net.thevpc.nuts.util.NDistinctWithConverterPredicate;
import net.thevpc.nuts.util.NErrorHandlerIterator;
import net.thevpc.nuts.util.NFilteredIterator;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorAdapter;
import net.thevpc.nuts.util.NIteratorBuilder;
import net.thevpc.nuts.util.NIteratorEmpty;
import net.thevpc.nuts.util.NIteratorErrorHandlerType;
import net.thevpc.nuts.util.NIteratorFromJavaIterator;
import net.thevpc.nuts.util.NIteratorSorted;
import net.thevpc.nuts.util.NIteratorWithDescription;
import net.thevpc.nuts.util.NPushBackIterator;
import net.thevpc.nuts.util.NQueueIterator;

public class NIteratorUtils {
    public static <T> NIterator<T> safe(NIteratorErrorHandlerType type, NIterator<T> t) {
        return new NErrorHandlerIterator<T>(type, t);
    }

    public static <T> NIterator<T> safeIgnore(NIterator<T> t) {
        return new NErrorHandlerIterator<T>(NIteratorErrorHandlerType.IGNORE, t);
    }

    public static <T> NIterator<T> safePospone(NIterator<T> t) {
        return new NErrorHandlerIterator<T>(NIteratorErrorHandlerType.POSTPONE, t);
    }

    public static <T> boolean isNullOrEmpty(Iterator<T> t) {
        if (t == null) {
            return true;
        }
        if (t == NIteratorBuilder.EMPTY_ITERATOR) {
            return true;
        }
        if (t == Collections.emptyIterator()) {
            return true;
        }
        if (t instanceof NIteratorWithDescription) {
            NIterator base = ((NIteratorWithDescription)t).getBase();
            return NIteratorUtils.isNullOrEmpty(base);
        }
        if (t instanceof NIteratorAdapter) {
            Iterator base = ((NIteratorAdapter)t).getBase();
            return NIteratorUtils.isNullOrEmpty(base);
        }
        return t instanceof NIteratorEmpty;
    }

    public static <T> NIterator<T> nonNull(NIterator<T> t) {
        if (t == null) {
            return NIteratorBuilder.emptyIterator();
        }
        return t;
    }

    public static <T> NIterator<T> concat(List<NIterator<? extends T>> all) {
        if (all == null || all.isEmpty()) {
            return NIteratorBuilder.emptyIterator();
        }
        NQueueIterator<T> t = new NQueueIterator<T>();
        for (NIterator<T> nIterator : all) {
            if (NIteratorUtils.isNullOrEmpty(nIterator)) continue;
            if (nIterator instanceof NQueueIterator) {
                NQueueIterator tt = (NQueueIterator)nIterator;
                for (NIterator it1 : tt.getChildren()) {
                    t.add(it1);
                }
                continue;
            }
            t.add(nIterator);
        }
        int tsize = t.size();
        if (tsize == 0) {
            return NIteratorBuilder.emptyIterator();
        }
        if (tsize == 1) {
            return t.getChildren()[0];
        }
        return t;
    }

    public static <T> NIterator<T> coalesce2(List<NIterator<T>> all) {
        return NIteratorUtils.coalesce(all);
    }

    public static <T> NIterator<T> coalesce(NIterator<? extends T> ... all) {
        return NIteratorUtils.coalesce(Arrays.asList(all));
    }

    public static <T> NIterator<T> concat(NIterator<? extends T> ... all) {
        return NIteratorUtils.concat(Arrays.asList(all));
    }

    public static <T> NIterator<T> concatLists(List<NIterator<? extends T>> ... all) {
        ArrayList<NIterator<T>> r = new ArrayList<NIterator<T>>();
        if (all != null) {
            for (List<NIterator<T>> list : all) {
                if (list == null) continue;
                for (NIterator<? extends T> nIterator : list) {
                    if (nIterator == null) continue;
                    r.add(nIterator);
                }
            }
        }
        return NIteratorUtils.concat(r);
    }

    public static <T> NIterator<T> coalesce(List<NIterator<? extends T>> all) {
        if (all == null || all.isEmpty()) {
            return NIteratorBuilder.emptyIterator();
        }
        NCoalesceIterator<T> t = new NCoalesceIterator<T>();
        for (NIterator<T> nIterator : all) {
            if (NIteratorUtils.isNullOrEmpty(nIterator)) continue;
            t.add(nIterator);
        }
        int tsize = t.size();
        if (tsize == 0) {
            return NIteratorBuilder.emptyIterator();
        }
        if (tsize == 1) {
            return t.getChildren()[0];
        }
        return t;
    }

    public static <F, T> NIterator<T> convertNonNull(NIterator<F> from, Function<F, T> converter, String name) {
        if (NIteratorUtils.isNullOrEmpty(from)) {
            return NIteratorBuilder.emptyIterator();
        }
        return new NConvertedNonNullIterator<F, T>(from, converter, name);
    }

    public static <T> List<T> toList(Iterator<T> it) {
        if (NIteratorUtils.isNullOrEmpty(it)) {
            return Collections.emptyList();
        }
        ArrayList<T> a = new ArrayList<T>();
        while (it.hasNext()) {
            a.add(it.next());
        }
        return a;
    }

    public static <T> Set<T> toSet(NIterator<T> it) {
        if (NIteratorUtils.isNullOrEmpty(it)) {
            return Collections.emptySet();
        }
        LinkedHashSet a = new LinkedHashSet();
        while (it.hasNext()) {
            a.add(it.next());
        }
        return a;
    }

    public static <T> Set<T> toTreeSet(NIterator<T> it, NComparator<T> c) {
        if (NIteratorUtils.isNullOrEmpty(it)) {
            return Collections.emptySet();
        }
        TreeSet<T> a = new TreeSet<T>(c);
        while (it.hasNext()) {
            a.add(it.next());
        }
        return a;
    }

    public static <T> NIterator<T> sort(NIterator<T> it, NComparator<T> c, boolean removeDuplicates) {
        if (NIteratorUtils.isNullOrEmpty(it)) {
            return NIteratorBuilder.emptyIterator();
        }
        return new NIteratorSorted<T>(it, c, removeDuplicates);
    }

    public static <T> NIterator<T> distinct(NIterator<T> it) {
        if (NIteratorUtils.isNullOrEmpty(it)) {
            return NIteratorBuilder.emptyIterator();
        }
        NDistinctPredicate filter = new NDistinctPredicate();
        return new NFilteredIterator<T>(it, filter);
    }

    public static <F, T> NIterator<F> distinct(NIterator<F> it, Function<F, T> converter) {
        if (NIteratorUtils.isNullOrEmpty(it)) {
            return NIteratorBuilder.emptyIterator();
        }
        if (converter == null) {
            NDistinctPredicate filter = new NDistinctPredicate();
            return new NFilteredIterator<F>(it, filter);
        }
        NDistinctWithConverterPredicate<F, T> filter = new NDistinctWithConverterPredicate<F, T>(converter);
        return new NFilteredIterator<F>(it, filter);
    }

    public static <T> NIteratorFromJavaIterator<T> collector(Iterator<T> it) {
        if (it == null) {
            return new NIteratorFromJavaIterator(null, NIteratorBuilder.emptyIterator());
        }
        return new NIteratorFromJavaIterator<T>(null, it);
    }

    public static <T> NIterator<T> nullifyIfEmpty(NIterator<T> other) {
        if (other == null) {
            return null;
        }
        if (other instanceof NPushBackIterator) {
            NPushBackIterator b = (NPushBackIterator)other;
            if (!b.isEmpty()) {
                return b;
            }
            return null;
        }
        NPushBackIterator<T> b = new NPushBackIterator<T>(other);
        if (!b.isEmpty()) {
            return b;
        }
        return null;
    }
}

