/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.Iterator;
import java.util.List;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.util.NComparator;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorBase;
import net.thevpc.nuts.util.NIteratorUtils;

class NIteratorSorted<T>
extends NIteratorBase<T> {
    private final boolean removeDuplicates;
    private final NIterator<T> it;
    private final NComparator<T> c;
    Iterator<T> base;

    public NIteratorSorted(NIterator<T> it, NComparator<T> c, boolean removeDuplicates) {
        this.removeDuplicates = removeDuplicates;
        this.it = it;
        this.c = c;
        this.base = null;
    }

    @Override
    public NElement describe() {
        return NElementDescribables.describeResolveOrDestructAsObject(this.base).builder().set("sort", (NElement)NElement.ofObjectBuilder().set("comparator", NElementDescribables.describeResolveOrDestruct(this.c)).set("distinct", this.removeDuplicates).build()).build();
    }

    public Iterator<T> getBase() {
        if (this.base == null) {
            if (this.removeDuplicates) {
                this.base = NIteratorUtils.toTreeSet(this.it, this.c).iterator();
            } else {
                List<T> a = NIteratorUtils.toList(this.it);
                a.sort(this.c);
                this.base = a.iterator();
            }
        }
        return this.base;
    }

    @Override
    public boolean hasNext() {
        return this.getBase().hasNext();
    }

    @Override
    public T next() {
        return this.getBase().next();
    }

    public String toString() {
        if (this.removeDuplicates) {
            return "SortDistinct(" + this.it + ")";
        }
        return "SortDuplicates(" + this.it + ")";
    }
}

