/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.thevpc.nuts.concurrent.NRunnable;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NComparator;
import net.thevpc.nuts.util.NConvertedIterator;
import net.thevpc.nuts.util.NErrorHandlerIterator;
import net.thevpc.nuts.util.NFilteredIterator;
import net.thevpc.nuts.util.NFlatMapIterator;
import net.thevpc.nuts.util.NFunction;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorAdapter;
import net.thevpc.nuts.util.NIteratorEmpty;
import net.thevpc.nuts.util.NIteratorErrorHandlerType;
import net.thevpc.nuts.util.NIteratorOnFinish;
import net.thevpc.nuts.util.NIteratorUtils;
import net.thevpc.nuts.util.NOnStartIterator;
import net.thevpc.nuts.util.NPredicate;
import net.thevpc.nuts.util.NPredicates;
import net.thevpc.nuts.util.NSupplierIteratorJ;

public class NIteratorBuilder<T> {
    public static final NPredicate NON_NULL = NPredicates.isNull().negate();
    public static final NPredicate NON_BLANK = NPredicates.blank().negate();
    static final NIteratorEmpty EMPTY_ITERATOR = new NIteratorEmpty();
    private final NIterator<T> it;

    private NIteratorBuilder(NIterator<T> it) {
        if (it == null) {
            it = NIteratorBuilder.emptyIterator();
        }
        this.it = it;
    }

    public static <T> NIteratorBuilder<T> ofCoalesce(List<NIterator<? extends T>> t) {
        return new NIteratorBuilder<T>(NIteratorUtils.coalesce(t));
    }

    public static <T> NIteratorBuilder<T> ofConcat(List<NIterator<? extends T>> t) {
        return new NIteratorBuilder<T>(NIteratorUtils.concat(t));
    }

    public static <T> NIteratorBuilder<T> of(NIterator<T> t) {
        return new NIteratorBuilder<T>(t);
    }

    public static <T> NIteratorBuilder<T> ofRunnable(NRunnable t) {
        return NIteratorBuilder.of(NIteratorBuilder.emptyIterator()).onStart(t);
    }

    public static <T> NIteratorBuilder<T> ofRunnable(Runnable t, String n) {
        return NIteratorBuilder.ofRunnable((NRunnable)NRunnable.of(t).redescribe((Supplier)NElementDescribables.ofDesc(n)));
    }

    public static <T> NIteratorBuilder<T> ofSupplier(Supplier<Iterator<T>> from, Supplier<NElement> name) {
        return NIteratorBuilder.of(new NSupplierIteratorJ<T>(from, name).redescribe((Supplier)name));
    }

    public static <T> NIteratorBuilder<T> ofArrayValues(T[] t, NElement n) {
        return NIteratorBuilder.ofArrayValues(t, () -> n);
    }

    public static <T> NIteratorBuilder<T> ofArrayValues(T[] t, String n) {
        return NIteratorBuilder.ofArrayValues(t, () -> NElement.ofString(n));
    }

    public static <T> NIteratorBuilder<T> ofArrayValues(T[] t, Supplier<NElement> n) {
        return NIteratorBuilder.of(t == null ? NIteratorBuilder.emptyIterator() : new NIteratorAdapter<T>(Arrays.asList(t).iterator(), n));
    }

    public static <T> NIterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <T> NIteratorBuilder<T> emptyBuilder() {
        return NIteratorBuilder.of(EMPTY_ITERATOR);
    }

    public static <T> NIteratorBuilder<T> ofFlatMap(NIterator<? extends Collection<T>> from) {
        if (from == null) {
            return NIteratorBuilder.emptyBuilder();
        }
        return NIteratorBuilder.of(new NFlatMapIterator(from, Collection::iterator));
    }

    public NIteratorBuilder<T> filter(Predicate<? super T> t, Supplier<NElement> e) {
        if (t == null) {
            return this;
        }
        return NIteratorBuilder.of(new NFilteredIterator<T>(this.it, (Predicate)NPredicate.of(t).redescribe(e)));
    }

    public NIteratorBuilder<T> filter(NPredicate<? super T> t) {
        if (t == null) {
            return this;
        }
        return new NIteratorBuilder<T>(new NFilteredIterator<T>(this.it, t));
    }

    public NIteratorBuilder<T> concat(NIteratorBuilder<T> t) {
        return this.concat(t.it);
    }

    public NIteratorBuilder<T> concat(NIterator<T> t) {
        if (t == null) {
            return this;
        }
        return new NIteratorBuilder(NIteratorUtils.concat(Arrays.asList(this.it, t)));
    }

    public <V> NIteratorBuilder<V> map(NFunction<? super T, ? extends V> t) {
        return new NIteratorBuilder<T>(new NConvertedIterator<T, V>(this.it, t));
    }

    public <V> NIteratorBuilder<V> flatMap(Function<? super T, ? extends Iterator<? extends V>> fun) {
        return NIteratorBuilder.of(new NFlatMapIterator(this.it, fun));
    }

    public <V> NIteratorBuilder<V> mapMulti(NFunction<T, List<V>> mapper) {
        return new NIteratorBuilder<T>(new NFlatMapIterator(this.it, t -> ((List)mapper.apply(t)).iterator()));
    }

    public <V> NIteratorBuilder<T> sort(NComparator<T> t, boolean removeDuplicates) {
        return new NIteratorBuilder<T>(NIteratorUtils.sort(this.it, t, removeDuplicates));
    }

    public <V> NIteratorBuilder<T> distinct() {
        return this.distinct(null);
    }

    public <V> NIteratorBuilder<T> distinct(NFunction<T, V> t) {
        if (t == null) {
            return new NIteratorBuilder<T>(NIteratorUtils.distinct(this.it));
        }
        return new NIteratorBuilder<T>(NIteratorUtils.distinct(this.it, t));
    }

    public <V> NIteratorBuilder<T> named(NElement n) {
        if (n != null) {
            NIteratorAdapter<T> a = new NIteratorAdapter<T>(this.it, () -> n);
            return new NIteratorBuilder<T>(a);
        }
        return this;
    }

    public <V> NIteratorBuilder<T> named(NObjectElement nfo) {
        if (nfo != null) {
            return new NIteratorBuilder<T>(new NIteratorAdapter<T>(this.it, () -> nfo));
        }
        return this;
    }

    public NIteratorBuilder<T> safe(NIteratorErrorHandlerType type) {
        return new NIteratorBuilder<T>(new NErrorHandlerIterator<T>(type, this.it));
    }

    public NIteratorBuilder<T> safeIgnore() {
        return this.safe(NIteratorErrorHandlerType.IGNORE);
    }

    public NIteratorBuilder<T> safePostpone() {
        return this.safe(NIteratorErrorHandlerType.POSTPONE);
    }

    public NIteratorBuilder<T> notNull() {
        return this.filter(NON_NULL);
    }

    public NIteratorBuilder<String> notBlank() {
        return this.filter(NON_BLANK);
    }

    public NIterator<T> iterator() {
        return this.it;
    }

    public List<T> list() {
        return NCollections.list(this.it);
    }

    public NIterator<T> build() {
        return this.it;
    }

    public List<T> toList() {
        return NIteratorUtils.toList(this.it);
    }

    public NIteratorBuilder<T> onFinish(NRunnable r) {
        if (r == null) {
            return this;
        }
        return NIteratorBuilder.of(new NIteratorOnFinish<T>(this.it, r));
    }

    public NIteratorBuilder<T> onStart(NRunnable r) {
        if (r == null) {
            return this;
        }
        return NIteratorBuilder.of(new NOnStartIterator<T>(this.it, r));
    }
}

