/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.function.Supplier;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.util.NFunction;
import net.thevpc.nuts.util.NImmutable;

public class NFunctionWithDescription<T, V>
implements NFunction<T, V>,
NImmutable {
    private final NFunction<T, V> base;
    private Supplier<NElement> description;

    public NFunctionWithDescription(NFunction<T, V> base, Supplier<NElement> description) {
        this.base = base;
        this.description = description;
    }

    @Override
    public V apply(T f) {
        return (V)this.base.apply(f);
    }

    @Override
    public NFunction<T, V> redescribe(Supplier<NElement> description) {
        if (description == null) {
            return this.base;
        }
        return new NFunctionWithDescription<T, V>(this.base, description);
    }

    public String toString() {
        if (this.description != null) {
            return this.description.get().toString();
        }
        return "Function{" + this.base + '}';
    }

    @Override
    public NElement describe() {
        return NElementDescribables.safeDescribe(this.description, NElementDescribables.ofDesc(this.base), NElementDescribables.ofLateToString(this));
    }
}

