/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.function.Function;
import java.util.function.Supplier;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementRedescribable;
import net.thevpc.nuts.elem.NElements;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NFunctionFromJavaFunction;
import net.thevpc.nuts.util.NFunctionWithDescription;
import net.thevpc.nuts.util.NUnsafeFunction;
import net.thevpc.nuts.util.UnsafeFunction;

public interface NFunction<T, V>
extends Function<T, V>,
NElementRedescribable<NFunction<T, V>> {
    public static <T, V> NFunction<T, V> of(Function<T, V> o) {
        if (o == null) {
            return null;
        }
        if (o instanceof NFunction) {
            return (NFunction)o;
        }
        return new NFunctionFromJavaFunction<T, V>(o);
    }

    public static <T, V> NFunction<T, V> ofUnsafe(UnsafeFunction<T, V> o, final Function<Exception, ? extends V> onError) {
        NAssert.requireNonNull(o, "function");
        if (o instanceof NFunction) {
            return (NFunction)((Object)o);
        }
        final NUnsafeFunction<T, V> uf = NUnsafeFunction.of(o);
        return new NFunctionFromJavaFunction(new Function<T, V>(){

            @Override
            public V apply(T t) {
                try {
                    return uf.apply(t);
                }
                catch (Exception e) {
                    if (onError == null) {
                        return null;
                    }
                    return onError.apply(e);
                }
            }
        });
    }

    @Override
    default public NElement describe() {
        return NElements.of().toElement("function");
    }

    @Override
    default public NFunction<T, V> redescribe(Supplier<NElement> description) {
        if (description == null) {
            return this;
        }
        return new NFunctionWithDescription(this, description);
    }
}

