/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.util.NIteratorBase;

public class NFlatMapIterator<TT, RR>
extends NIteratorBase<RR> {
    private final Iterator<TT> from;
    private final Function<? super TT, ? extends Iterator<? extends RR>> converter;
    Iterator<? extends RR> current;

    public NFlatMapIterator(Iterator<TT> from, Function<? super TT, ? extends Iterator<? extends RR>> converter) {
        this.from = from;
        this.converter = converter;
        this.current = null;
    }

    @Override
    public NElement describe() {
        return NElement.ofObjectBuilder().name("FlatMap").set("base", NElementDescribables.describeResolveOrDestruct(this.from)).set("mapper", NElementDescribables.describeResolveOrDestruct(this.converter)).build();
    }

    @Override
    public boolean hasNext() {
        while (true) {
            if (this.current == null) {
                if (this.from.hasNext()) {
                    TT p = this.from.next();
                    if (p == null) {
                        this.current = Collections.emptyIterator();
                    } else {
                        this.current = this.converter.apply(p);
                        if (this.current == null) {
                            this.current = Collections.emptyIterator();
                        }
                    }
                } else {
                    return false;
                }
            }
            if (this.current.hasNext()) {
                return true;
            }
            this.current = null;
        }
    }

    @Override
    public RR next() {
        return this.current.next();
    }

    public String toString() {
        return "FlattenIterator(" + this.from + ")";
    }
}

