/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.util.NoSuchElementException;
import net.thevpc.nuts.boot.core.NExceptionWithExitCodeBase;
import net.thevpc.nuts.cmdline.NCmdLineException;
import net.thevpc.nuts.cmdline.NDetachedCmdLineException;
import net.thevpc.nuts.concurrent.NInterruptedException;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.internal.NReservedLangUtils;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.text.NI18n;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssertException;
import net.thevpc.nuts.util.NDetachedAssertException;
import net.thevpc.nuts.util.NExceptionBase;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NNoSuchElementException;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NUnsupportedEnumException;
import net.thevpc.nuts.util.UncheckedException;

public class NExceptions {
    public static NOptional.ExceptionFactory defaultExceptionFactory;

    public static NOptional.ExceptionFactory getDefaultExceptionFactory() {
        return defaultExceptionFactory;
    }

    public static void setDefaultExceptionFactory(NOptional.ExceptionFactory defaultExceptionFactory) {
        NExceptions.defaultExceptionFactory = defaultExceptionFactory;
    }

    public static RuntimeException ofSafeIllegalArgumentException(NMsg e) {
        if (!NWorkspace.get().isPresent()) {
            return new IllegalArgumentException(e.toString());
        }
        return new NIllegalArgumentException(e);
    }

    public static RuntimeException ofSafeIllegalArgumentException(NMsg message, Throwable ex) {
        if (!NWorkspace.get().isPresent()) {
            return new IllegalArgumentException(message.toString(), ex);
        }
        return new NIllegalArgumentException(message, ex);
    }

    public static RuntimeException ofSafeAssertException(NMsg msg) {
        return NExceptions.ofSafeAssertException(msg, null);
    }

    public static RuntimeException ofSafeAssertException(NMsg msg, Throwable ex) {
        RuntimeException r;
        if (defaultExceptionFactory != null && (r = defaultExceptionFactory.createAssertException(msg, ex)) != null) {
            return r;
        }
        if (!NWorkspace.get().isPresent()) {
            return new NDetachedAssertException(msg, ex);
        }
        return new NAssertException(msg, null);
    }

    public static RuntimeException ofSafeCmdLineException(NMsg msg) {
        return NExceptions.ofSafeCmdLineException(msg, null);
    }

    public static RuntimeException ofSafeCmdLineException(NMsg msg, Throwable ex) {
        RuntimeException r;
        if (defaultExceptionFactory != null && (r = defaultExceptionFactory.createCmdLineException(msg, ex)) != null) {
            return r;
        }
        if (!NWorkspace.get().isPresent()) {
            return new NDetachedCmdLineException(msg, ex);
        }
        return new NCmdLineException(msg, null);
    }

    public static RuntimeException ofSafeNoSuchElementException(NMsg message) {
        if (!NWorkspace.get().isPresent()) {
            return new NoSuchElementException(message.toString());
        }
        return new NNoSuchElementException(message);
    }

    public static RuntimeException ofSafeUnexpectedException(NMsg message) {
        if (!NWorkspace.get().isPresent()) {
            return new NoSuchElementException(message.toString());
        }
        return new NNoSuchElementException(message);
    }

    public static RuntimeException ofSafeUnsupportedEnumException(Enum e) {
        if (!NWorkspace.get().isPresent()) {
            return new NoSuchElementException(NMsg.ofC(NI18n.of("unsupported enum value %s"), e).toString());
        }
        return new NUnsupportedEnumException(e);
    }

    public static NOptional<NExceptionBase> resolveExceptionBase(Throwable th) {
        return NReservedLangUtils.findThrowable(th, NExceptionBase.class, null);
    }

    public static NOptional<NExceptionWithExitCodeBase> resolveWithExitCodeExceptionBase(Throwable th) {
        return NReservedLangUtils.findThrowable(th, NExceptionWithExitCodeBase.class, null);
    }

    public static NOptional<Integer> resolveExitCode(Throwable th) {
        return NExceptions.resolveWithExitCodeExceptionBase(th).map(NExceptionWithExitCodeBase::getExitCode);
    }

    public static String getErrorMessage(Throwable ex) {
        return NExceptions.getErrorMessage(ex, 128);
    }

    private static String getErrorMessage(Throwable ex, int maxDepth) {
        String e;
        if (ex instanceof InvocationTargetException && maxDepth > 0 && (e = NExceptions.getErrorMessage(((InvocationTargetException)ex).getTargetException(), maxDepth - 1)) != null) {
            return e;
        }
        String m = ex.getMessage();
        if (m == null || m.length() < 5) {
            m = ex.toString();
        }
        return m;
    }

    public static RuntimeException ofUncheckedException(Throwable e) {
        if (e == null) {
            return new NullPointerException("null exception");
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e instanceof IOException) {
            if (!NWorkspace.get().isPresent()) {
                return new UncheckedIOException((IOException)e);
            }
            return new NIOException(e);
        }
        if (e instanceof InterruptedException) {
            if (!NWorkspace.get().isPresent()) {
                return new NInterruptedException(NMsg.ofC("%s", e.getMessage()), e);
            }
            return new UncheckedException(NExceptions.getErrorMessage(e), e);
        }
        return new UncheckedException(NExceptions.getErrorMessage(e), e);
    }
}

