/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.logging.Level;
import net.thevpc.nuts.app.NApp;
import net.thevpc.nuts.app.NApplications;
import net.thevpc.nuts.boot.NBootException;
import net.thevpc.nuts.boot.NBootOptionsInfo;
import net.thevpc.nuts.boot.core.NExceptionWithExitCodeBase;
import net.thevpc.nuts.boot.internal.cmdline.NBootWorkspaceCmdLineParser;
import net.thevpc.nuts.boot.internal.util.NBootMsg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NSessionAwareExceptionBase;
import net.thevpc.nuts.core.NWorkspaceOptions;
import net.thevpc.nuts.elem.NArrayElementBuilder;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.internal.NApiUtilsRPI;
import net.thevpc.nuts.internal.NReservedLangUtils;
import net.thevpc.nuts.io.NIO;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.text.NContentType;
import net.thevpc.nuts.text.NI18n;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NMsgBuilder;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NAnyFormattedExceptionBase;
import net.thevpc.nuts.util.NException;
import net.thevpc.nuts.util.NExceptions;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;

public class NExceptionHandler {
    private Throwable ex;
    private int code;
    private NLog out;
    private boolean stacktrace;
    private boolean showMessage;
    private boolean gui;
    private NSession session;
    private NPrintStream sessionOut;
    private NMsg messageFormatted;
    private String messageString;
    private boolean built;

    public static NExceptionHandler of(Throwable ex) {
        return NExceptionHandler.of(ex, null);
    }

    public static NExceptionHandler of(Throwable ex, NLog out) {
        if (ex == null) {
            return new NExceptionHandler();
        }
        NSession session = NSessionAwareExceptionBase.resolveSession(ex).orNull();
        if (session != null) {
            return session.callWith(() -> {
                NWorkspaceOptions bo = null;
                bo = session.getWorkspace().getBootOptions().toWorkspaceOptions();
                return new NExceptionHandler().setEx(ex).setShowMessage(true).setOut(out).setStacktrace(NApiUtilsRPI.resolveShowStackTrace(bo)).setGui(NApiUtilsRPI.resolveGui(bo)).build();
            });
        }
        String nutsArgs = NStringUtils.trim(NStringUtils.trim(System.getProperty("nuts.boot.args")) + " " + NStringUtils.trim(System.getProperty("nuts.args")));
        try {
            NBootOptionsInfo options = new NBootOptionsInfo();
            NBootWorkspaceCmdLineParser.parseNutsArguments(NCmdLine.parseDefault(nutsArgs).get().toStringArray(), options);
            return new NExceptionHandler().setEx(ex).setShowMessage(true).setOut(out).setStacktrace(NApiUtilsRPI.resolveShowStackTrace(options)).setGui(NApiUtilsRPI.resolveGui(options)).build();
        }
        catch (Exception e) {
            return new NExceptionHandler().setEx(ex).setShowMessage(true).setOut(out).setStacktrace(true).setGui(false).build();
        }
    }

    public NSession getSession() {
        return this.session;
    }

    public NExceptionHandler setSession(NSession session) {
        this.session = session;
        return this;
    }

    public boolean isShowMessage() {
        return this.showMessage;
    }

    public NExceptionHandler setShowMessage(boolean showMessage) {
        this.showMessage = showMessage;
        return this;
    }

    public Throwable getEx() {
        return this.ex;
    }

    public NExceptionHandler setEx(Throwable ex) {
        this.ex = ex;
        return this;
    }

    public int getCode() {
        return this.code;
    }

    public NExceptionHandler setCode(int code) {
        this.code = code;
        return this;
    }

    public NLog getOut() {
        return this.out;
    }

    public NExceptionHandler setOut(NLog out) {
        this.out = out;
        return this;
    }

    public boolean isStacktrace() {
        return this.stacktrace;
    }

    public NExceptionHandler setStacktrace(boolean stacktrace) {
        this.stacktrace = stacktrace;
        return this;
    }

    public boolean isGui() {
        return this.gui;
    }

    public NExceptionHandler setGui(boolean gui) {
        this.gui = gui;
        return this;
    }

    public NExceptionHandler build() {
        block11: {
            if (this.built) {
                return this;
            }
            this.built = true;
            if (this.ex == null) {
                this.setCode(0);
                return this;
            }
            int errorCode = NExceptions.resolveExitCode(this.ex).orElse(204);
            this.setCode(errorCode);
            if (errorCode == 0) {
                return this;
            }
            this.setSession(NSessionAwareExceptionBase.resolveSession(this.ex).orNull());
            this.messageFormatted = NSessionAwareExceptionBase.resolveSessionAwareExceptionBase(this.ex).map(NAnyFormattedExceptionBase::getFormattedMessage).orNull();
            this.messageString = NExceptions.getErrorMessage(this.ex);
            if (this.getOut() == null) {
                if (this.getSession() != null) {
                    try {
                        this.sessionOut = NIO.of().getSystemTerminal().getErr();
                        if (this.messageFormatted != null) {
                            this.messageFormatted = NMsg.ofNtf(NTextBuilder.of().append((Object)this.messageFormatted, NTextStyle.error()).build());
                            break block11;
                        }
                        this.messageFormatted = NMsg.ofStyledError(this.messageString);
                    }
                    catch (Exception ex2) {
                        NLog.of(NApplications.class).log(NMsg.ofPlain("unable to get system terminal").asFine(ex2));
                    }
                } else if (this.messageFormatted != null) {
                    this.messageFormatted = null;
                }
            } else {
                this.sessionOut = this.getSession() != null ? this.getSession().err() : null;
            }
        }
        return this;
    }

    public NExceptionHandler reThrow() {
        if (this.ex == null) {
            return this;
        }
        NOptional<NExceptionWithExitCodeBase> u = NExceptions.resolveWithExitCodeExceptionBase(this.ex);
        if (u.isPresent()) {
            NExceptionWithExitCodeBase o = u.get();
            if (o instanceof RuntimeException) {
                throw (RuntimeException)((Object)o);
            }
            if (this.session != null) {
                this.session.runWith(() -> {
                    throw new NException(NMsg.ofC("%s", o.toString(), o.getExitCode()));
                });
            }
            throw new NBootException(NBootMsg.ofC("%s", o.toString(), o.getExitCode()));
        }
        throw new NBootException(NBootMsg.ofC("%s", this.ex.toString(), 255));
    }

    public NExceptionHandler showError() {
        this.build();
        if (this.ex == null) {
            return this;
        }
        if (this.showMessage) {
            if (this.sessionOut != null) {
                this.session.runWith(() -> {
                    if (this.session.getOutputFormat().orDefault() == NContentType.PLAIN) {
                        if (this.messageFormatted != null) {
                            this.sessionOut.println(this.messageFormatted);
                        } else {
                            this.sessionOut.println(this.messageString);
                        }
                        if (this.stacktrace) {
                            this.ex.printStackTrace(this.sessionOut.asPrintStream());
                        }
                        this.sessionOut.flush();
                    } else {
                        if (this.messageFormatted != null) {
                            NArrayElementBuilder e;
                            this.session.eout().add(NElement.ofObjectBuilder().set("app-id", NStringUtils.toStringOrEmpty(NApp.of().getId().get())).set("error", NText.of(this.messageFormatted).filteredText()).build());
                            if (this.stacktrace) {
                                this.session.eout().add(NElement.ofObjectBuilder().set("errorTrace", (NElement)NElement.ofArrayBuilder().addAll(NStringUtils.stacktraceArray(this.ex)).build()).build());
                            }
                            if ((e = this.session.eout()).size() > 0) {
                                this.sessionOut.println(e.build());
                                e.clear();
                            }
                            this.sessionOut.flush();
                        } else {
                            NArrayElementBuilder e;
                            this.session.eout().add(NElement.ofObjectBuilder().set("app-id", NStringUtils.toStringOrEmpty(NApp.of().getId().get())).set("error", this.messageString).build());
                            if (this.stacktrace) {
                                this.session.eout().add(NElement.ofObjectBuilder().set("errorTrace", (NElement)NElement.ofArrayBuilder().addAll(NStringUtils.stacktraceArray(this.ex)).build()).build());
                            }
                            if ((e = this.session.eout()).size() > 0) {
                                this.sessionOut.println(e.build());
                                e.clear();
                            }
                            this.sessionOut.flush();
                        }
                        this.sessionOut.flush();
                    }
                });
            } else if (this.out != null) {
                NMsgBuilder msgBuilder = NMsgBuilder.of().withLevel(Level.OFF).withIntent(NMsgIntent.FAIL);
                if (this.messageFormatted != null) {
                    this.out.log(msgBuilder.withMsg(this.messageFormatted));
                } else {
                    this.out.log(msgBuilder.withMsg(NMsg.ofPlain(this.messageString)));
                }
                if (this.stacktrace) {
                    this.out.log(msgBuilder.withMsgPlain("---------------"));
                    this.out.log(msgBuilder.withMsgPlain(">  STACKTRACE :"));
                    this.out.log(msgBuilder.withMsgPlain("---------------"));
                    this.out.log(msgBuilder.withMsgPlain(NStringUtils.stacktrace(this.ex)));
                }
            } else {
                if (this.messageFormatted != null) {
                    System.err.println(this.messageFormatted);
                } else {
                    System.err.println(NMsg.ofPlain(this.messageString));
                }
                if (this.stacktrace) {
                    System.err.println(NMsg.ofPlain("---------------"));
                    System.err.println(NMsg.ofPlain(">  STACKTRACE :"));
                    System.err.println(NMsg.ofPlain("---------------"));
                    System.err.println(NMsg.ofPlain(NStringUtils.stacktrace(this.ex)));
                }
            }
        }
        if (this.gui) {
            StringBuilder sb = new StringBuilder();
            if (this.messageFormatted != null) {
                if (this.session != null) {
                    sb.append(NText.of(this.messageFormatted).filteredText());
                } else {
                    sb.append(this.messageFormatted);
                }
            } else {
                sb.append(this.messageString);
            }
            if (this.stacktrace && sb.length() > 0) {
                sb.append("\n");
                sb.append(NStringUtils.stacktrace(this.ex));
            }
            if (this.session != null) {
                NReservedLangUtils.showMessage(NMsg.ofPlain(sb.toString()).toString(), NI18n.of("Nuts Package Manager - Error"), this.out);
            } else {
                NReservedLangUtils.showMessage(NMsg.ofPlain(sb.toString()).toString(), NI18n.of("Nuts Package Manager - Error"), this.out);
            }
        }
        return this;
    }

    public NExceptionHandler propagate() {
        return this.showError().reThrow();
    }

    public NExceptionHandler handle() {
        return this.showError();
    }

    public void handleFatal() {
        System.exit(this.showError().getCode());
    }
}

